/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.EventLoop;
import io.vertx.core.Handler;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextBase;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.WorkerPool;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public class EventLoopContext
extends ContextBase {
    EventLoopContext(VertxInternal vertx, EventLoop eventLoop, WorkerPool internalBlockingPool, WorkerPool workerPool, Deployment deployment, CloseFuture closeFuture, ClassLoader tccl) {
        super(vertx, eventLoop, internalBlockingPool, workerPool, deployment, closeFuture, tccl);
    }

    @Override
    public Executor executor() {
        return this.nettyEventLoop();
    }

    @Override
    protected void runOnContext(ContextInternal ctx, Handler<Void> action) {
        try {
            this.nettyEventLoop().execute(() -> ctx.dispatch(action));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> void emit(ContextInternal ctx, T argument, Handler<T> task) {
        EventLoop eventLoop = this.nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            ContextInternal prev2 = ctx.beginDispatch();
            try {
                task.handle(argument);
            }
            catch (Throwable t3) {
                this.reportException(t3);
            }
            finally {
                ctx.endDispatch(prev2);
            }
        } else {
            eventLoop.execute(() -> this.emit(ctx, argument, task));
        }
    }

    @Override
    protected <T> void execute(ContextInternal ctx, T argument, Handler<T> task) {
        EventLoop eventLoop = this.nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            task.handle(argument);
        } else {
            eventLoop.execute(() -> task.handle(argument));
        }
    }

    @Override
    protected <T> void execute(ContextInternal ctx, Runnable task) {
        EventLoop eventLoop = this.nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            task.run();
        } else {
            eventLoop.execute(task);
        }
    }

    @Override
    public boolean isEventLoopContext() {
        return true;
    }

    @Override
    public boolean isWorkerContext() {
        return false;
    }

    @Override
    public boolean inThread() {
        return this.nettyEventLoop().inEventLoop();
    }
}

