/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.core.impl.ContextBase;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public class DeploymentManager {
    private static final Logger log = LoggerFactory.getLogger(DeploymentManager.class);
    private final VertxInternal vertx;
    private final Map<String, Deployment> deployments = new ConcurrentHashMap<String, Deployment>();

    public DeploymentManager(VertxInternal vertx) {
        this.vertx = vertx;
    }

    private String generateDeploymentID() {
        return UUID.randomUUID().toString();
    }

    public Future<String> deployVerticle(Callable<Verticle> verticleSupplier, DeploymentOptions options2) {
        if (options2.getInstances() < 1) {
            throw new IllegalArgumentException("Can't specify < 1 instances to deploy");
        }
        options2.checkIsolationNotDefined();
        ContextInternal currentContext = this.vertx.getOrCreateContext();
        ClassLoader cl = options2.getClassLoader();
        if (cl == null && (cl = Thread.currentThread().getContextClassLoader()) == null) {
            cl = this.getClass().getClassLoader();
        }
        return this.doDeploy(options2, (Verticle v) -> "java:" + v.getClass().getName(), currentContext, currentContext, cl, verticleSupplier).map(Deployment::deploymentID);
    }

    public Future<Void> undeployVerticle(String deploymentID) {
        Deployment deployment = this.deployments.get(deploymentID);
        ContextInternal currentContext = this.vertx.getOrCreateContext();
        if (deployment == null) {
            return currentContext.failedFuture(new IllegalStateException("Unknown deployment"));
        }
        return deployment.doUndeploy(this.vertx.getOrCreateContext());
    }

    public Set<String> deployments() {
        return Collections.unmodifiableSet(this.deployments.keySet());
    }

    public Deployment getDeployment(String deploymentID) {
        return this.deployments.get(deploymentID);
    }

    public Future<Void> undeployAll() {
        HashSet deploymentIDs = new HashSet();
        for (Map.Entry<String, Deployment> entry : this.deployments.entrySet()) {
            if (entry.getValue().isChild()) continue;
            deploymentIDs.add(entry.getKey());
        }
        ArrayList<Future> completionList = new ArrayList<Future>();
        if (!deploymentIDs.isEmpty()) {
            for (String deploymentID : deploymentIDs) {
                Promise promise2 = Promise.promise();
                completionList.add(promise2.future());
                this.undeployVerticle(deploymentID).onComplete(ar -> {
                    if (ar.failed()) {
                        log.error("Undeploy failed", ar.cause());
                    }
                    promise2.handle(ar);
                });
            }
            PromiseInternal promise3 = this.vertx.getOrCreateContext().promise();
            CompositeFuture.join(completionList).mapEmpty().onComplete(promise3);
            return promise3.future();
        }
        return this.vertx.getOrCreateContext().succeededFuture();
    }

    private <T> void reportFailure(Throwable t3, Context context, Handler<AsyncResult<T>> completionHandler) {
        if (completionHandler != null) {
            this.reportResult(context, completionHandler, Future.failedFuture(t3));
        } else {
            log.error(t3.getMessage(), t3);
        }
    }

    private <T> void reportResult(Context context, Handler<AsyncResult<T>> completionHandler, AsyncResult<T> result2) {
        context.runOnContext(v -> {
            try {
                completionHandler.handle(result2);
            }
            catch (Throwable t3) {
                log.error("Failure in calling handler", t3);
                throw t3;
            }
        });
    }

    Future<Deployment> doDeploy(DeploymentOptions options2, Function<Verticle, String> identifierProvider, ContextInternal parentContext, ContextInternal callingContext, ClassLoader tccl, Callable<Verticle> verticleSupplier) {
        int nbInstances = options2.getInstances();
        Set verticles = Collections.newSetFromMap(new IdentityHashMap());
        for (int i = 0; i < nbInstances; ++i) {
            Verticle verticle;
            try {
                verticle = verticleSupplier.call();
            }
            catch (Exception e2) {
                return Future.failedFuture(e2);
            }
            if (verticle == null) {
                return Future.failedFuture("Supplied verticle is null");
            }
            verticles.add(verticle);
        }
        if (verticles.size() != nbInstances) {
            return Future.failedFuture("Same verticle supplied more than once");
        }
        Verticle[] verticlesArray = verticles.toArray(new Verticle[0]);
        return this.doDeploy(identifierProvider.apply(verticlesArray[0]), options2, parentContext, callingContext, tccl, verticlesArray);
    }

    private Future<Deployment> doDeploy(String identifier, DeploymentOptions options2, ContextInternal parentContext, ContextInternal callingContext, ClassLoader tccl, Verticle ... verticles) {
        PromiseInternal promise2 = callingContext.promise();
        String poolName = options2.getWorkerPoolName();
        Deployment parent = parentContext.getDeployment();
        String deploymentID = this.generateDeploymentID();
        DeploymentImpl deployment = new DeploymentImpl(parent, deploymentID, identifier, options2);
        AtomicInteger deployCount = new AtomicInteger();
        AtomicBoolean failureReported = new AtomicBoolean();
        for (Verticle verticle : verticles) {
            CloseFuture closeFuture = new CloseFuture(log);
            WorkerPool workerPool = poolName != null ? this.vertx.createSharedWorkerPool(poolName, options2.getWorkerPoolSize(), options2.getMaxWorkerExecuteTime(), options2.getMaxWorkerExecuteTimeUnit()) : null;
            ContextBase context = options2.isWorker() ? this.vertx.createWorkerContext(deployment, closeFuture, workerPool, tccl) : this.vertx.createEventLoopContext(deployment, closeFuture, workerPool, tccl);
            VerticleHolder holder = new VerticleHolder(verticle, context, workerPool, closeFuture);
            deployment.addVerticle(holder);
            context.runOnContext(v -> {
                block2: {
                    try {
                        verticle.init(this.vertx, context);
                        PromiseInternal<Void> startPromise = context.promise();
                        Future startFuture = startPromise.future();
                        verticle.start(startPromise);
                        startFuture.onComplete(ar -> {
                            if (ar.succeeded()) {
                                if (parent != null) {
                                    if (parent.addChild(deployment)) {
                                        deployment.child = true;
                                    } else {
                                        deployment.doUndeploy(this.vertx.getOrCreateContext()).onComplete(ar2 -> promise2.fail("Verticle deployment failed.Could not be added as child of parent verticle"));
                                        return;
                                    }
                                }
                                this.deployments.put(deploymentID, deployment);
                                if (deployCount.incrementAndGet() == verticles.length) {
                                    promise2.complete(deployment);
                                }
                            } else if (failureReported.compareAndSet(false, true)) {
                                deployment.rollback(callingContext, promise2, context, holder, ar.cause());
                            }
                        });
                    }
                    catch (Throwable t3) {
                        if (!failureReported.compareAndSet(false, true)) break block2;
                        deployment.rollback(callingContext, promise2, context, holder, t3);
                    }
                }
            });
        }
        return promise2.future();
    }

    private class DeploymentImpl
    implements Deployment {
        private static final int ST_DEPLOYED = 0;
        private static final int ST_UNDEPLOYING = 1;
        private static final int ST_UNDEPLOYED = 2;
        private final Deployment parent;
        private final String deploymentID;
        private final JsonObject conf;
        private final String verticleIdentifier;
        private final List<VerticleHolder> verticles = new CopyOnWriteArrayList<VerticleHolder>();
        private final Set<Deployment> children = new ConcurrentHashSet<Deployment>();
        private final DeploymentOptions options;
        private Handler<Void> undeployHandler;
        private int status = 0;
        private volatile boolean child;

        private DeploymentImpl(Deployment parent, String deploymentID, String verticleIdentifier, DeploymentOptions options2) {
            this.parent = parent;
            this.deploymentID = deploymentID;
            this.conf = options2.getConfig() != null ? options2.getConfig().copy() : new JsonObject();
            this.verticleIdentifier = verticleIdentifier;
            this.options = options2;
        }

        public void addVerticle(VerticleHolder holder) {
            this.verticles.add(holder);
        }

        private synchronized void rollback(ContextInternal callingContext, Handler<AsyncResult<Deployment>> completionHandler, ContextBase context, VerticleHolder closeFuture, Throwable cause) {
            if (this.status == 0) {
                this.status = 1;
                this.doUndeployChildren(callingContext).onComplete(childrenResult -> {
                    Handler<Void> handler;
                    DeploymentImpl deploymentImpl = this;
                    synchronized (deploymentImpl) {
                        this.status = 2;
                        handler = this.undeployHandler;
                        this.undeployHandler = null;
                    }
                    if (handler != null) {
                        try {
                            handler.handle(null);
                        }
                        catch (Exception e2) {
                            context.reportException(e2);
                        }
                    }
                    if (childrenResult.failed()) {
                        DeploymentManager.this.reportFailure(cause, callingContext, completionHandler);
                    } else {
                        closeFuture.close(closeHookAsyncResult -> DeploymentManager.this.reportFailure(cause, callingContext, completionHandler));
                    }
                });
            }
        }

        private synchronized Future<Void> doUndeployChildren(ContextInternal undeployingContext) {
            if (!this.children.isEmpty()) {
                ArrayList<Future> childFuts = new ArrayList<Future>();
                for (Deployment childDeployment : new HashSet<Deployment>(this.children)) {
                    Promise p = Promise.promise();
                    childFuts.add(p.future());
                    childDeployment.doUndeploy(undeployingContext).onComplete(ar -> {
                        this.children.remove(childDeployment);
                        p.handle(ar);
                    });
                }
                return CompositeFuture.all(childFuts).mapEmpty();
            }
            return Future.succeededFuture();
        }

        @Override
        public synchronized Future<Void> doUndeploy(ContextInternal undeployingContext) {
            if (this.status == 2) {
                return Future.failedFuture(new IllegalStateException("Already undeployed"));
            }
            if (!this.children.isEmpty()) {
                this.status = 1;
                return this.doUndeployChildren(undeployingContext).compose(v -> this.doUndeploy(undeployingContext));
            }
            this.status = 2;
            ArrayList<Future> undeployFutures = new ArrayList<Future>();
            if (this.parent != null) {
                this.parent.removeChild(this);
            }
            for (VerticleHolder verticleHolder : this.verticles) {
                ContextBase context = verticleHolder.context;
                Promise p = Promise.promise();
                undeployFutures.add(p.future());
                context.runOnContext(v -> {
                    block2: {
                        PromiseInternal<Void> stopPromise = undeployingContext.promise();
                        Future stopFuture = stopPromise.future();
                        stopFuture.onComplete(ar -> {
                            DeploymentManager.this.deployments.remove(this.deploymentID);
                            verticleHolder.close(ar2 -> {
                                if (ar2.failed()) {
                                    log.error("Failed to run close hook", ar2.cause());
                                }
                                if (ar.succeeded()) {
                                    p.complete();
                                } else if (ar.failed()) {
                                    p.fail(ar.cause());
                                }
                            });
                        });
                        try {
                            verticleHolder.verticle.stop(stopPromise);
                        }
                        catch (Throwable t3) {
                            if (stopPromise.tryFail(t3)) break block2;
                            undeployingContext.reportException(t3);
                        }
                    }
                });
            }
            PromiseInternal resolvingPromise = undeployingContext.promise();
            CompositeFuture.all(undeployFutures).mapEmpty().onComplete(resolvingPromise);
            Future<Void> fut = resolvingPromise.future();
            Handler<Void> handler = this.undeployHandler;
            if (handler != null) {
                this.undeployHandler = null;
                return fut.compose(v -> {
                    handler.handle(null);
                    return Future.succeededFuture();
                }, v -> {
                    handler.handle(null);
                    return Future.succeededFuture();
                });
            }
            return fut;
        }

        @Override
        public String verticleIdentifier() {
            return this.verticleIdentifier;
        }

        @Override
        public DeploymentOptions deploymentOptions() {
            return this.options;
        }

        @Override
        public JsonObject config() {
            return this.conf;
        }

        @Override
        public synchronized boolean addChild(Deployment deployment) {
            if (this.status == 0) {
                this.children.add(deployment);
                return true;
            }
            return false;
        }

        @Override
        public void removeChild(Deployment deployment) {
            this.children.remove(deployment);
        }

        @Override
        public Set<Context> getContexts() {
            HashSet<Context> contexts = new HashSet<Context>();
            for (VerticleHolder holder : this.verticles) {
                contexts.add(holder.context);
            }
            return contexts;
        }

        @Override
        public Set<Verticle> getVerticles() {
            HashSet<Verticle> verts = new HashSet<Verticle>();
            for (VerticleHolder holder : this.verticles) {
                verts.add(holder.verticle);
            }
            return verts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void undeployHandler(Handler<Void> handler) {
            DeploymentImpl deploymentImpl = this;
            synchronized (deploymentImpl) {
                if (this.status != 2) {
                    this.undeployHandler = handler;
                    return;
                }
            }
            handler.handle(null);
        }

        @Override
        public boolean isChild() {
            return this.child;
        }

        @Override
        public String deploymentID() {
            return this.deploymentID;
        }
    }

    static class VerticleHolder {
        final Verticle verticle;
        final ContextBase context;
        final WorkerPool workerPool;
        final CloseFuture closeFuture;

        VerticleHolder(Verticle verticle, ContextBase context, WorkerPool workerPool, CloseFuture closeFuture) {
            this.verticle = verticle;
            this.context = context;
            this.workerPool = workerPool;
            this.closeFuture = closeFuture;
        }

        void close(Handler<AsyncResult<Void>> completionHandler) {
            this.closeFuture.close().onComplete(ar -> {
                if (this.workerPool != null) {
                    this.workerPool.close();
                }
                completionHandler.handle((AsyncResult<Void>)ar);
            });
        }
    }
}

