/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.EventLoop;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextBase;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.impl.future.FailedFuture;
import io.vertx.core.impl.future.PromiseImpl;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.future.SucceededFuture;
import io.vertx.core.spi.tracing.VertxTracer;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public interface ContextInternal
extends Context {
    public static ContextInternal current() {
        Thread thread2 = Thread.currentThread();
        if (thread2 instanceof VertxThread) {
            return ((VertxThread)thread2).context();
        }
        VertxImpl.ContextDispatch current = VertxImpl.nonVertxContextDispatch.get();
        if (current != null) {
            return current.context;
        }
        return null;
    }

    @Override
    default public void runOnContext(Handler<Void> action) {
        this.executor().execute(() -> this.dispatch(action));
    }

    public Executor executor();

    public EventLoop nettyEventLoop();

    default public <T> PromiseInternal<T> promise() {
        return new PromiseImpl(this);
    }

    default public <T> PromiseInternal<T> promise(Handler<AsyncResult<T>> handler) {
        PromiseInternal<T> promise2;
        if (handler instanceof PromiseInternal && (promise2 = (PromiseInternal<T>)handler).context() != null) {
            return promise2;
        }
        promise2 = this.promise();
        promise2.future().onComplete(handler);
        return promise2;
    }

    default public <T> Future<T> succeededFuture() {
        return new SucceededFuture<Object>(this, null);
    }

    default public <T> Future<T> succeededFuture(T result2) {
        return new SucceededFuture<T>(this, result2);
    }

    default public <T> Future<T> failedFuture(Throwable failure) {
        return new FailedFuture(this, failure);
    }

    default public <T> Future<T> failedFuture(String message) {
        return new FailedFuture(this, message);
    }

    default public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, TaskQueue queue2, Handler<AsyncResult<T>> resultHandler) {
        Future<T> fut = this.executeBlocking(blockingCodeHandler, queue2);
        ContextBase.setResultHandler(this, fut, resultHandler);
    }

    public <T> Future<T> executeBlocking(Handler<Promise<T>> var1, TaskQueue var2);

    default public <T> void executeBlockingInternal(Handler<Promise<T>> action, Handler<AsyncResult<T>> resultHandler) {
        Future<T> fut = this.executeBlockingInternal(action);
        ContextBase.setResultHandler(this, fut, resultHandler);
    }

    default public <T> void executeBlockingInternal(Handler<Promise<T>> action, boolean ordered, Handler<AsyncResult<T>> resultHandler) {
        Future<T> fut = this.executeBlockingInternal(action, ordered);
        ContextBase.setResultHandler(this, fut, resultHandler);
    }

    @Override
    default public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> resultHandler) {
        Future<T> fut = this.executeBlocking(blockingCodeHandler, ordered);
        ContextBase.setResultHandler(this, fut, resultHandler);
    }

    public <T> Future<T> executeBlockingInternal(Handler<Promise<T>> var1);

    public <T> Future<T> executeBlockingInternal(Handler<Promise<T>> var1, boolean var2);

    public Deployment getDeployment();

    @Override
    public VertxInternal owner();

    public boolean inThread();

    public <T> void emit(T var1, Handler<T> var2);

    default public void emit(Handler<Void> task) {
        this.emit(null, task);
    }

    default public void execute(Handler<Void> task) {
        this.execute(null, task);
    }

    public void execute(Runnable var1);

    public <T> void execute(T var1, Handler<T> var2);

    default public boolean isRunningOnContext() {
        return ContextInternal.current() == this && this.inThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void dispatch(Runnable handler) {
        ContextInternal prev2 = this.beginDispatch();
        try {
            handler.run();
        }
        catch (Throwable t3) {
            this.reportException(t3);
        }
        finally {
            this.endDispatch(prev2);
        }
    }

    default public void dispatch(Handler<Void> handler) {
        this.dispatch(null, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <E> void dispatch(E event, Handler<E> handler) {
        ContextInternal prev2 = this.beginDispatch();
        try {
            handler.handle(event);
        }
        catch (Throwable t3) {
            this.reportException(t3);
        }
        finally {
            this.endDispatch(prev2);
        }
    }

    default public ContextInternal beginDispatch() {
        VertxImpl vertx = (VertxImpl)this.owner();
        return vertx.beginDispatch(this);
    }

    default public void endDispatch(ContextInternal previous) {
        VertxImpl vertx = (VertxImpl)this.owner();
        vertx.endDispatch(previous);
    }

    public void reportException(Throwable var1);

    public ConcurrentMap<Object, Object> contextData();

    @Override
    default public <T> T get(Object key2) {
        return (T)this.contextData().get(key2);
    }

    @Override
    default public void put(Object key2, Object value) {
        this.contextData().put(key2, value);
    }

    @Override
    default public boolean remove(Object key2) {
        return this.contextData().remove(key2) != null;
    }

    public ConcurrentMap<Object, Object> localContextData();

    @Override
    default public <T> T getLocal(Object key2) {
        return (T)this.localContextData().get(key2);
    }

    @Override
    default public void putLocal(Object key2, Object value) {
        this.localContextData().put(key2, value);
    }

    @Override
    default public boolean removeLocal(Object key2) {
        return this.localContextData().remove(key2) != null;
    }

    public ClassLoader classLoader();

    public WorkerPool workerPool();

    public VertxTracer tracer();

    public ContextInternal duplicate();

    default public long setPeriodic(long delay2, Handler<Long> handler) {
        VertxImpl owner = (VertxImpl)this.owner();
        return owner.scheduleTimeout(this, true, delay2, TimeUnit.MILLISECONDS, false, handler);
    }

    default public long setTimer(long delay2, Handler<Long> handler) {
        VertxImpl owner = (VertxImpl)this.owner();
        return owner.scheduleTimeout(this, false, delay2, TimeUnit.MILLISECONDS, false, handler);
    }

    default public boolean isDeployment() {
        return this.getDeployment() != null;
    }

    @Override
    default public String deploymentID() {
        Deployment deployment = this.getDeployment();
        return deployment != null ? deployment.deploymentID() : null;
    }

    @Override
    default public int getInstanceCount() {
        Deployment deployment = this.getDeployment();
        if (deployment == null) {
            return 0;
        }
        if (deployment.deploymentOptions() == null) {
            return 1;
        }
        return deployment.deploymentOptions().getInstances();
    }

    public CloseFuture closeFuture();

    default public void addCloseHook(Closeable hook) {
        this.closeFuture().add(hook);
    }

    default public void removeCloseHook(Closeable hook) {
        this.closeFuture().remove(hook);
    }

    default public ContextInternal unwrap() {
        return this;
    }

    default public boolean isDuplicate() {
        return false;
    }
}

