/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl.headers;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http2.Http2Headers;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.impl.HttpUtils;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class Http2HeadersAdaptor
implements MultiMap {
    private final Http2Headers headers;

    public Http2HeadersAdaptor(Http2Headers headers) {
        List cookies = headers.getAll(HttpHeaderNames.COOKIE);
        if (cookies != null && cookies.size() > 1) {
            String value = cookies.stream().collect(Collectors.joining("; "));
            headers.set(HttpHeaderNames.COOKIE, value);
        }
        this.headers = headers;
    }

    @Override
    public String get(String name2) {
        CharSequence val2 = (CharSequence)this.headers.get(HttpUtils.toLowerCase(name2));
        return val2 != null ? val2.toString() : null;
    }

    @Override
    public List<String> getAll(String name2) {
        final List all = this.headers.getAll(HttpUtils.toLowerCase(name2));
        if (all != null) {
            return new AbstractList<String>(){

                @Override
                public String get(int index2) {
                    return ((CharSequence)all.get(index2)).toString();
                }

                @Override
                public int size() {
                    return all.size();
                }
            };
        }
        return null;
    }

    @Override
    public boolean contains(String name2) {
        return this.headers.contains(HttpUtils.toLowerCase(name2));
    }

    @Override
    public boolean contains(String name2, String value, boolean caseInsensitive) {
        return this.headers.contains(HttpUtils.toLowerCase(name2), value, caseInsensitive);
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public Set<String> names() {
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<CharSequence, CharSequence> header : this.headers) {
            names.add(header.getKey().toString());
        }
        return names;
    }

    @Override
    public MultiMap add(String name2, String value) {
        if (!HttpHeaders.DISABLE_HTTP_HEADERS_VALIDATION) {
            HttpUtils.validateHeader((CharSequence)name2, value);
        }
        this.headers.add(HttpUtils.toLowerCase(name2), value);
        return this;
    }

    @Override
    public MultiMap add(String name2, Iterable<String> values2) {
        if (!HttpHeaders.DISABLE_HTTP_HEADERS_VALIDATION) {
            HttpUtils.validateHeader((CharSequence)name2, values2);
        }
        this.headers.add(HttpUtils.toLowerCase(name2), values2);
        return this;
    }

    @Override
    public MultiMap addAll(MultiMap headers) {
        for (Map.Entry<String, String> entry : headers.entries()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public MultiMap addAll(Map<String, String> map2) {
        for (Map.Entry<String, String> entry : map2.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public MultiMap set(String name2, String value) {
        if (!HttpHeaders.DISABLE_HTTP_HEADERS_VALIDATION) {
            HttpUtils.validateHeader((CharSequence)name2, value);
        }
        name2 = (String)HttpUtils.toLowerCase(name2);
        if (value != null) {
            this.headers.set(name2, value);
        } else {
            this.headers.remove(name2);
        }
        return this;
    }

    @Override
    public MultiMap set(String name2, Iterable<String> values2) {
        if (!HttpHeaders.DISABLE_HTTP_HEADERS_VALIDATION) {
            HttpUtils.validateHeader((CharSequence)name2, values2);
        }
        this.headers.set(HttpUtils.toLowerCase(name2), values2);
        return this;
    }

    @Override
    public MultiMap setAll(MultiMap httpHeaders) {
        this.clear();
        for (Map.Entry entry : httpHeaders) {
            this.add((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    @Override
    public MultiMap remove(String name2) {
        this.headers.remove(HttpUtils.toLowerCase(name2));
        return this;
    }

    @Override
    public MultiMap clear() {
        this.headers.clear();
        return this;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        final Iterator<Map.Entry<CharSequence, CharSequence>> i = this.headers.iterator();
        return new Iterator<Map.Entry<String, String>>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public Map.Entry<String, String> next() {
                final Map.Entry next2 = (Map.Entry)i.next();
                return new Map.Entry<String, String>(){

                    @Override
                    public String getKey() {
                        return ((CharSequence)next2.getKey()).toString();
                    }

                    @Override
                    public String getValue() {
                        return ((CharSequence)next2.getValue()).toString();
                    }

                    @Override
                    public String setValue(String value) {
                        String old = ((CharSequence)next2.getValue()).toString();
                        next2.setValue(value);
                        return old;
                    }

                    public String toString() {
                        return next2.toString();
                    }
                };
            }
        };
    }

    @Override
    public int size() {
        return this.names().size();
    }

    @Override
    public MultiMap setAll(Map<String, String> headers) {
        this.clear();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public String get(CharSequence name2) {
        CharSequence val2 = (CharSequence)this.headers.get(HttpUtils.toLowerCase(name2));
        return val2 != null ? val2.toString() : null;
    }

    @Override
    public List<String> getAll(CharSequence name2) {
        List all = this.headers.getAll(HttpUtils.toLowerCase(name2));
        return all != null ? all.stream().map(CharSequence::toString).collect(Collectors.toList()) : null;
    }

    @Override
    public boolean contains(CharSequence name2) {
        return this.headers.contains(HttpUtils.toLowerCase(name2));
    }

    @Override
    public boolean contains(CharSequence name2, CharSequence value, boolean caseInsensitive) {
        return this.headers.contains(HttpUtils.toLowerCase(name2), value, caseInsensitive);
    }

    @Override
    public MultiMap add(CharSequence name2, CharSequence value) {
        if (!HttpHeaders.DISABLE_HTTP_HEADERS_VALIDATION) {
            HttpUtils.validateHeader(name2, value);
        }
        this.headers.add(HttpUtils.toLowerCase(name2), value);
        return this;
    }

    @Override
    public MultiMap add(CharSequence name2, Iterable<CharSequence> values2) {
        if (!HttpHeaders.DISABLE_HTTP_HEADERS_VALIDATION) {
            HttpUtils.validateHeader(name2, values2);
        }
        this.headers.add(HttpUtils.toLowerCase(name2), values2);
        return this;
    }

    @Override
    public MultiMap set(CharSequence name2, CharSequence value) {
        if (!HttpHeaders.DISABLE_HTTP_HEADERS_VALIDATION) {
            HttpUtils.validateHeader(name2, value);
        }
        name2 = HttpUtils.toLowerCase(name2);
        if (value != null) {
            this.headers.set(name2, value);
        } else {
            this.headers.remove(name2);
        }
        return this;
    }

    @Override
    public MultiMap set(CharSequence name2, Iterable<CharSequence> values2) {
        if (!HttpHeaders.DISABLE_HTTP_HEADERS_VALIDATION) {
            HttpUtils.validateHeader(name2, values2);
        }
        this.headers.set(HttpUtils.toLowerCase(name2), values2);
        return this;
    }

    @Override
    public MultiMap remove(CharSequence name2) {
        this.headers.remove(HttpUtils.toLowerCase(name2));
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<CharSequence, CharSequence> header : this.headers) {
            sb.append(header).append('\n');
        }
        return sb.toString();
    }
}

