/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl.headers;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.impl.HttpUtils;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class HeadersMultiMap
extends io.netty.handler.codec.http.HttpHeaders
implements MultiMap {
    static final BiConsumer<CharSequence, CharSequence> HTTP_VALIDATOR = !HttpHeaders.DISABLE_HTTP_HEADERS_VALIDATION ? HttpUtils::validateHeader : null;
    private final BiConsumer<CharSequence, CharSequence> validator;
    private final MapEntry[] entries = new MapEntry[16];
    private final MapEntry head = new MapEntry();
    private static final int COLON_AND_SPACE_SHORT = 14880;
    static final int CRLF_SHORT = 3338;

    private static CharSequence toValidCharSequence(Object value) {
        if (value instanceof CharSequence) {
            return (CharSequence)value;
        }
        return value.toString();
    }

    public static HeadersMultiMap httpHeaders() {
        return new HeadersMultiMap(HTTP_VALIDATOR);
    }

    public static HeadersMultiMap headers() {
        return new HeadersMultiMap();
    }

    @Override
    public MultiMap setAll(MultiMap headers) {
        return this.set0(headers);
    }

    @Override
    public MultiMap setAll(Map<String, String> headers) {
        return this.set0(headers.entrySet());
    }

    @Override
    public int size() {
        return this.names().size();
    }

    public HeadersMultiMap() {
        this(null);
    }

    public HeadersMultiMap(BiConsumer<CharSequence, CharSequence> validator2) {
        this.validator = validator2;
        this.head.before = this.head.after = this.head;
    }

    @Override
    public HeadersMultiMap add(CharSequence name2, CharSequence value) {
        Objects.requireNonNull(value);
        int h2 = AsciiString.hashCode(name2);
        int i = h2 & 0xF;
        this.add0(h2, i, name2, value);
        return this;
    }

    @Override
    public HeadersMultiMap add(CharSequence name2, Object value) {
        return this.add(name2, HeadersMultiMap.toValidCharSequence(value));
    }

    @Override
    public io.netty.handler.codec.http.HttpHeaders add(String name2, Object value) {
        return this.add((CharSequence)name2, HeadersMultiMap.toValidCharSequence(value));
    }

    @Override
    public HeadersMultiMap add(String name2, String strVal) {
        return this.add((CharSequence)name2, (CharSequence)strVal);
    }

    public HeadersMultiMap add(CharSequence name2, Iterable values2) {
        int h2 = AsciiString.hashCode(name2);
        int i = h2 & 0xF;
        for (Object vstr : values2) {
            this.add0(h2, i, name2, HeadersMultiMap.toValidCharSequence(vstr));
        }
        return this;
    }

    public HeadersMultiMap add(String name2, Iterable values2) {
        return this.add((CharSequence)name2, values2);
    }

    @Override
    public MultiMap addAll(MultiMap headers) {
        return this.addAll(headers.entries());
    }

    @Override
    public MultiMap addAll(Map<String, String> map2) {
        return this.addAll(map2.entrySet());
    }

    private MultiMap addAll(Iterable<Map.Entry<String, String>> headers) {
        for (Map.Entry<String, String> entry : headers) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public HeadersMultiMap remove(CharSequence name2) {
        Objects.requireNonNull(name2, "name");
        int h2 = AsciiString.hashCode(name2);
        int i = h2 & 0xF;
        this.remove0(h2, i, name2);
        return this;
    }

    @Override
    public HeadersMultiMap remove(String name2) {
        return this.remove((CharSequence)name2);
    }

    @Override
    public HeadersMultiMap set(CharSequence name2, CharSequence value) {
        return this.set0(name2, value);
    }

    @Override
    public HeadersMultiMap set(String name2, String value) {
        return this.set((CharSequence)name2, (CharSequence)value);
    }

    @Override
    public HeadersMultiMap set(String name2, Object value) {
        return this.set((CharSequence)name2, HeadersMultiMap.toValidCharSequence(value));
    }

    @Override
    public HeadersMultiMap set(CharSequence name2, Object value) {
        return this.set(name2, HeadersMultiMap.toValidCharSequence(value));
    }

    public HeadersMultiMap set(CharSequence name2, Iterable values2) {
        Objects.requireNonNull(values2, "values");
        int h2 = AsciiString.hashCode(name2);
        int i = h2 & 0xF;
        this.remove0(h2, i, name2);
        for (Object v : values2) {
            if (v == null) break;
            this.add0(h2, i, name2, HeadersMultiMap.toValidCharSequence(v));
        }
        return this;
    }

    public HeadersMultiMap set(String name2, Iterable values2) {
        return this.set((CharSequence)name2, values2);
    }

    @Override
    public boolean containsValue(CharSequence name2, CharSequence value, boolean ignoreCase) {
        return this.containsInternal(name2, value, false, ignoreCase);
    }

    @Override
    public boolean contains(CharSequence name2, CharSequence value, boolean ignoreCase) {
        return this.containsInternal(name2, value, true, ignoreCase);
    }

    private boolean containsInternal(CharSequence name2, CharSequence value, boolean equals, boolean ignoreCase) {
        int h2 = AsciiString.hashCode(name2);
        int i = h2 & 0xF;
        MapEntry e2 = this.entries[i];
        while (e2 != null) {
            CharSequence key2 = e2.key;
            if (e2.hash == h2 && (name2 == key2 || AsciiString.contentEqualsIgnoreCase(name2, key2))) {
                CharSequence other = e2.getValue();
                if (equals) {
                    if (ignoreCase && AsciiString.contentEqualsIgnoreCase(value, other) || !ignoreCase && AsciiString.contentEquals(value, other)) {
                        return true;
                    }
                } else {
                    int prev2 = 0;
                    while (true) {
                        int idx;
                        int from;
                        int to;
                        for (to = (idx = AsciiString.indexOf(other, ',', prev2)) == -1 ? other.length() : idx; to > prev2 && other.charAt(to - 1) == ' '; --to) {
                        }
                        for (from = prev2; from < to && other.charAt(from) == ' '; ++from) {
                        }
                        int len = to - from;
                        if (len > 0 && AsciiString.regionMatches(other, ignoreCase, from, value, 0, len)) {
                            return true;
                        }
                        if (idx == -1) break;
                        prev2 = idx + 1;
                    }
                }
            }
            e2 = e2.next;
        }
        return false;
    }

    @Override
    public boolean contains(String name2, String value, boolean ignoreCase) {
        return this.contains((CharSequence)name2, (CharSequence)value, ignoreCase);
    }

    @Override
    public boolean contains(CharSequence name2) {
        return this.get0(name2) != null;
    }

    @Override
    public boolean contains(String name2) {
        return this.contains((CharSequence)name2);
    }

    @Override
    public String get(CharSequence name2) {
        Objects.requireNonNull(name2, "name");
        CharSequence ret = this.get0(name2);
        return ret != null ? ret.toString() : null;
    }

    @Override
    public String get(String name2) {
        return this.get((CharSequence)name2);
    }

    @Override
    public List<String> getAll(CharSequence name2) {
        Objects.requireNonNull(name2, "name");
        LinkedList<String> values2 = null;
        int h2 = AsciiString.hashCode(name2);
        int i = h2 & 0xF;
        MapEntry e2 = this.entries[i];
        while (e2 != null) {
            CharSequence key2 = e2.key;
            if (e2.hash == h2 && (name2 == key2 || AsciiString.contentEqualsIgnoreCase(name2, key2))) {
                if (values2 == null) {
                    values2 = new LinkedList<String>();
                }
                values2.addFirst(e2.getValue().toString());
            }
            e2 = e2.next;
        }
        return values2 == null ? Collections.emptyList() : Collections.unmodifiableList(values2);
    }

    @Override
    public List<String> getAll(String name2) {
        return this.getAll((CharSequence)name2);
    }

    @Override
    public void forEach(Consumer<? super Map.Entry<String, String>> action) {
        MapEntry e2 = this.head.after;
        while (e2 != this.head) {
            action.accept(e2.stringEntry());
            e2 = e2.after;
        }
    }

    @Override
    public void forEach(BiConsumer<String, String> action) {
        MapEntry e2 = this.head.after;
        while (e2 != this.head) {
            action.accept(e2.getKey().toString(), e2.getValue().toString());
            e2 = e2.after;
        }
    }

    @Override
    public List<Map.Entry<String, String>> entries() {
        return MultiMap.super.entries();
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return new Iterator<Map.Entry<String, String>>(){
            MapEntry curr;
            {
                this.curr = HeadersMultiMap.this.head;
            }

            @Override
            public boolean hasNext() {
                return this.curr.after != HeadersMultiMap.this.head;
            }

            @Override
            public Map.Entry<String, String> next() {
                final MapEntry next2 = this.curr.after;
                if (next2 == HeadersMultiMap.this.head) {
                    throw new NoSuchElementException();
                }
                this.curr = next2;
                return new Map.Entry<String, String>(){

                    @Override
                    public String getKey() {
                        return next2.key.toString();
                    }

                    @Override
                    public String getValue() {
                        return next2.value.toString();
                    }

                    @Override
                    public String setValue(String value) {
                        return next2.setValue(value).toString();
                    }

                    public String toString() {
                        return this.getKey() + "=" + this.getValue();
                    }
                };
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.head.after;
    }

    @Override
    public Set<String> names() {
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        MapEntry e2 = this.head.after;
        while (e2 != this.head) {
            names.add(e2.getKey().toString());
            e2 = e2.after;
        }
        return names;
    }

    @Override
    public HeadersMultiMap clear() {
        Arrays.fill(this.entries, null);
        this.head.before = this.head.after = this.head;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this) {
            sb.append(entry).append('\n');
        }
        return sb.toString();
    }

    @Override
    public Integer getInt(CharSequence name2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(CharSequence name2, int defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short getShort(CharSequence name2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShort(CharSequence name2, short defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long getTimeMillis(CharSequence name2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getTimeMillis(CharSequence name2, long defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iteratorCharSequence() {
        return new Iterator<Map.Entry<CharSequence, CharSequence>>(){
            MapEntry current;
            {
                this.current = ((HeadersMultiMap)HeadersMultiMap.this).head.after;
            }

            @Override
            public boolean hasNext() {
                return this.current != HeadersMultiMap.this.head;
            }

            @Override
            public Map.Entry<CharSequence, CharSequence> next() {
                MapEntry next2 = this.current;
                this.current = this.current.after;
                return next2;
            }
        };
    }

    @Override
    public io.netty.handler.codec.http.HttpHeaders addInt(CharSequence name2, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public io.netty.handler.codec.http.HttpHeaders addShort(CharSequence name2, short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public io.netty.handler.codec.http.HttpHeaders setInt(CharSequence name2, int value) {
        return this.set(name2, (CharSequence)Integer.toString(value));
    }

    @Override
    public io.netty.handler.codec.http.HttpHeaders setShort(CharSequence name2, short value) {
        throw new UnsupportedOperationException();
    }

    public void encode(ByteBuf buf) {
        MapEntry current = this.head.after;
        while (current != this.head) {
            HeadersMultiMap.encoderHeader(current.key, current.value, buf);
            current = current.after;
        }
    }

    static void encoderHeader(CharSequence name2, CharSequence value, ByteBuf buf) {
        int nameLen = name2.length();
        int valueLen = value.length();
        int entryLen = nameLen + valueLen + 4;
        buf.ensureWritable(entryLen);
        int offset = buf.writerIndex();
        HeadersMultiMap.writeAscii(buf, offset, name2);
        ByteBufUtil.setShortBE(buf, offset += nameLen, 14880);
        HeadersMultiMap.writeAscii(buf, offset += 2, value);
        ByteBufUtil.setShortBE(buf, offset += valueLen, 3338);
        buf.writerIndex(offset += 2);
    }

    private static void writeAscii(ByteBuf buf, int offset, CharSequence value) {
        if (value instanceof AsciiString) {
            ByteBufUtil.copy((AsciiString)value, 0, buf, offset, value.length());
        } else {
            buf.setCharSequence(offset, value, CharsetUtil.US_ASCII);
        }
    }

    private void remove0(int h2, int i, CharSequence name2) {
        MapEntry e2 = this.entries[i];
        MapEntry prev2 = null;
        while (e2 != null) {
            MapEntry next2 = e2.next;
            CharSequence key2 = e2.key;
            if (e2.hash == h2 && (name2 == key2 || AsciiString.contentEqualsIgnoreCase(name2, key2))) {
                if (prev2 == null) {
                    this.entries[i] = next2;
                } else {
                    prev2.next = next2;
                }
                e2.remove();
            } else {
                prev2 = e2;
            }
            e2 = next2;
        }
    }

    private void add0(int h2, int i, CharSequence name2, CharSequence value) {
        MapEntry newEntry;
        if (this.validator != null) {
            this.validator.accept(name2, value);
        }
        MapEntry e2 = this.entries[i];
        this.entries[i] = newEntry = new MapEntry(h2, name2, value);
        newEntry.next = e2;
        newEntry.addBefore(this.head);
    }

    private HeadersMultiMap set0(CharSequence name2, CharSequence strVal) {
        int h2 = AsciiString.hashCode(name2);
        int i = h2 & 0xF;
        this.remove0(h2, i, name2);
        if (strVal != null) {
            this.add0(h2, i, name2, strVal);
        }
        return this;
    }

    private CharSequence get0(CharSequence name2) {
        int h2 = AsciiString.hashCode(name2);
        int i = h2 & 0xF;
        MapEntry e2 = this.entries[i];
        CharSequence value = null;
        while (e2 != null) {
            CharSequence key2 = e2.key;
            if (e2.hash == h2 && (name2 == key2 || AsciiString.contentEqualsIgnoreCase(name2, key2))) {
                value = e2.getValue();
            }
            e2 = e2.next;
        }
        return value;
    }

    private MultiMap set0(Iterable<Map.Entry<String, String>> map2) {
        this.clear();
        for (Map.Entry<String, String> entry : map2) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    private final class MapEntry
    implements Map.Entry<CharSequence, CharSequence> {
        final int hash;
        final CharSequence key;
        CharSequence value;
        MapEntry next;
        MapEntry before;
        MapEntry after;

        MapEntry() {
            this.hash = -1;
            this.key = null;
            this.value = null;
        }

        MapEntry(int hash2, CharSequence key2, CharSequence value) {
            this.hash = hash2;
            this.key = key2;
            this.value = value;
        }

        void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
            this.after = null;
            this.before = null;
        }

        void addBefore(MapEntry e2) {
            this.after = e2;
            this.before = e2.before;
            this.before.after = this;
            this.after.before = this;
        }

        @Override
        public CharSequence getKey() {
            return this.key;
        }

        @Override
        public CharSequence getValue() {
            return this.value;
        }

        @Override
        public CharSequence setValue(CharSequence value) {
            Objects.requireNonNull(value, "value");
            if (HeadersMultiMap.this.validator != null) {
                HeadersMultiMap.this.validator.accept("", value);
            }
            CharSequence oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        private Map.Entry<String, String> stringEntry() {
            if (this.key instanceof String && this.value instanceof String) {
                return this;
            }
            return new AbstractMap.SimpleEntry<String, String>(this.key.toString(), this.value.toString());
        }
    }
}

