/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpClosedException;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.AssembledFullHttpResponse;
import io.vertx.core.http.impl.AssembledHttpResponse;
import io.vertx.core.http.impl.AssembledLastHttpContent;
import io.vertx.core.http.impl.CookieJar;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.MimeMapping;
import io.vertx.core.http.impl.ServerCookie;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.observability.HttpResponse;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Set;

public class Http1xServerResponse
implements HttpServerResponse,
HttpResponse {
    private static final Buffer EMPTY_BUFFER = Buffer.buffer(Unpooled.EMPTY_BUFFER);
    private static final Logger log = LoggerFactory.getLogger(Http1xServerResponse.class);
    private static final String RESPONSE_WRITTEN = "Response has already been written";
    private final VertxInternal vertx;
    private final HttpRequest request;
    private final Http1xServerConnection conn;
    private final ContextInternal context;
    private HttpResponseStatus status;
    private final HttpVersion version;
    private final boolean keepAlive;
    private final boolean head;
    private final Object requestMetric;
    private boolean headWritten;
    private boolean written;
    private Handler<Void> drainHandler;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> closeHandler;
    private Handler<Void> endHandler;
    private Handler<Void> headersEndHandler;
    private Handler<Void> bodyEndHandler;
    private boolean writable;
    private boolean closed;
    private final HeadersMultiMap headers;
    private CookieJar cookies;
    private MultiMap trailers;
    private io.netty.handler.codec.http.HttpHeaders trailingHeaders = EmptyHttpHeaders.INSTANCE;
    private String statusMessage;
    private long bytesWritten;
    private Future<NetSocket> netSocket;

    Http1xServerResponse(VertxInternal vertx, ContextInternal context, Http1xServerConnection conn, HttpRequest request, Object requestMetric, boolean writable) {
        this.vertx = vertx;
        this.conn = conn;
        this.context = context;
        this.version = request.protocolVersion();
        this.headers = HeadersMultiMap.httpHeaders();
        this.request = request;
        this.status = HttpResponseStatus.OK;
        this.requestMetric = requestMetric;
        this.writable = writable;
        this.keepAlive = this.version == HttpVersion.HTTP_1_1 && !request.headers().contains(HttpHeaders.CONNECTION, HttpHeaders.CLOSE, true) || this.version == HttpVersion.HTTP_1_0 && request.headers().contains(HttpHeaders.CONNECTION, HttpHeaders.KEEP_ALIVE, true);
        this.head = request.method() == io.netty.handler.codec.http.HttpMethod.HEAD;
    }

    @Override
    public MultiMap headers() {
        return this.headers;
    }

    @Override
    public MultiMap trailers() {
        if (this.trailers == null) {
            HeadersMultiMap v = HeadersMultiMap.httpHeaders();
            this.trailers = v;
            this.trailingHeaders = v;
        }
        return this.trailers;
    }

    @Override
    public int statusCode() {
        return this.status.code();
    }

    @Override
    public int getStatusCode() {
        return this.status.code();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse setStatusCode(int statusCode) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkHeadWritten();
            this.status = this.statusMessage != null ? new HttpResponseStatus(statusCode, this.statusMessage) : HttpResponseStatus.valueOf(statusCode);
        }
        return this;
    }

    @Override
    public String getStatusMessage() {
        return this.status.reasonPhrase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse setStatusMessage(String statusMessage) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkHeadWritten();
            this.statusMessage = statusMessage;
            this.status = new HttpResponseStatus(this.status.code(), statusMessage);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Http1xServerResponse setChunked(boolean chunked) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkHeadWritten();
            if (this.version != HttpVersion.HTTP_1_0) {
                this.headers.set(HttpHeaders.TRANSFER_ENCODING, (CharSequence)(chunked ? "chunked" : null));
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isChunked() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.headers.contains(HttpHeaders.TRANSFER_ENCODING, HttpHeaders.CHUNKED, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Http1xServerResponse putHeader(String key2, String value) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkHeadWritten();
            this.headers.set(key2, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Http1xServerResponse putHeader(String key2, Iterable<String> values2) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkHeadWritten();
            this.headers.set(key2, (Iterable)values2);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Http1xServerResponse putTrailer(String key2, String value) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkValid();
            this.trailers().set(key2, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Http1xServerResponse putTrailer(String key2, Iterable<String> values2) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkValid();
            this.trailers().set(key2, values2);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putHeader(CharSequence name2, CharSequence value) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkHeadWritten();
            this.headers.set(name2, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putHeader(CharSequence name2, Iterable<CharSequence> values2) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkHeadWritten();
            this.headers.set(name2, (Iterable)values2);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putTrailer(CharSequence name2, CharSequence value) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkValid();
            this.trailers().set(name2, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putTrailer(CharSequence name2, Iterable<CharSequence> value) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkValid();
            this.trailers().set(name2, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse setWriteQueueMaxSize(int size) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkValid();
            this.conn.doSetWriteQueueMaxSize(size);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeQueueFull() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkValid();
            return !this.writable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse drainHandler(Handler<Void> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (handler != null) {
                this.checkValid();
            }
            this.drainHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse exceptionHandler(Handler<Throwable> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (handler != null) {
                this.checkValid();
            }
            this.exceptionHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse closeHandler(Handler<Void> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (handler != null) {
                this.checkValid();
            }
            this.closeHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse endHandler(@Nullable Handler<Void> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (handler != null) {
                this.checkValid();
            }
            this.endHandler = handler;
            return this;
        }
    }

    @Override
    public Future<Void> write(Buffer chunk2) {
        PromiseInternal<Void> promise2 = this.context.promise();
        this.write(chunk2.getByteBuf(), promise2);
        return promise2.future();
    }

    @Override
    public void write(Buffer chunk2, Handler<AsyncResult<Void>> handler) {
        this.write(chunk2.getByteBuf(), handler == null ? null : this.context.promise(handler));
    }

    @Override
    public Future<Void> write(String chunk2, String enc) {
        PromiseInternal<Void> promise2 = this.context.promise();
        this.write(Buffer.buffer(chunk2, enc).getByteBuf(), promise2);
        return promise2.future();
    }

    @Override
    public void write(String chunk2, String enc, Handler<AsyncResult<Void>> handler) {
        this.write(Buffer.buffer(chunk2, enc).getByteBuf(), handler == null ? null : this.context.promise(handler));
    }

    @Override
    public Future<Void> write(String chunk2) {
        PromiseInternal<Void> promise2 = this.context.promise();
        this.write(Buffer.buffer(chunk2).getByteBuf(), promise2);
        return promise2.future();
    }

    @Override
    public void write(String chunk2, Handler<AsyncResult<Void>> handler) {
        this.write(Buffer.buffer(chunk2).getByteBuf(), handler == null ? null : this.context.promise(handler));
    }

    @Override
    public HttpServerResponse writeContinue() {
        this.conn.write100Continue();
        return this;
    }

    @Override
    public Future<Void> writeEarlyHints(MultiMap headers) {
        PromiseInternal<Void> promise2 = this.context.promise();
        this.writeEarlyHints(headers, promise2);
        return promise2.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeEarlyHints(MultiMap headers, Handler<AsyncResult<Void>> handler) {
        HeadersMultiMap headersMultiMap;
        if (headers instanceof HeadersMultiMap) {
            headersMultiMap = (HeadersMultiMap)headers;
        } else {
            headersMultiMap = HeadersMultiMap.httpHeaders();
            headersMultiMap.addAll(headers);
        }
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkHeadWritten();
        }
        this.conn.write103EarlyHints(headersMultiMap, this.context.promise(handler));
    }

    @Override
    public Future<Void> end(String chunk2) {
        return this.end(Buffer.buffer(chunk2));
    }

    @Override
    public void end(String chunk2, Handler<AsyncResult<Void>> handler) {
        this.end(Buffer.buffer(chunk2), handler);
    }

    @Override
    public Future<Void> end(String chunk2, String enc) {
        return this.end(Buffer.buffer(chunk2, enc));
    }

    @Override
    public void end(String chunk2, String enc, Handler<AsyncResult<Void>> handler) {
        this.end(Buffer.buffer(chunk2, enc), handler);
    }

    @Override
    public Future<Void> end(Buffer chunk2) {
        PromiseInternal<Void> promise2 = this.context.promise();
        this.end(chunk2, promise2);
        return promise2.future();
    }

    @Override
    public void end(Buffer chunk2, Handler<AsyncResult<Void>> handler) {
        this.end(chunk2, handler == null ? null : this.context.promise(handler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void end(Buffer chunk2, PromiseInternal<Void> listener) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            LastHttpContent msg;
            if (this.written) {
                throw new IllegalStateException(RESPONSE_WRITTEN);
            }
            this.written = true;
            ByteBuf data2 = chunk2.getByteBuf();
            this.bytesWritten += (long)data2.readableBytes();
            if (!this.headWritten) {
                this.prepareHeaders(this.bytesWritten);
                msg = new AssembledFullHttpResponse(this.head, this.version, this.status, this.headers, data2, this.trailingHeaders);
            } else {
                msg = new AssembledLastHttpContent(data2, this.trailingHeaders);
            }
            this.conn.writeToChannel((Object)msg, listener);
            this.conn.responseComplete();
            if (this.bodyEndHandler != null) {
                this.bodyEndHandler.handle(null);
            }
            if (!this.closed && this.endHandler != null) {
                this.endHandler.handle(null);
            }
            if (!this.keepAlive) {
                this.closeConnAfterWrite();
                this.closed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeHandshake() {
        if (this.conn.metrics != null) {
            this.conn.metrics.responseBegin(this.requestMetric, this);
        }
        this.setStatusCode(101);
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.headWritten = true;
            this.written = true;
        }
        this.conn.responseComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (!this.closed) {
                if (this.headWritten) {
                    this.closeConnAfterWrite();
                } else {
                    this.conn.close();
                }
                this.closed = true;
            }
        }
    }

    @Override
    public Future<Void> end() {
        return this.end(EMPTY_BUFFER);
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.end(EMPTY_BUFFER, handler);
    }

    @Override
    public Future<Void> sendFile(String filename, long offset, long length) {
        PromiseInternal<Void> promise2 = this.context.promise();
        this.sendFile(filename, offset, length, promise2);
        return promise2.future();
    }

    @Override
    public HttpServerResponse sendFile(String filename, long start2, long end2, Handler<AsyncResult<Void>> resultHandler) {
        this.doSendFile(filename, start2, end2, resultHandler);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ended() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.written;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closed() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean headWritten() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.headWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long bytesWritten() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            return this.bytesWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse headersEndHandler(Handler<Void> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.headersEndHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse bodyEndHandler(Handler<Void> handler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.bodyEndHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSendFile(String filename, long offset, long length, Handler<AsyncResult<Void>> resultHandler) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            ChannelFuture channelFuture;
            String contentType;
            long contentLength;
            this.checkValid();
            if (this.headWritten) {
                throw new IllegalStateException("Head already written");
            }
            File file2 = this.vertx.resolveFile(filename);
            if (!file2.exists()) {
                if (resultHandler != null) {
                    ContextInternal ctx = this.vertx.getOrCreateContext();
                    ctx.runOnContext(v -> resultHandler.handle(Future.failedFuture(new FileNotFoundException())));
                } else {
                    log.error("File not found: " + filename);
                }
                return;
            }
            this.bytesWritten = contentLength = Math.min(length, file2.length() - offset);
            if (!this.headers.contains(HttpHeaders.CONTENT_TYPE) && (contentType = MimeMapping.getMimeTypeForFilename(filename)) != null) {
                this.headers.set(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
            }
            this.prepareHeaders(this.bytesWritten);
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(file2, "r");
                this.conn.writeToChannel(new AssembledHttpResponse(this.head, this.version, this.status, this.headers));
                channelFuture = this.conn.sendFile(raf, Math.min(offset, file2.length()), contentLength);
            }
            catch (IOException e2) {
                try {
                    if (raf != null) {
                        raf.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (resultHandler != null) {
                    ContextInternal ctx = this.vertx.getOrCreateContext();
                    ctx.runOnContext(v -> resultHandler.handle(Future.failedFuture(e2)));
                } else {
                    log.error("Failed to send file", e2);
                }
                return;
            }
            this.written = true;
            ContextInternal ctx = this.vertx.getOrCreateContext();
            channelFuture.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)future2 -> {
                Handler<Void> end2;
                Handler<Void> handler;
                if (future2.isSuccess()) {
                    ChannelPromise pr2 = this.conn.channelHandlerContext().newPromise();
                    this.conn.writeToChannel((Object)LastHttpContent.EMPTY_LAST_CONTENT, pr2);
                    if (!this.keepAlive) {
                        pr2.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)a -> this.closeConnAfterWrite()));
                    }
                }
                if (resultHandler != null) {
                    Future res = future2.isSuccess() ? Future.succeededFuture() : Future.failedFuture(future2.cause());
                    ctx.emit(null, v -> resultHandler.handle(res));
                }
                Http1xServerConnection http1xServerConnection = this.conn;
                synchronized (http1xServerConnection) {
                    handler = this.bodyEndHandler;
                }
                if (handler != null) {
                    this.context.emit(handler);
                }
                this.conn.responseComplete();
                Http1xServerConnection http1xServerConnection2 = this.conn;
                synchronized (http1xServerConnection2) {
                    end2 = !this.closed ? this.endHandler : null;
                }
                if (null != end2) {
                    this.context.emit(end2);
                }
            }));
        }
    }

    private void closeConnAfterWrite() {
        ChannelPromise channelFuture = this.conn.channelFuture();
        this.conn.writeToChannel((Object)Unpooled.EMPTY_BUFFER, channelFuture);
        channelFuture.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)fut -> this.conn.close()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleWritabilityChanged(boolean writable) {
        Handler<Void> handler;
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            boolean skip = this.writable && !writable;
            this.writable = writable;
            handler = this.drainHandler;
            if (handler == null || skip) {
                return;
            }
        }
        this.context.dispatch(null, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Throwable t3) {
        if (t3 instanceof HttpClosedException) {
            this.handleClosed();
        } else {
            Handler<Throwable> handler;
            Http1xServerConnection http1xServerConnection = this.conn;
            synchronized (http1xServerConnection) {
                handler = this.exceptionHandler;
                if (handler == null) {
                    return;
                }
            }
            this.context.dispatch(t3, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClosed() {
        Handler<Void> closedHandler;
        Handler<Void> endHandler;
        Handler<Throwable> exceptionHandler;
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            exceptionHandler = this.written ? null : this.exceptionHandler;
            endHandler = this.written ? null : this.endHandler;
            closedHandler = this.closeHandler;
        }
        if (exceptionHandler != null) {
            this.context.dispatch(HttpUtils.CONNECTION_CLOSED_EXCEPTION, exceptionHandler);
        }
        if (endHandler != null) {
            this.context.dispatch(null, endHandler);
        }
        if (closedHandler != null) {
            this.context.dispatch(null, closedHandler);
        }
    }

    private void checkValid() {
        if (this.written) {
            throw new IllegalStateException(RESPONSE_WRITTEN);
        }
    }

    private void checkHeadWritten() {
        if (this.headWritten) {
            throw new IllegalStateException("Response head already sent");
        }
    }

    private void prepareHeaders(long contentLength) {
        if (this.version == HttpVersion.HTTP_1_0 && this.keepAlive) {
            this.headers.set(HttpHeaders.CONNECTION, HttpHeaders.KEEP_ALIVE);
        } else if (this.version == HttpVersion.HTTP_1_1 && !this.keepAlive) {
            this.headers.set(HttpHeaders.CONNECTION, HttpHeaders.CLOSE);
        }
        if (this.head || this.status == HttpResponseStatus.NOT_MODIFIED) {
            this.headers.remove(HttpHeaders.TRANSFER_ENCODING);
        } else if (contentLength >= 0L && !this.headers.contains(HttpHeaders.CONTENT_LENGTH) && !this.headers.contains(HttpHeaders.TRANSFER_ENCODING)) {
            String value = contentLength == 0L ? "0" : String.valueOf(contentLength);
            this.headers.set(HttpHeaders.CONTENT_LENGTH, (CharSequence)value);
        }
        if (this.headersEndHandler != null) {
            this.headersEndHandler.handle(null);
        }
        if (this.cookies != null) {
            this.setCookies();
        }
        if (Metrics.METRICS_ENABLED) {
            this.reportResponseBegin();
        }
        this.headWritten = true;
    }

    private void setCookies() {
        for (ServerCookie cookie : this.cookies) {
            if (!cookie.isChanged()) continue;
            this.headers.add(HttpHeaders.SET_COOKIE, (CharSequence)cookie.encode());
        }
    }

    private void reportResponseBegin() {
        if (this.conn.metrics != null) {
            this.conn.metrics.responseBegin(this.requestMetric, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Http1xServerResponse write(ByteBuf chunk2, PromiseInternal<Void> promise2) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            HttpContent msg;
            if (this.written) {
                throw new IllegalStateException(RESPONSE_WRITTEN);
            }
            if (!(this.headWritten || this.headers.contains(HttpHeaders.TRANSFER_ENCODING) || this.headers.contains(HttpHeaders.CONTENT_LENGTH) || this.version == HttpVersion.HTTP_1_0)) {
                throw new IllegalStateException("You must set the Content-Length header to be the total size of the message body BEFORE sending any data if you are not using HTTP chunked encoding.");
            }
            this.bytesWritten += (long)chunk2.readableBytes();
            if (!this.headWritten) {
                this.prepareHeaders(-1L);
                msg = new AssembledHttpResponse(this.head, this.version, this.status, this.headers, chunk2);
            } else {
                msg = new DefaultHttpContent(chunk2);
            }
            this.conn.writeToChannel((Object)msg, promise2);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Future<NetSocket> netSocket(HttpMethod requestMethod, MultiMap requestHeaders) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (this.netSocket == null) {
                if (this.headWritten) {
                    return this.context.failedFuture("Response already sent");
                }
                if (!HttpUtils.isConnectOrUpgrade(requestMethod, requestHeaders)) {
                    return this.context.failedFuture("HTTP method must be CONNECT or an HTTP upgrade to upgrade the connection to a TCP socket");
                }
                this.status = requestMethod == HttpMethod.CONNECT ? HttpResponseStatus.OK : HttpResponseStatus.SWITCHING_PROTOCOLS;
                this.prepareHeaders(-1L);
                PromiseInternal<Void> upgradePromise = this.context.promise();
                this.conn.writeToChannel((Object)new AssembledHttpResponse(this.head, this.version, this.status, this.headers), upgradePromise);
                this.written = true;
                PromiseInternal<NetSocket> promise2 = this.context.promise();
                this.netSocket = promise2.future();
                this.conn.netSocket((Promise<NetSocket>)promise2);
            }
        }
        return this.netSocket;
    }

    @Override
    public int streamId() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reset(long code) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (this.written) {
                return false;
            }
        }
        this.close();
        return true;
    }

    @Override
    public Future<HttpServerResponse> push(HttpMethod method, String host, String path2, MultiMap headers) {
        return this.context.failedFuture("HTTP/1 does not support response push");
    }

    @Override
    public HttpServerResponse writeCustomFrame(int type2, int flags, Buffer payload) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CookieJar cookies() {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            if (this.cookies == null) {
                String cookieHeader = this.request.headers().get(HttpHeaders.COOKIE);
                this.cookies = cookieHeader == null ? new CookieJar() : new CookieJar(cookieHeader);
            }
        }
        return this.cookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse addCookie(Cookie cookie) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkHeadWritten();
            this.cookies().add((ServerCookie)cookie);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Cookie removeCookie(String name2, boolean invalidate) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkHeadWritten();
            return this.cookies().removeOrInvalidate(name2, invalidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Cookie removeCookie(String name2, String domain, String path2, boolean invalidate) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkHeadWritten();
            return this.cookies().removeOrInvalidate(name2, domain, path2, invalidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Set<Cookie> removeCookies(String name2, boolean invalidate) {
        Http1xServerConnection http1xServerConnection = this.conn;
        synchronized (http1xServerConnection) {
            this.checkHeadWritten();
            return this.cookies().removeOrInvalidateAll(name2, invalidate);
        }
    }
}

