/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.MultiMap;
import io.vertx.core.VertxException;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptionsConverter;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@DataObject(generateConverter=true)
public class RequestOptions {
    public static final ProxyOptions DEFAULT_PROXY_OPTIONS = null;
    public static final SocketAddress DEFAULT_SERVER = null;
    public static final HttpMethod DEFAULT_HTTP_METHOD = HttpMethod.GET;
    public static final String DEFAULT_HOST = null;
    public static final Integer DEFAULT_PORT = null;
    public static final Boolean DEFAULT_SSL = null;
    public static final String DEFAULT_URI = "/";
    public static final boolean DEFAULT_FOLLOW_REDIRECTS = false;
    public static final long DEFAULT_TIMEOUT = 0L;
    private ProxyOptions proxyOptions;
    private SocketAddress server;
    private HttpMethod method;
    private String host;
    private Integer port;
    private Boolean ssl;
    private String uri;
    private MultiMap headers;
    private boolean followRedirects;
    private long timeout;
    private String traceOperation;

    public RequestOptions() {
        this.proxyOptions = DEFAULT_PROXY_OPTIONS;
        this.server = DEFAULT_SERVER;
        this.method = DEFAULT_HTTP_METHOD;
        this.host = DEFAULT_HOST;
        this.port = DEFAULT_PORT;
        this.ssl = DEFAULT_SSL;
        this.uri = DEFAULT_URI;
        this.followRedirects = false;
        this.timeout = 0L;
        this.traceOperation = null;
    }

    public RequestOptions(RequestOptions other) {
        this.setProxyOptions(other.proxyOptions);
        this.setServer(other.server);
        this.setMethod(other.method);
        this.setHost(other.host);
        this.setPort(other.port);
        this.setSsl(other.ssl);
        this.setURI(other.uri);
        this.setFollowRedirects(other.followRedirects);
        this.setTimeout(other.timeout);
        if (other.headers != null) {
            this.setHeaders(MultiMap.caseInsensitiveMultiMap().setAll(other.headers));
        }
        this.setTraceOperation(other.traceOperation);
    }

    public RequestOptions(JsonObject json) {
        this();
        JsonObject headers;
        JsonObject server2;
        RequestOptionsConverter.fromJson(json, this);
        String method = json.getString("method");
        if (method != null) {
            this.setMethod(HttpMethod.valueOf(method));
        }
        if ((server2 = json.getJsonObject("server")) != null) {
            Integer port = server2.getInteger("port", 80);
            String host = server2.getString("host");
            String path2 = server2.getString("path");
            if (host != null) {
                this.server = SocketAddress.inetSocketAddress(port, host);
            } else if (path2 != null) {
                this.server = SocketAddress.domainSocketAddress(path2);
            }
        }
        if ((headers = json.getJsonObject("headers")) != null) {
            for (Map.Entry<String, Object> entry : headers) {
                Object value = entry.getValue();
                if (value instanceof String) {
                    this.addHeader(entry.getKey(), (String)value);
                    continue;
                }
                if (!(value instanceof Iterable)) continue;
                for (Object subValue : (Iterable)value) {
                    if (!(subValue instanceof String)) continue;
                    this.addHeader(entry.getKey(), (String)subValue);
                }
            }
        }
    }

    public ProxyOptions getProxyOptions() {
        return this.proxyOptions;
    }

    public RequestOptions setProxyOptions(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public SocketAddress getServer() {
        return this.server;
    }

    public RequestOptions setServer(SocketAddress server2) {
        this.server = server2;
        return this;
    }

    @GenIgnore
    public HttpMethod getMethod() {
        return this.method;
    }

    @GenIgnore
    public RequestOptions setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public RequestOptions setHost(String host) {
        this.host = host;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public RequestOptions setPort(Integer port) {
        this.port = port;
        return this;
    }

    public Boolean isSsl() {
        return this.ssl;
    }

    public RequestOptions setSsl(Boolean ssl) {
        this.ssl = ssl;
        return this;
    }

    public String getURI() {
        return this.uri;
    }

    public RequestOptions setURI(String uri) {
        this.uri = uri;
        return this;
    }

    public Boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public RequestOptions setFollowRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public RequestOptions setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    private URL parseUrl(String surl) {
        try {
            return new URL(surl);
        }
        catch (MalformedURLException e2) {
            throw new VertxException("Invalid url: " + surl, e2);
        }
    }

    public RequestOptions setAbsoluteURI(String absoluteURI) {
        Objects.requireNonNull(absoluteURI, "Cannot set a null absolute URI");
        URL url = this.parseUrl(absoluteURI);
        return this.setAbsoluteURI(url);
    }

    @GenIgnore(value={"permitted-type"})
    public RequestOptions setAbsoluteURI(URL url) {
        String protocol2;
        Objects.requireNonNull(url, "Cannot set a null absolute URI");
        Boolean ssl = Boolean.FALSE;
        int port = url.getPort();
        String relativeUri = url.getPath().isEmpty() ? DEFAULT_URI + url.getFile() : url.getFile();
        switch (protocol2 = url.getProtocol()) {
            case "http": {
                if (port != -1) break;
                port = 80;
                break;
            }
            case "https": {
                ssl = Boolean.TRUE;
                if (port != -1) break;
                port = 443;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.uri = relativeUri;
        this.port = port;
        this.ssl = ssl;
        this.host = url.getHost();
        return this;
    }

    @GenIgnore
    public RequestOptions addHeader(String key2, String value) {
        return this.addHeader((CharSequence)key2, (CharSequence)value);
    }

    @GenIgnore
    public RequestOptions addHeader(CharSequence key2, CharSequence value) {
        this.checkHeaders();
        Objects.requireNonNull(key2, "no null key accepted");
        Objects.requireNonNull(value, "no null value accepted");
        this.headers.add(key2, value);
        return this;
    }

    @GenIgnore
    public RequestOptions addHeader(CharSequence key2, Iterable<CharSequence> values2) {
        this.checkHeaders();
        Objects.requireNonNull(key2, "no null key accepted");
        Objects.requireNonNull(values2, "no null values accepted");
        this.headers.add(key2, values2);
        return this;
    }

    @GenIgnore
    public RequestOptions putHeader(String key2, String value) {
        return this.putHeader((CharSequence)key2, (CharSequence)value);
    }

    @GenIgnore
    public RequestOptions putHeader(CharSequence key2, CharSequence value) {
        this.checkHeaders();
        this.headers.set(key2, value);
        return this;
    }

    @GenIgnore
    public RequestOptions putHeader(CharSequence key2, Iterable<CharSequence> values2) {
        this.checkHeaders();
        this.headers.set(key2, values2);
        return this;
    }

    @GenIgnore
    public RequestOptions removeHeader(String key2) {
        return this.removeHeader((CharSequence)key2);
    }

    @GenIgnore
    public RequestOptions removeHeader(CharSequence key2) {
        if (this.headers != null) {
            this.headers.remove(key2);
        }
        return this;
    }

    @GenIgnore
    public RequestOptions setHeaders(MultiMap headers) {
        this.headers = headers;
        return this;
    }

    @GenIgnore
    public MultiMap getHeaders() {
        return this.headers;
    }

    private void checkHeaders() {
        if (this.headers == null) {
            this.headers = HttpHeaders.headers();
        }
    }

    public String getTraceOperation() {
        return this.traceOperation;
    }

    public RequestOptions setTraceOperation(String op) {
        this.traceOperation = op;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        RequestOptionsConverter.toJson(this, json);
        if (this.method != null) {
            json.put("method", this.method.name());
        }
        if (this.server != null) {
            JsonObject server2 = new JsonObject();
            if (this.server.isInetSocket()) {
                server2.put("host", this.server.host());
                server2.put("port", this.server.port());
            } else {
                server2.put("path", this.server.path());
            }
            json.put("server", server2);
        }
        if (this.headers != null) {
            JsonObject headers = new JsonObject();
            for (String name2 : this.headers.names()) {
                List<String> values2 = this.headers.getAll(name2);
                if (values2.size() == 1) {
                    headers.put(name2, values2.iterator().next());
                    continue;
                }
                headers.put(name2, values2);
            }
            json.put("headers", headers);
        }
        return json;
    }
}

