/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import java.util.Set;

@VertxGen
public interface HttpServerResponse
extends WriteStream<Buffer> {
    @Override
    public HttpServerResponse exceptionHandler(Handler<Throwable> var1);

    public HttpServerResponse setWriteQueueMaxSize(int var1);

    public HttpServerResponse drainHandler(Handler<Void> var1);

    public int getStatusCode();

    @Fluent
    public HttpServerResponse setStatusCode(int var1);

    public String getStatusMessage();

    @Fluent
    public HttpServerResponse setStatusMessage(String var1);

    @Fluent
    public HttpServerResponse setChunked(boolean var1);

    public boolean isChunked();

    @CacheReturn
    public MultiMap headers();

    @Fluent
    public HttpServerResponse putHeader(String var1, String var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public HttpServerResponse putHeader(CharSequence var1, CharSequence var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public HttpServerResponse putHeader(String var1, Iterable<String> var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public HttpServerResponse putHeader(CharSequence var1, Iterable<CharSequence> var2);

    @CacheReturn
    public MultiMap trailers();

    @Fluent
    public HttpServerResponse putTrailer(String var1, String var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public HttpServerResponse putTrailer(CharSequence var1, CharSequence var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public HttpServerResponse putTrailer(String var1, Iterable<String> var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public HttpServerResponse putTrailer(CharSequence var1, Iterable<CharSequence> var2);

    @Fluent
    public HttpServerResponse closeHandler(@Nullable Handler<Void> var1);

    @Fluent
    public HttpServerResponse endHandler(@Nullable Handler<Void> var1);

    public Future<Void> write(String var1, String var2);

    public void write(String var1, String var2, Handler<AsyncResult<Void>> var3);

    @Override
    public Future<Void> write(String var1);

    @Override
    public void write(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public HttpServerResponse writeContinue();

    public Future<Void> writeEarlyHints(MultiMap var1);

    public void writeEarlyHints(MultiMap var1, Handler<AsyncResult<Void>> var2);

    @Override
    public Future<Void> end(String var1);

    @Override
    public void end(String var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> end(String var1, String var2);

    public void end(String var1, String var2, Handler<AsyncResult<Void>> var3);

    @Override
    public Future<Void> end(Buffer var1);

    @Override
    public void end(Buffer var1, Handler<AsyncResult<Void>> var2);

    @Override
    public Future<Void> end();

    default public void send(Handler<AsyncResult<Void>> handler) {
        this.end(handler);
    }

    default public Future<Void> send() {
        return this.end();
    }

    default public void send(String body, Handler<AsyncResult<Void>> handler) {
        this.end(body, handler);
    }

    default public Future<Void> send(String body) {
        return this.end(body);
    }

    default public void send(Buffer body, Handler<AsyncResult<Void>> handler) {
        this.end(body, handler);
    }

    default public Future<Void> send(Buffer body) {
        return this.end(body);
    }

    default public void send(ReadStream<Buffer> body, Handler<AsyncResult<Void>> handler) {
        MultiMap headers = this.headers();
        if (headers == null || !headers.contains(HttpHeaders.CONTENT_LENGTH)) {
            this.setChunked(true);
        }
        body.pipeTo(this, handler);
    }

    default public Future<Void> send(ReadStream<Buffer> body) {
        MultiMap headers = this.headers();
        if (headers == null || !headers.contains(HttpHeaders.CONTENT_LENGTH)) {
            this.setChunked(true);
        }
        return body.pipeTo(this);
    }

    default public Future<Void> sendFile(String filename) {
        return this.sendFile(filename, 0L);
    }

    default public Future<Void> sendFile(String filename, long offset) {
        return this.sendFile(filename, offset, Long.MAX_VALUE);
    }

    public Future<Void> sendFile(String var1, long var2, long var4);

    @Fluent
    default public HttpServerResponse sendFile(String filename, Handler<AsyncResult<Void>> resultHandler) {
        return this.sendFile(filename, 0L, resultHandler);
    }

    @Fluent
    default public HttpServerResponse sendFile(String filename, long offset, Handler<AsyncResult<Void>> resultHandler) {
        return this.sendFile(filename, offset, Long.MAX_VALUE, resultHandler);
    }

    @Fluent
    public HttpServerResponse sendFile(String var1, long var2, long var4, Handler<AsyncResult<Void>> var6);

    public void close();

    public boolean ended();

    public boolean closed();

    public boolean headWritten();

    @Fluent
    public HttpServerResponse headersEndHandler(@Nullable Handler<Void> var1);

    @Fluent
    public HttpServerResponse bodyEndHandler(@Nullable Handler<Void> var1);

    public long bytesWritten();

    public int streamId();

    @Fluent
    default public HttpServerResponse push(HttpMethod method, String host, String path2, Handler<AsyncResult<HttpServerResponse>> handler) {
        return this.push(method, host, path2, null, handler);
    }

    default public Future<HttpServerResponse> push(HttpMethod method, String host, String path2) {
        return this.push(method, host, path2, (MultiMap)null);
    }

    @Fluent
    default public HttpServerResponse push(HttpMethod method, String path2, MultiMap headers, Handler<AsyncResult<HttpServerResponse>> handler) {
        return this.push(method, null, path2, headers, handler);
    }

    default public Future<HttpServerResponse> push(HttpMethod method, String path2, MultiMap headers) {
        return this.push(method, null, path2, headers);
    }

    @Fluent
    default public HttpServerResponse push(HttpMethod method, String path2, Handler<AsyncResult<HttpServerResponse>> handler) {
        return this.push(method, null, path2, null, handler);
    }

    default public Future<HttpServerResponse> push(HttpMethod method, String path2) {
        return this.push(method, null, path2);
    }

    @Fluent
    default public HttpServerResponse push(HttpMethod method, String host, String path2, MultiMap headers, Handler<AsyncResult<HttpServerResponse>> handler) {
        Future<HttpServerResponse> fut = this.push(method, host, path2, headers);
        if (handler != null) {
            fut.onComplete(handler);
        }
        return this;
    }

    public Future<HttpServerResponse> push(HttpMethod var1, String var2, String var3, MultiMap var4);

    default public boolean reset() {
        return this.reset(0L);
    }

    public boolean reset(long var1);

    @Fluent
    public HttpServerResponse writeCustomFrame(int var1, int var2, Buffer var3);

    @Fluent
    default public HttpServerResponse writeCustomFrame(HttpFrame frame) {
        return this.writeCustomFrame(frame.type(), frame.flags(), frame.payload());
    }

    @Fluent
    default public HttpServerResponse setStreamPriority(StreamPriority streamPriority) {
        return this;
    }

    @Fluent
    public HttpServerResponse addCookie(Cookie var1);

    default public @Nullable Cookie removeCookie(String name2) {
        return this.removeCookie(name2, true);
    }

    public @Nullable Cookie removeCookie(String var1, boolean var2);

    default public Set<Cookie> removeCookies(String name2) {
        return this.removeCookies(name2, true);
    }

    public Set<Cookie> removeCookies(String var1, boolean var2);

    default public @Nullable Cookie removeCookie(String name2, String domain, String path2) {
        return this.removeCookie(name2, domain, path2, true);
    }

    public @Nullable Cookie removeCookie(String var1, String var2, String var3, boolean var4);
}

