/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.core.tracing.TracingPolicy;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;

public class HttpServerOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, HttpServerOptions obj2) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "acceptUnmaskedFrames": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setAcceptUnmaskedFrames((Boolean)member.getValue());
                    break;
                }
                case "alpnVersions": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<HttpVersion> list = new ArrayList<HttpVersion>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add(HttpVersion.valueOf((String)item));
                        }
                    });
                    obj2.setAlpnVersions(list);
                    break;
                }
                case "compressionLevel": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setCompressionLevel(((Number)member.getValue()).intValue());
                    break;
                }
                case "compressionSupported": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setCompressionSupported((Boolean)member.getValue());
                    break;
                }
                case "decoderInitialBufferSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setDecoderInitialBufferSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "decompressionSupported": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setDecompressionSupported((Boolean)member.getValue());
                    break;
                }
                case "handle100ContinueAutomatically": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setHandle100ContinueAutomatically((Boolean)member.getValue());
                    break;
                }
                case "http2ConnectionWindowSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setHttp2ConnectionWindowSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "initialSettings": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setInitialSettings(new Http2Settings((JsonObject)member.getValue()));
                    break;
                }
                case "maxChunkSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setMaxChunkSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxFormAttributeSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setMaxFormAttributeSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxHeaderSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setMaxHeaderSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxInitialLineLength": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setMaxInitialLineLength(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxWebSocketFrameSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setMaxWebSocketFrameSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxWebSocketMessageSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setMaxWebSocketMessageSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "perFrameWebSocketCompressionSupported": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setPerFrameWebSocketCompressionSupported((Boolean)member.getValue());
                    break;
                }
                case "perMessageWebSocketCompressionSupported": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setPerMessageWebSocketCompressionSupported((Boolean)member.getValue());
                    break;
                }
                case "registerWebSocketWriteHandlers": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setRegisterWebSocketWriteHandlers((Boolean)member.getValue());
                    break;
                }
                case "tracingPolicy": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setTracingPolicy(TracingPolicy.valueOf((String)member.getValue()));
                    break;
                }
                case "webSocketAllowServerNoContext": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setWebSocketAllowServerNoContext((Boolean)member.getValue());
                    break;
                }
                case "webSocketClosingTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setWebSocketClosingTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "webSocketCompressionLevel": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setWebSocketCompressionLevel(((Number)member.getValue()).intValue());
                    break;
                }
                case "webSocketPreferredClientNoContext": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setWebSocketPreferredClientNoContext((Boolean)member.getValue());
                    break;
                }
                case "webSocketSubProtocols": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<HttpVersion> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((HttpVersion)((Object)((String)item)));
                        }
                    });
                    obj2.setWebSocketSubProtocols(list);
                }
            }
        }
    }

    static void toJson(HttpServerOptions obj2, JsonObject json) {
        HttpServerOptionsConverter.toJson(obj2, json.getMap());
    }

    static void toJson(HttpServerOptions obj2, Map<String, Object> json) {
        JsonArray array2;
        json.put("acceptUnmaskedFrames", obj2.isAcceptUnmaskedFrames());
        if (obj2.getAlpnVersions() != null) {
            array2 = new JsonArray();
            obj2.getAlpnVersions().forEach(item -> array2.add(item.name()));
            json.put("alpnVersions", array2);
        }
        json.put("compressionLevel", obj2.getCompressionLevel());
        json.put("compressionSupported", obj2.isCompressionSupported());
        json.put("decoderInitialBufferSize", obj2.getDecoderInitialBufferSize());
        json.put("decompressionSupported", obj2.isDecompressionSupported());
        json.put("handle100ContinueAutomatically", obj2.isHandle100ContinueAutomatically());
        json.put("http2ConnectionWindowSize", obj2.getHttp2ConnectionWindowSize());
        if (obj2.getInitialSettings() != null) {
            json.put("initialSettings", obj2.getInitialSettings().toJson());
        }
        json.put("maxChunkSize", obj2.getMaxChunkSize());
        json.put("maxFormAttributeSize", obj2.getMaxFormAttributeSize());
        json.put("maxHeaderSize", obj2.getMaxHeaderSize());
        json.put("maxInitialLineLength", obj2.getMaxInitialLineLength());
        json.put("maxWebSocketFrameSize", obj2.getMaxWebSocketFrameSize());
        json.put("maxWebSocketMessageSize", obj2.getMaxWebSocketMessageSize());
        json.put("perFrameWebSocketCompressionSupported", obj2.getPerFrameWebSocketCompressionSupported());
        json.put("perMessageWebSocketCompressionSupported", obj2.getPerMessageWebSocketCompressionSupported());
        json.put("registerWebSocketWriteHandlers", obj2.isRegisterWebSocketWriteHandlers());
        if (obj2.getTracingPolicy() != null) {
            json.put("tracingPolicy", obj2.getTracingPolicy().name());
        }
        json.put("webSocketAllowServerNoContext", obj2.getWebSocketAllowServerNoContext());
        json.put("webSocketClosingTimeout", obj2.getWebSocketClosingTimeout());
        json.put("webSocketCompressionLevel", obj2.getWebSocketCompressionLevel());
        json.put("webSocketPreferredClientNoContext", obj2.getWebSocketPreferredClientNoContext());
        if (obj2.getWebSocketSubProtocols() != null) {
            array2 = new JsonArray();
            obj2.getWebSocketSubProtocols().forEach(item -> array2.add(item));
            json.put("webSocketSubProtocols", array2);
        }
    }
}

