/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.core.tracing.TracingPolicy;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;

public class HttpClientOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, HttpClientOptions obj2) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "alpnVersions": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<HttpVersion> list = new ArrayList<HttpVersion>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add(HttpVersion.valueOf((String)item));
                        }
                    });
                    obj2.setAlpnVersions(list);
                    break;
                }
                case "decoderInitialBufferSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setDecoderInitialBufferSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "defaultHost": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setDefaultHost((String)member.getValue());
                    break;
                }
                case "defaultPort": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setDefaultPort(((Number)member.getValue()).intValue());
                    break;
                }
                case "forceSni": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setForceSni((Boolean)member.getValue());
                    break;
                }
                case "http2ClearTextUpgrade": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setHttp2ClearTextUpgrade((Boolean)member.getValue());
                    break;
                }
                case "http2ClearTextUpgradeWithPreflightRequest": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setHttp2ClearTextUpgradeWithPreflightRequest((Boolean)member.getValue());
                    break;
                }
                case "http2ConnectionWindowSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setHttp2ConnectionWindowSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "http2KeepAliveTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setHttp2KeepAliveTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "http2MaxPoolSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setHttp2MaxPoolSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "http2MultiplexingLimit": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setHttp2MultiplexingLimit(((Number)member.getValue()).intValue());
                    break;
                }
                case "initialSettings": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setInitialSettings(new Http2Settings((JsonObject)member.getValue()));
                    break;
                }
                case "keepAlive": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setKeepAlive((Boolean)member.getValue());
                    break;
                }
                case "keepAliveTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setKeepAliveTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxChunkSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setMaxChunkSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxHeaderSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setMaxHeaderSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxInitialLineLength": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setMaxInitialLineLength(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxPoolSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setMaxPoolSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxRedirects": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setMaxRedirects(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxWaitQueueSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setMaxWaitQueueSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxWebSocketFrameSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setMaxWebSocketFrameSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxWebSocketMessageSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setMaxWebSocketMessageSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxWebSockets": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setMaxWebSockets(((Number)member.getValue()).intValue());
                    break;
                }
                case "name": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setName((String)member.getValue());
                    break;
                }
                case "pipelining": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setPipelining((Boolean)member.getValue());
                    break;
                }
                case "pipeliningLimit": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setPipeliningLimit(((Number)member.getValue()).intValue());
                    break;
                }
                case "poolCleanerPeriod": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setPoolCleanerPeriod(((Number)member.getValue()).intValue());
                    break;
                }
                case "poolEventLoopSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setPoolEventLoopSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "protocolVersion": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setProtocolVersion(HttpVersion.valueOf((String)member.getValue()));
                    break;
                }
                case "sendUnmaskedFrames": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setSendUnmaskedFrames((Boolean)member.getValue());
                    break;
                }
                case "shared": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setShared((Boolean)member.getValue());
                    break;
                }
                case "tracingPolicy": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setTracingPolicy(TracingPolicy.valueOf((String)member.getValue()));
                    break;
                }
                case "tryUseCompression": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setTryUseCompression((Boolean)member.getValue());
                    break;
                }
                case "tryUsePerFrameWebSocketCompression": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setTryUsePerFrameWebSocketCompression((Boolean)member.getValue());
                    break;
                }
                case "tryUsePerMessageWebSocketCompression": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setTryUsePerMessageWebSocketCompression((Boolean)member.getValue());
                    break;
                }
                case "tryWebSocketDeflateFrameCompression": {
                    break;
                }
                case "verifyHost": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setVerifyHost((Boolean)member.getValue());
                    break;
                }
                case "webSocketClosingTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setWebSocketClosingTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "webSocketCompressionAllowClientNoContext": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setWebSocketCompressionAllowClientNoContext((Boolean)member.getValue());
                    break;
                }
                case "webSocketCompressionLevel": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setWebSocketCompressionLevel(((Number)member.getValue()).intValue());
                    break;
                }
                case "webSocketCompressionRequestServerNoContext": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setWebSocketCompressionRequestServerNoContext((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(HttpClientOptions obj2, JsonObject json) {
        HttpClientOptionsConverter.toJson(obj2, json.getMap());
    }

    static void toJson(HttpClientOptions obj2, Map<String, Object> json) {
        if (obj2.getAlpnVersions() != null) {
            JsonArray array2 = new JsonArray();
            obj2.getAlpnVersions().forEach(item -> array2.add(item.name()));
            json.put("alpnVersions", array2);
        }
        json.put("decoderInitialBufferSize", obj2.getDecoderInitialBufferSize());
        if (obj2.getDefaultHost() != null) {
            json.put("defaultHost", obj2.getDefaultHost());
        }
        json.put("defaultPort", obj2.getDefaultPort());
        json.put("forceSni", obj2.isForceSni());
        json.put("http2ClearTextUpgrade", obj2.isHttp2ClearTextUpgrade());
        json.put("http2ClearTextUpgradeWithPreflightRequest", obj2.isHttp2ClearTextUpgradeWithPreflightRequest());
        json.put("http2ConnectionWindowSize", obj2.getHttp2ConnectionWindowSize());
        json.put("http2KeepAliveTimeout", obj2.getHttp2KeepAliveTimeout());
        json.put("http2MaxPoolSize", obj2.getHttp2MaxPoolSize());
        json.put("http2MultiplexingLimit", obj2.getHttp2MultiplexingLimit());
        if (obj2.getInitialSettings() != null) {
            json.put("initialSettings", obj2.getInitialSettings().toJson());
        }
        json.put("keepAlive", obj2.isKeepAlive());
        json.put("keepAliveTimeout", obj2.getKeepAliveTimeout());
        json.put("maxChunkSize", obj2.getMaxChunkSize());
        json.put("maxHeaderSize", obj2.getMaxHeaderSize());
        json.put("maxInitialLineLength", obj2.getMaxInitialLineLength());
        json.put("maxPoolSize", obj2.getMaxPoolSize());
        json.put("maxRedirects", obj2.getMaxRedirects());
        json.put("maxWaitQueueSize", obj2.getMaxWaitQueueSize());
        json.put("maxWebSocketFrameSize", obj2.getMaxWebSocketFrameSize());
        json.put("maxWebSocketMessageSize", obj2.getMaxWebSocketMessageSize());
        json.put("maxWebSockets", obj2.getMaxWebSockets());
        if (obj2.getName() != null) {
            json.put("name", obj2.getName());
        }
        json.put("pipelining", obj2.isPipelining());
        json.put("pipeliningLimit", obj2.getPipeliningLimit());
        json.put("poolCleanerPeriod", obj2.getPoolCleanerPeriod());
        json.put("poolEventLoopSize", obj2.getPoolEventLoopSize());
        if (obj2.getProtocolVersion() != null) {
            json.put("protocolVersion", obj2.getProtocolVersion().name());
        }
        json.put("sendUnmaskedFrames", obj2.isSendUnmaskedFrames());
        json.put("shared", obj2.isShared());
        if (obj2.getTracingPolicy() != null) {
            json.put("tracingPolicy", obj2.getTracingPolicy().name());
        }
        json.put("tryUseCompression", obj2.isTryUseCompression());
        json.put("tryUsePerMessageWebSocketCompression", obj2.getTryUsePerMessageWebSocketCompression());
        json.put("tryWebSocketDeflateFrameCompression", obj2.getTryWebSocketDeflateFrameCompression());
        json.put("verifyHost", obj2.isVerifyHost());
        json.put("webSocketClosingTimeout", obj2.getWebSocketClosingTimeout());
        json.put("webSocketCompressionAllowClientNoContext", obj2.getWebSocketCompressionAllowClientNoContext());
        json.put("webSocketCompressionLevel", obj2.getWebSocketCompressionLevel());
        json.put("webSocketCompressionRequestServerNoContext", obj2.getWebSocketCompressionRequestServerNoContext());
    }
}

