/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.file.impl;

import io.netty.util.internal.PlatformDependent;
import io.vertx.core.VertxException;
import io.vertx.core.file.FileSystemOptions;
import io.vertx.core.file.impl.FileCache;
import io.vertx.core.file.impl.FileSystemImpl;
import io.vertx.core.net.impl.URIDecoder;
import io.vertx.core.spi.file.FileResolver;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileResolverImpl
implements FileResolver {
    public static final String DISABLE_FILE_CACHING_PROP_NAME = "vertx.disableFileCaching";
    public static final String DISABLE_CP_RESOLVING_PROP_NAME = "vertx.disableFileCPResolving";
    public static final String CACHE_DIR_BASE_PROP_NAME = "vertx.cacheDirBase";
    private static final boolean NON_UNIX_FILE_SEP = File.separatorChar != '/';
    private static final String JAR_URL_SEP = "!/";
    private final File cwd;
    private final boolean enableCaching;
    private final boolean enableCPResolving;
    private final FileCache cache;

    public FileResolverImpl() {
        this(new FileSystemOptions());
    }

    public FileResolverImpl(FileSystemOptions fileSystemOptions) {
        this.enableCaching = fileSystemOptions.isFileCachingEnabled();
        this.enableCPResolving = fileSystemOptions.isClassPathResolvingEnabled();
        this.cache = this.enableCPResolving ? FileCache.setupCache(fileSystemOptions.getFileCacheDir()) : null;
        String cwdOverride = System.getProperty("vertx.cwd");
        this.cwd = cwdOverride != null ? new File(cwdOverride).getAbsoluteFile() : null;
    }

    public String cacheDir() {
        if (this.cache != null) {
            return this.cache.cacheDir();
        }
        return null;
    }

    FileCache getFileCache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.enableCPResolving) {
            FileCache fileCache = this.cache;
            synchronized (fileCache) {
                this.cache.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File resolveFile(String fileName) {
        File file2 = new File(fileName);
        boolean absolute = file2.isAbsolute();
        File resolved = this.cwd != null && !absolute ? new File(this.cwd, fileName) : file2;
        if (this.cache == null) {
            return resolved;
        }
        if (!resolved.exists()) {
            FileCache fileCache = this.cache;
            synchronized (fileCache) {
                File cacheFile = this.cache.getCanonicalFile(file2);
                if (cacheFile == null) {
                    return file2;
                }
                String relativize = this.cache.relativize(cacheFile.getPath());
                if (relativize != null) {
                    if (this.enableCaching && cacheFile.exists()) {
                        return cacheFile;
                    }
                    if (absolute) {
                        fileName = relativize;
                        file2 = new File(relativize);
                        absolute = false;
                    }
                }
                if (!absolute) {
                    URL url;
                    ClassLoader cl = this.getClassLoader();
                    for (File parentFile = file2.getParentFile(); parentFile != null; parentFile = parentFile.getParentFile()) {
                        URL directoryContents;
                        String parentFileName = parentFile.getPath();
                        if (NON_UNIX_FILE_SEP) {
                            parentFileName = parentFileName.replace(File.separatorChar, '/');
                        }
                        if ((directoryContents = FileResolverImpl.getValidClassLoaderResource(cl, parentFileName)) == null) continue;
                        this.unpackUrlResource(directoryContents, parentFileName, cl, true);
                    }
                    if (NON_UNIX_FILE_SEP) {
                        fileName = fileName.replace(File.separatorChar, '/');
                    }
                    if ((url = FileResolverImpl.getValidClassLoaderResource(cl, fileName)) != null) {
                        return this.unpackUrlResource(url, fileName, cl, false);
                    }
                }
            }
        }
        return file2;
    }

    private static boolean isValidWindowsCachePath(char c) {
        if (c < ' ') {
            return false;
        }
        switch (c) {
            case '\"': 
            case '*': 
            case ':': 
            case '<': 
            case '>': 
            case '?': 
            case '|': {
                return false;
            }
        }
        return true;
    }

    private static boolean isValidCachePath(String fileName) {
        if (PlatformDependent.isWindows()) {
            int len = fileName.length();
            for (int i = 0; i < len; ++i) {
                char c = fileName.charAt(i);
                if (!FileResolverImpl.isValidWindowsCachePath(c)) {
                    return false;
                }
                if (c != ' ' || i + 1 != len && fileName.charAt(i + 1) != '/') continue;
                return false;
            }
            return true;
        }
        return fileName.indexOf(0) == -1;
    }

    private static URL getValidClassLoaderResource(ClassLoader cl, String fileName) {
        URL resource2 = cl.getResource(fileName);
        if (resource2 != null && !FileResolverImpl.isValidCachePath(fileName)) {
            return null;
        }
        return resource2;
    }

    private File unpackUrlResource(URL url, String fileName, ClassLoader cl, boolean isDir) {
        String prot;
        switch (prot = url.getProtocol()) {
            case "file": {
                return this.unpackFromFileURL(url, fileName, cl);
            }
            case "jar": {
                return this.unpackFromJarURL(url, fileName, cl);
            }
            case "bundle": 
            case "bundleentry": 
            case "bundleresource": 
            case "jrt": 
            case "resource": 
            case "vfs": {
                return this.unpackFromBundleURL(url, fileName, isDir);
            }
        }
        throw new IllegalStateException("Invalid url protocol: " + prot);
    }

    private File unpackFromFileURL(URL url, String fileName, ClassLoader cl) {
        String[] listing;
        File cacheFile;
        File resource2 = new File(URIDecoder.decodeURIComponent(url.getPath(), false));
        boolean isDirectory = resource2.isDirectory();
        try {
            cacheFile = this.cache.cacheFile(fileName, resource2, !this.enableCaching);
        }
        catch (IOException e2) {
            throw new VertxException(FileSystemImpl.getFileAccessErrorMessage("unpack", url.toString()), e2);
        }
        if (isDirectory && (listing = resource2.list()) != null) {
            for (String file2 : listing) {
                String subResource = fileName + "/" + file2;
                URL url2 = FileResolverImpl.getValidClassLoaderResource(cl, subResource);
                if (url2 == null) {
                    throw new VertxException("Invalid resource: " + subResource);
                }
                this.unpackFromFileURL(url2, subResource, cl);
            }
        }
        return cacheFile;
    }

    private File unpackFromJarURL(URL url, String fileName, ClassLoader cl) {
        ZipFile zip2 = null;
        try {
            String prefixCheck;
            int second2;
            int idx2;
            String path2 = url.getPath();
            int idx1 = path2.lastIndexOf(".jar!");
            if (idx1 == -1) {
                idx1 = path2.lastIndexOf(".zip!");
            }
            if ((idx2 = path2.lastIndexOf(".jar!", idx1 - 1)) == -1) {
                idx2 = path2.lastIndexOf(".zip!", idx1 - 1);
            }
            if (idx2 == -1) {
                File file2 = new File(URIDecoder.decodeURIComponent(path2.substring(5, idx1 + 4), false));
                zip2 = new ZipFile(file2);
            } else {
                String s2 = path2.substring(idx2 + 6, idx1 + 4);
                File file3 = this.resolveFile(s2);
                zip2 = new ZipFile(file3);
            }
            String inJarPath = path2.substring(idx1 + 6);
            StringBuilder prefixBuilder = new StringBuilder();
            int first2 = 0;
            int len = JAR_URL_SEP.length();
            while ((second2 = inJarPath.indexOf(JAR_URL_SEP, first2)) >= 0) {
                prefixBuilder.append(inJarPath, first2, second2).append("/");
                first2 = second2 + len;
            }
            String prefix = prefixBuilder.toString();
            Enumeration<? extends ZipEntry> entries2 = zip2.entries();
            String string2 = prefixCheck = prefix.isEmpty() ? fileName : prefix + fileName;
            while (entries2.hasMoreElements()) {
                String p;
                ZipEntry entry = entries2.nextElement();
                String name2 = entry.getName();
                if (!name2.startsWith(prefixCheck)) continue;
                String string3 = p = prefix.isEmpty() ? name2 : name2.substring(prefix.length());
                if (name2.endsWith("/")) {
                    this.cache.cacheDir(p);
                    continue;
                }
                InputStream is2 = zip2.getInputStream(entry);
                Throwable throwable = null;
                try {
                    this.cache.cacheFile(p, is2, !this.enableCaching);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is2 == null) continue;
                    if (throwable != null) {
                        try {
                            is2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is2.close();
                }
            }
            this.closeQuietly(zip2);
        }
        catch (IOException e2) {
            try {
                throw new VertxException(FileSystemImpl.getFileAccessErrorMessage("unpack", url.toString()), e2);
            }
            catch (Throwable throwable) {
                this.closeQuietly(zip2);
                throw throwable;
            }
        }
        return this.cache.getFile(fileName);
    }

    private void closeQuietly(Closeable zip2) {
        if (zip2 != null) {
            try {
                zip2.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean isBundleUrlDirectory(URL url) {
        return url.toExternalForm().endsWith("/") || FileResolverImpl.getValidClassLoaderResource(this.getClassLoader(), url.getPath().substring(1) + "/") != null;
    }

    private File unpackFromBundleURL(URL url, String fileName, boolean isDir) {
        block15: {
            try {
                if (this.getClassLoader() != null && this.isBundleUrlDirectory(url) || isDir) {
                    this.cache.cacheDir(fileName);
                    break block15;
                }
                try (InputStream is2 = url.openStream();){
                    this.cache.cacheFile(fileName, is2, !this.enableCaching);
                }
            }
            catch (IOException e2) {
                throw new VertxException(FileSystemImpl.getFileAccessErrorMessage("unpack", url.toString()), e2);
            }
        }
        return this.cache.getFile(fileName);
    }

    private ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        if (cl == null) {
            cl = Object.class.getClassLoader();
        }
        return cl;
    }
}

