/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.file.impl;

import io.vertx.core.VertxException;
import io.vertx.core.file.impl.FileSystemImpl;
import io.vertx.core.impl.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import java.util.UUID;

class FileCache {
    private Thread shutdownHook;
    private File cacheDir;

    static FileCache setupCache(String fileCacheDir) {
        FileCache cache2 = new FileCache(FileCache.setupCacheDir(fileCacheDir));
        cache2.registerShutdownHook();
        return cache2;
    }

    static File setupCacheDir(String fileCacheDir) {
        if (fileCacheDir.endsWith(File.separator)) {
            fileCacheDir = fileCacheDir.substring(0, fileCacheDir.length() - File.separator.length());
        }
        String cacheDirName = fileCacheDir + "-" + UUID.randomUUID();
        File cacheDir = new File(cacheDirName);
        try {
            if (Utils.isWindows()) {
                Files.createDirectories(cacheDir.toPath(), new FileAttribute[0]);
            } else {
                Set<PosixFilePermission> perms = PosixFilePermissions.fromString("rwx------");
                Files.createDirectories(cacheDir.toPath(), PosixFilePermissions.asFileAttribute(perms));
            }
        }
        catch (IOException e2) {
            throw new IllegalStateException(FileSystemImpl.getFolderAccessErrorMessage("create", fileCacheDir), e2);
        }
        return cacheDir;
    }

    public FileCache(File cacheDir) {
        try {
            this.cacheDir = cacheDir.getCanonicalFile();
        }
        catch (IOException e2) {
            throw new VertxException("Cannot get canonical name of cacheDir", e2);
        }
    }

    synchronized void registerShutdownHook() {
        Thread shutdownHook;
        this.shutdownHook = shutdownHook = new Thread(this::runHook);
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runHook() {
        FileCache fileCache = this;
        synchronized (fileCache) {
            if (this.cacheDir == null) {
                return;
            }
        }
        Thread deleteCacheDirThread = new Thread(() -> {
            try {
                this.deleteCacheDir();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        deleteCacheDirThread.start();
        try {
            deleteCacheDirThread.join(10000L);
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
        }
    }

    String cacheDir() {
        return this.getCacheDir().getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws IOException {
        Thread hook;
        FileCache fileCache = this;
        synchronized (fileCache) {
            hook = this.shutdownHook;
            this.shutdownHook = null;
        }
        if (hook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(hook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.deleteCacheDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteCacheDir() throws IOException {
        File dir2;
        FileCache fileCache = this;
        synchronized (fileCache) {
            if (this.cacheDir == null) {
                return;
            }
            dir2 = this.cacheDir;
            this.cacheDir = null;
        }
        if (dir2.exists()) {
            FileSystemImpl.delete(dir2.toPath(), true);
        }
    }

    File getFile(String fileName) {
        return new File(this.getCacheDir(), fileName);
    }

    File getCanonicalFile(File file2) {
        try {
            if (file2.isAbsolute()) {
                return file2.getCanonicalFile();
            }
            return this.getFile(file2.getPath()).getCanonicalFile();
        }
        catch (IOException e2) {
            return null;
        }
    }

    String relativize(String fileName) {
        String cachePath = this.getCacheDir().getPath();
        if (fileName.startsWith(cachePath)) {
            int cachePathLen = cachePath.length();
            if (fileName.length() == cachePathLen) {
                return "";
            }
            if (fileName.charAt(cachePathLen) == File.separatorChar) {
                return fileName.substring(cachePathLen + 1);
            }
        }
        return null;
    }

    File cacheFile(String fileName, File resource2, boolean overwrite) throws IOException {
        File cacheFile = new File(this.getCacheDir(), fileName);
        this.fileNameCheck(cacheFile);
        boolean isDirectory = resource2.isDirectory();
        if (!isDirectory) {
            cacheFile.getParentFile().mkdirs();
            if (!overwrite) {
                try {
                    Files.copy(resource2.toPath(), cacheFile.toPath(), new CopyOption[0]);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {}
            } else {
                Files.copy(resource2.toPath(), cacheFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        } else {
            cacheFile.mkdirs();
        }
        return cacheFile;
    }

    void cacheFile(String fileName, InputStream is2, boolean overwrite) throws IOException {
        File cacheFile = new File(this.getCacheDir(), fileName);
        this.fileNameCheck(cacheFile);
        cacheFile.getParentFile().mkdirs();
        if (!overwrite) {
            try {
                Files.copy(is2, cacheFile.toPath(), new CopyOption[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {}
        } else {
            Files.copy(is2, cacheFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    void cacheDir(String fileName) throws IOException {
        File file2 = new File(this.getCacheDir(), fileName);
        this.fileNameCheck(file2);
        file2.mkdirs();
    }

    private void fileNameCheck(File file2) throws IOException {
        if (!file2.getCanonicalFile().toPath().startsWith(this.getCacheDir().toPath())) {
            throw new VertxException("File is outside of the cacheDir dir: " + file2);
        }
    }

    private File getCacheDir() {
        File currentCacheDir = this.cacheDir;
        if (currentCacheDir == null) {
            throw new IllegalStateException("cacheDir has been removed. FileResolver is closing?");
        }
        return currentCacheDir;
    }
}

