/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.file.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.file.AsyncFileLock;
import io.vertx.core.file.FileSystemException;
import io.vertx.core.impl.VertxInternal;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.util.Objects;

public class AsyncFileLockImpl
implements AsyncFileLock {
    private final VertxInternal vertx;
    private final FileLock fileLock;

    public AsyncFileLockImpl(VertxInternal vertx, FileLock fileLock) {
        this.vertx = Objects.requireNonNull(vertx, "vertx is null");
        this.fileLock = Objects.requireNonNull(fileLock, "fileLock is null");
    }

    @Override
    public long position() {
        return this.fileLock.position();
    }

    @Override
    public long size() {
        return this.fileLock.size();
    }

    @Override
    public boolean isShared() {
        return this.fileLock.isShared();
    }

    @Override
    public boolean overlaps(long position, long size) {
        return this.fileLock.overlaps(position, size);
    }

    @Override
    public boolean isValidBlocking() {
        return this.fileLock.isValid();
    }

    @Override
    public Future<Boolean> isValid() {
        return this.vertx.getOrCreateContext().executeBlockingInternal(prom -> prom.complete(this.isValidBlocking()));
    }

    @Override
    public void isValid(Handler<AsyncResult<Boolean>> handler) {
        Future<Boolean> future2 = this.isValid();
        if (handler != null) {
            future2.onComplete(handler);
        }
    }

    @Override
    public void releaseBlocking() {
        try {
            this.fileLock.release();
        }
        catch (IOException e2) {
            throw new FileSystemException(e2);
        }
    }

    @Override
    public Future<Void> release() {
        return this.vertx.getOrCreateContext().executeBlockingInternal(prom -> {
            try {
                this.fileLock.release();
                prom.complete();
            }
            catch (IOException e2) {
                prom.fail(new FileSystemException(e2));
            }
        });
    }

    @Override
    public void release(Handler<AsyncResult<Void>> handler) {
        Future<Void> future2 = this.release();
        if (handler != null) {
            future2.onComplete(handler);
        }
    }
}

