/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl.codecs;

import io.netty.util.CharsetUtil;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.impl.CodecManager;
import io.vertx.core.impl.ClusterSerializableUtils;
import io.vertx.core.shareddata.impl.ClusterSerializable;

public class ClusterSerializableCodec
implements MessageCodec<ClusterSerializable, ClusterSerializable> {
    private final CodecManager codecManager;

    public ClusterSerializableCodec(CodecManager codecManager) {
        this.codecManager = codecManager;
    }

    @Override
    public void encodeToWire(Buffer buffer, ClusterSerializable obj2) {
        byte[] classNameBytes = obj2.getClass().getName().getBytes(CharsetUtil.UTF_8);
        buffer.appendInt(classNameBytes.length).appendBytes(classNameBytes);
        obj2.writeToBuffer(buffer);
    }

    @Override
    public ClusterSerializable decodeFromWire(int pos, Buffer buffer) {
        ClusterSerializable clusterSerializable;
        int len;
        byte[] classNameBytes;
        String className;
        if (!this.codecManager.acceptClusterSerializable(className = new String(classNameBytes = buffer.getBytes(pos += 4, pos + (len = buffer.getInt(pos))), CharsetUtil.UTF_8))) {
            throw new RuntimeException("Class not allowed: " + className);
        }
        pos += len;
        try {
            Class<?> clazz = ClusterSerializableCodec.getClassLoader().loadClass(className);
            clusterSerializable = (ClusterSerializable)clazz.newInstance();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        clusterSerializable.readFromBuffer(pos, buffer);
        return clusterSerializable;
    }

    private static ClassLoader getClassLoader() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        return tccl != null ? tccl : ClusterSerializableCodec.class.getClassLoader();
    }

    @Override
    public ClusterSerializable transform(ClusterSerializable obj2) {
        return ClusterSerializableUtils.copy(obj2);
    }

    @Override
    public String name() {
        return "clusterserializable";
    }

    @Override
    public byte systemCodecID() {
        return 16;
    }
}

