/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.eventbus.DeliveryContext;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.eventbus.MessageProducer;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.eventbus.impl.CodecManager;
import io.vertx.core.eventbus.impl.EventBusInternal;
import io.vertx.core.eventbus.impl.HandlerHolder;
import io.vertx.core.eventbus.impl.HandlerRegistration;
import io.vertx.core.eventbus.impl.MessageConsumerImpl;
import io.vertx.core.eventbus.impl.MessageImpl;
import io.vertx.core.eventbus.impl.MessageProducerImpl;
import io.vertx.core.eventbus.impl.OutboundDeliveryContext;
import io.vertx.core.eventbus.impl.ReplyHandler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.utils.ConcurrentCyclicSequence;
import io.vertx.core.spi.metrics.EventBusMetrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.VertxMetrics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;

public class EventBusImpl
implements EventBusInternal,
MetricsProvider {
    private static final AtomicReferenceFieldUpdater<EventBusImpl, Handler[]> OUTBOUND_INTERCEPTORS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(EventBusImpl.class, Handler[].class, "outboundInterceptors");
    private static final AtomicReferenceFieldUpdater<EventBusImpl, Handler[]> INBOUND_INTERCEPTORS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(EventBusImpl.class, Handler[].class, "inboundInterceptors");
    private volatile Handler<DeliveryContext>[] outboundInterceptors = new Handler[0];
    private volatile Handler<DeliveryContext>[] inboundInterceptors = new Handler[0];
    private final AtomicLong replySequence = new AtomicLong(0L);
    protected final VertxInternal vertx;
    protected final EventBusMetrics metrics;
    protected final ConcurrentMap<String, ConcurrentCyclicSequence<HandlerHolder>> handlerMap = new ConcurrentHashMap<String, ConcurrentCyclicSequence<HandlerHolder>>();
    protected final CodecManager codecManager = new CodecManager();
    protected volatile boolean started;

    public EventBusImpl(VertxInternal vertx) {
        VertxMetrics metrics = vertx.metricsSPI();
        this.vertx = vertx;
        this.metrics = metrics != null ? metrics.createEventBusMetrics() : null;
    }

    @Override
    public <T> EventBus addOutboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.addInterceptor(OUTBOUND_INTERCEPTORS_UPDATER, Objects.requireNonNull(interceptor));
        return this;
    }

    @Override
    public <T> EventBus addInboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.addInterceptor(INBOUND_INTERCEPTORS_UPDATER, Objects.requireNonNull(interceptor));
        return this;
    }

    @Override
    public <T> EventBus removeOutboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.removeInterceptor(OUTBOUND_INTERCEPTORS_UPDATER, Objects.requireNonNull(interceptor));
        return this;
    }

    @Override
    public <T> EventBus removeInboundInterceptor(Handler<DeliveryContext<T>> interceptor) {
        this.removeInterceptor(INBOUND_INTERCEPTORS_UPDATER, Objects.requireNonNull(interceptor));
        return this;
    }

    Handler<DeliveryContext>[] inboundInterceptors() {
        return this.inboundInterceptors;
    }

    Handler<DeliveryContext>[] outboundInterceptors() {
        return this.outboundInterceptors;
    }

    @Override
    public EventBus clusterSerializableChecker(Function<String, Boolean> classNamePredicate) {
        this.codecManager.clusterSerializableCheck(classNamePredicate);
        return this;
    }

    @Override
    public EventBus serializableChecker(Function<String, Boolean> classNamePredicate) {
        this.codecManager.serializableCheck(classNamePredicate);
        return this;
    }

    @Override
    public synchronized void start(Promise<Void> promise2) {
        if (this.started) {
            throw new IllegalStateException("Already started");
        }
        this.started = true;
        promise2.complete();
    }

    @Override
    public EventBus send(String address, Object message) {
        return this.send(address, message, new DeliveryOptions());
    }

    @Override
    public EventBus send(String address, Object message, DeliveryOptions options2) {
        MessageImpl msg = this.createMessage(true, address, options2.getHeaders(), message, options2.getCodecName());
        this.sendOrPubInternal(msg, options2, null, null);
        return this;
    }

    @Override
    public <T> Future<Message<T>> request(String address, Object message, DeliveryOptions options2) {
        MessageImpl msg = this.createMessage(true, address, options2.getHeaders(), message, options2.getCodecName());
        ReplyHandler<T> handler = this.createReplyHandler(msg, true, options2);
        this.sendOrPubInternal(msg, options2, handler, null);
        return handler.result();
    }

    @Override
    public <T> MessageProducer<T> sender(String address) {
        Objects.requireNonNull(address, "address");
        return new MessageProducerImpl(this.vertx, address, true, new DeliveryOptions());
    }

    @Override
    public <T> MessageProducer<T> sender(String address, DeliveryOptions options2) {
        Objects.requireNonNull(address, "address");
        Objects.requireNonNull(options2, "options");
        return new MessageProducerImpl(this.vertx, address, true, options2);
    }

    @Override
    public <T> MessageProducer<T> publisher(String address) {
        Objects.requireNonNull(address, "address");
        return new MessageProducerImpl(this.vertx, address, false, new DeliveryOptions());
    }

    @Override
    public <T> MessageProducer<T> publisher(String address, DeliveryOptions options2) {
        Objects.requireNonNull(address, "address");
        Objects.requireNonNull(options2, "options");
        return new MessageProducerImpl(this.vertx, address, false, options2);
    }

    @Override
    public EventBus publish(String address, Object message) {
        return this.publish(address, message, new DeliveryOptions());
    }

    @Override
    public EventBus publish(String address, Object message, DeliveryOptions options2) {
        this.sendOrPubInternal(this.createMessage(false, address, options2.getHeaders(), message, options2.getCodecName()), options2, null, null);
        return this;
    }

    @Override
    public <T> MessageConsumer<T> consumer(String address) {
        this.checkStarted();
        Objects.requireNonNull(address, "address");
        return new MessageConsumerImpl(this.vertx, this.vertx.getOrCreateContext(), this, address, false);
    }

    @Override
    public <T> MessageConsumer<T> consumer(String address, Handler<Message<T>> handler) {
        Objects.requireNonNull(handler, "handler");
        MessageConsumer<T> consumer = this.consumer(address);
        consumer.handler((Handler)handler);
        return consumer;
    }

    @Override
    public <T> MessageConsumer<T> localConsumer(String address) {
        this.checkStarted();
        Objects.requireNonNull(address, "address");
        return new MessageConsumerImpl(this.vertx, this.vertx.getOrCreateContext(), this, address, true);
    }

    @Override
    public <T> MessageConsumer<T> localConsumer(String address, Handler<Message<T>> handler) {
        Objects.requireNonNull(handler, "handler");
        MessageConsumer<T> consumer = this.localConsumer(address);
        consumer.handler((Handler)handler);
        return consumer;
    }

    @Override
    public EventBus registerCodec(MessageCodec codec) {
        this.codecManager.registerCodec(codec);
        return this;
    }

    @Override
    public EventBus unregisterCodec(String name2) {
        this.codecManager.unregisterCodec(name2);
        return this;
    }

    @Override
    public <T> EventBus registerDefaultCodec(Class<T> clazz, MessageCodec<T, ?> codec) {
        this.codecManager.registerDefaultCodec(clazz, codec);
        return this;
    }

    @Override
    public EventBus unregisterDefaultCodec(Class clazz) {
        this.codecManager.unregisterDefaultCodec(clazz);
        return this;
    }

    @Override
    public EventBus codecSelector(Function<Object, String> selector) {
        this.codecManager.codecSelector(selector);
        return this;
    }

    @Override
    public void close(Promise<Void> promise2) {
        if (!this.started) {
            promise2.complete();
            return;
        }
        this.unregisterAll().onComplete(ar -> {
            if (this.metrics != null) {
                this.metrics.close();
            }
            promise2.handle((AsyncResult<Void>)ar);
        });
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null;
    }

    @Override
    public EventBusMetrics<?> getMetrics() {
        return this.metrics;
    }

    public MessageImpl createMessage(boolean send2, String address, MultiMap headers, Object body, String codecName) {
        Objects.requireNonNull(address, "no null address accepted");
        MessageCodec codec = this.codecManager.lookupCodec(body, codecName, true);
        MessageImpl msg = new MessageImpl(address, headers, body, codec, send2, this);
        return msg;
    }

    protected <T> HandlerHolder<T> addRegistration(String address, HandlerRegistration<T> registration, boolean replyHandler, boolean localOnly, Promise<Void> promise2) {
        HandlerHolder<T> holder = this.addLocalRegistration(address, registration, replyHandler, localOnly);
        this.onLocalRegistration(holder, promise2);
        return holder;
    }

    protected <T> void onLocalRegistration(HandlerHolder<T> handlerHolder, Promise<Void> promise2) {
        if (promise2 != null) {
            promise2.complete();
        }
    }

    private <T> HandlerHolder<T> addLocalRegistration(String address, HandlerRegistration<T> registration, boolean replyHandler, boolean localOnly) {
        Objects.requireNonNull(address, "address");
        ContextInternal context = registration.context;
        HandlerHolder<T> holder = this.createHandlerHolder(registration, replyHandler, localOnly, context);
        ConcurrentCyclicSequence<HandlerHolder<T>> handlers = new ConcurrentCyclicSequence<HandlerHolder<T>>().add(holder);
        ConcurrentCyclicSequence actualHandlers = this.handlerMap.merge(address, handlers, (old, prev2) -> old.add(prev2.first()));
        if (context.isDeployment()) {
            context.addCloseHook(registration);
        }
        return holder;
    }

    protected <T> HandlerHolder<T> createHandlerHolder(HandlerRegistration<T> registration, boolean replyHandler, boolean localOnly, ContextInternal context) {
        return new HandlerHolder<T>(registration, replyHandler, localOnly, context);
    }

    protected <T> void removeRegistration(HandlerHolder<T> handlerHolder, Promise<Void> promise2) {
        this.removeLocalRegistration(handlerHolder);
        this.onLocalUnregistration(handlerHolder, promise2);
    }

    protected <T> void onLocalUnregistration(HandlerHolder<T> handlerHolder, Promise<Void> promise2) {
        promise2.complete();
    }

    private <T> void removeLocalRegistration(HandlerHolder<T> holder) {
        String address = holder.getHandler().address;
        this.handlerMap.compute(address, (key2, val2) -> {
            if (val2 == null) {
                return null;
            }
            ConcurrentCyclicSequence<HandlerHolder> next2 = val2.remove(holder);
            return next2.size() == 0 ? null : next2;
        });
        if (holder.setRemoved() && holder.getContext().deploymentID() != null) {
            holder.getContext().removeCloseHook(holder.getHandler());
        }
    }

    protected <T> void sendReply(MessageImpl replyMessage, DeliveryOptions options2, ReplyHandler<T> replyHandler) {
        if (replyMessage.address() == null) {
            throw new IllegalStateException("address not specified");
        }
        this.sendOrPubInternal(new OutboundDeliveryContext<T>(this.vertx.getOrCreateContext(), replyMessage, options2, replyHandler, null));
    }

    protected <T> void sendOrPub(OutboundDeliveryContext<T> sendContext) {
        this.sendLocally(sendContext);
    }

    protected void callCompletionHandlerAsync(Handler<AsyncResult<Void>> completionHandler) {
        if (completionHandler != null) {
            this.vertx.runOnContext(v -> completionHandler.handle(Future.succeededFuture()));
        }
    }

    private <T> void sendLocally(OutboundDeliveryContext<T> sendContext) {
        ReplyException failure = this.deliverMessageLocally(sendContext.message);
        if (failure != null) {
            sendContext.written(failure);
        } else {
            sendContext.written(null);
        }
    }

    protected boolean isMessageLocal(MessageImpl msg) {
        return true;
    }

    protected ReplyException deliverMessageLocally(MessageImpl msg) {
        ConcurrentCyclicSequence handlers = (ConcurrentCyclicSequence)this.handlerMap.get(msg.address());
        boolean messageLocal = this.isMessageLocal(msg);
        if (handlers != null) {
            if (msg.isSend()) {
                HandlerHolder holder = this.nextHandler(handlers, messageLocal);
                if (this.metrics != null) {
                    this.metrics.messageReceived(msg.address(), !msg.isSend(), messageLocal, holder != null ? 1 : 0);
                }
                if (holder != null) {
                    holder.handler.receive(msg.copyBeforeReceive());
                }
            } else {
                if (this.metrics != null) {
                    this.metrics.messageReceived(msg.address(), !msg.isSend(), messageLocal, handlers.size());
                }
                for (HandlerHolder holder : handlers) {
                    if (!messageLocal && holder.isLocalOnly()) continue;
                    holder.handler.receive(msg.copyBeforeReceive());
                }
            }
            return null;
        }
        if (this.metrics != null) {
            this.metrics.messageReceived(msg.address(), !msg.isSend(), messageLocal, 0);
        }
        return new ReplyException(ReplyFailure.NO_HANDLERS, "No handlers for address " + msg.address);
    }

    protected HandlerHolder nextHandler(ConcurrentCyclicSequence<HandlerHolder> handlers, boolean messageLocal) {
        return handlers.next();
    }

    protected void checkStarted() {
        if (!this.started) {
            throw new IllegalStateException("Event Bus is not started");
        }
    }

    protected String generateReplyAddress() {
        return "__vertx.reply." + Long.toString(this.replySequence.incrementAndGet());
    }

    <T> ReplyHandler<T> createReplyHandler(MessageImpl message, boolean src, DeliveryOptions options2) {
        long timeout = options2.getSendTimeout();
        String replyAddress = this.generateReplyAddress();
        message.setReplyAddress(replyAddress);
        ReplyHandler handler = new ReplyHandler(this, this.vertx.getOrCreateContext(), replyAddress, message.address, src, timeout);
        handler.register();
        return handler;
    }

    public <T> OutboundDeliveryContext<T> newSendContext(MessageImpl message, DeliveryOptions options2, ReplyHandler<T> handler, Promise<Void> writePromise) {
        return new OutboundDeliveryContext<T>(this.vertx.getOrCreateContext(), message, options2, handler, writePromise);
    }

    public <T> void sendOrPubInternal(OutboundDeliveryContext<T> senderCtx) {
        this.checkStarted();
        senderCtx.bus = this;
        senderCtx.metrics = this.metrics;
        senderCtx.next();
    }

    public <T> void sendOrPubInternal(MessageImpl message, DeliveryOptions options2, ReplyHandler<T> handler, Promise<Void> writePromise) {
        this.checkStarted();
        this.sendOrPubInternal(this.newSendContext(message, options2, handler, writePromise));
    }

    private Future<Void> unregisterAll() {
        ArrayList<Future> futures = new ArrayList<Future>();
        for (ConcurrentCyclicSequence handlers : this.handlerMap.values()) {
            for (HandlerHolder holder : handlers) {
                futures.add(holder.getHandler().unregister());
            }
        }
        return CompositeFuture.join(futures).mapEmpty();
    }

    private void addInterceptor(AtomicReferenceFieldUpdater<EventBusImpl, Handler[]> updater, Handler interceptor) {
        Handler[] copy2;
        Handler[] interceptors;
        do {
            interceptors = updater.get(this);
            copy2 = Arrays.copyOf(interceptors, interceptors.length + 1);
            copy2[interceptors.length] = interceptor;
        } while (!updater.compareAndSet(this, interceptors, copy2));
    }

    private void removeInterceptor(AtomicReferenceFieldUpdater<EventBusImpl, Handler[]> updater, Handler interceptor) {
        Handler[] copy2;
        Handler[] interceptors;
        do {
            interceptors = updater.get(this);
            int idx = -1;
            for (int i = 0; i < interceptors.length; ++i) {
                if (!interceptors[i].equals(interceptor)) continue;
                idx = i;
                break;
            }
            if (idx == -1) {
                return;
            }
            copy2 = new Handler[interceptors.length - 1];
            System.arraycopy(interceptors, 0, copy2, 0, idx);
            System.arraycopy(interceptors, idx + 1, copy2, idx, copy2.length - idx);
        } while (!updater.compareAndSet(this, interceptors, copy2));
    }
}

