/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;

@VertxGen
public interface Message<T> {
    public String address();

    public MultiMap headers();

    @CacheReturn
    public T body();

    public @Nullable String replyAddress();

    public boolean isSend();

    default public void reply(@Nullable Object message) {
        this.reply(message, new DeliveryOptions());
    }

    public void reply(@Nullable Object var1, DeliveryOptions var2);

    default public <R> void replyAndRequest(@Nullable Object message, Handler<AsyncResult<Message<R>>> replyHandler) {
        this.replyAndRequest(message, new DeliveryOptions(), replyHandler);
    }

    default public <R> Future<Message<R>> replyAndRequest(@Nullable Object message) {
        return this.replyAndRequest(message, new DeliveryOptions());
    }

    default public <R> void replyAndRequest(@Nullable Object message, DeliveryOptions options2, Handler<AsyncResult<Message<R>>> replyHandler) {
        this.replyAndRequest(message, options2).onComplete(replyHandler);
    }

    public <R> Future<Message<R>> replyAndRequest(@Nullable Object var1, DeliveryOptions var2);

    default public void fail(int failureCode, String message) {
        this.reply(new ReplyException(ReplyFailure.RECIPIENT_FAILURE, failureCode, message));
    }
}

