/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus;

import io.netty.handler.logging.ByteBufFormat;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBusOptions;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import java.util.Base64;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class EventBusOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, EventBusOptions obj2) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "acceptBacklog": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setAcceptBacklog(((Number)member.getValue()).intValue());
                    break;
                }
                case "activityLogDataFormat": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setActivityLogDataFormat(ByteBufFormat.valueOf((String)member.getValue()));
                    break;
                }
                case "clientAuth": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setClientAuth(ClientAuth.valueOf((String)member.getValue()));
                    break;
                }
                case "clusterNodeMetadata": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setClusterNodeMetadata(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "clusterPingInterval": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setClusterPingInterval(((Number)member.getValue()).longValue());
                    break;
                }
                case "clusterPingReplyInterval": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setClusterPingReplyInterval(((Number)member.getValue()).longValue());
                    break;
                }
                case "clusterPublicHost": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setClusterPublicHost((String)member.getValue());
                    break;
                }
                case "clusterPublicPort": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setClusterPublicPort(((Number)member.getValue()).intValue());
                    break;
                }
                case "connectTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setConnectTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "crlPaths": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj2.addCrlPath((String)item);
                        }
                    });
                    break;
                }
                case "crlValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj2.addCrlValue(Buffer.buffer(BASE64_DECODER.decode((String)item)));
                        }
                    });
                    break;
                }
                case "enabledCipherSuites": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj2.addEnabledCipherSuite((String)item);
                        }
                    });
                    break;
                }
                case "enabledSecureTransportProtocols": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj2.setEnabledSecureTransportProtocols((Set)list);
                    break;
                }
                case "host": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setHost((String)member.getValue());
                    break;
                }
                case "idleTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setIdleTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "idleTimeoutUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setIdleTimeoutUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "jdkSslEngineOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setJdkSslEngineOptions(new JdkSSLEngineOptions((JsonObject)member.getValue()));
                    break;
                }
                case "keyStoreOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setKeyStoreOptions(new JksOptions((JsonObject)member.getValue()));
                    break;
                }
                case "logActivity": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setLogActivity((Boolean)member.getValue());
                    break;
                }
                case "openSslEngineOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setOpenSslEngineOptions(new OpenSSLEngineOptions((JsonObject)member.getValue()));
                    break;
                }
                case "pemKeyCertOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setPemKeyCertOptions(new PemKeyCertOptions((JsonObject)member.getValue()));
                    break;
                }
                case "pemTrustOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setPemTrustOptions(new PemTrustOptions((JsonObject)member.getValue()));
                    break;
                }
                case "pfxKeyCertOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setPfxKeyCertOptions(new PfxOptions((JsonObject)member.getValue()));
                    break;
                }
                case "pfxTrustOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setPfxTrustOptions(new PfxOptions((JsonObject)member.getValue()));
                    break;
                }
                case "port": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setPort(((Number)member.getValue()).intValue());
                    break;
                }
                case "readIdleTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setReadIdleTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "receiveBufferSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setReceiveBufferSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "reconnectAttempts": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setReconnectAttempts(((Number)member.getValue()).intValue());
                    break;
                }
                case "reconnectInterval": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setReconnectInterval(((Number)member.getValue()).longValue());
                    break;
                }
                case "reuseAddress": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setReuseAddress((Boolean)member.getValue());
                    break;
                }
                case "reusePort": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setReusePort((Boolean)member.getValue());
                    break;
                }
                case "sendBufferSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setSendBufferSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "soLinger": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setSoLinger(((Number)member.getValue()).intValue());
                    break;
                }
                case "ssl": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setSsl((Boolean)member.getValue());
                    break;
                }
                case "sslHandshakeTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setSslHandshakeTimeout(((Number)member.getValue()).longValue());
                    break;
                }
                case "sslHandshakeTimeoutUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setSslHandshakeTimeoutUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "tcpCork": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setTcpCork((Boolean)member.getValue());
                    break;
                }
                case "tcpFastOpen": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setTcpFastOpen((Boolean)member.getValue());
                    break;
                }
                case "tcpKeepAlive": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setTcpKeepAlive((Boolean)member.getValue());
                    break;
                }
                case "tcpNoDelay": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setTcpNoDelay((Boolean)member.getValue());
                    break;
                }
                case "tcpQuickAck": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setTcpQuickAck((Boolean)member.getValue());
                    break;
                }
                case "tcpUserTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setTcpUserTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "trafficClass": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setTrafficClass(((Number)member.getValue()).intValue());
                    break;
                }
                case "trustAll": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setTrustAll((Boolean)member.getValue());
                    break;
                }
                case "trustStoreOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setTrustStoreOptions(new JksOptions((JsonObject)member.getValue()));
                    break;
                }
                case "useAlpn": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setUseAlpn((Boolean)member.getValue());
                    break;
                }
                case "writeIdleTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setWriteIdleTimeout(((Number)member.getValue()).intValue());
                }
            }
        }
    }

    static void toJson(EventBusOptions obj2, JsonObject json) {
        EventBusOptionsConverter.toJson(obj2, json.getMap());
    }

    static void toJson(EventBusOptions obj2, Map<String, Object> json) {
        JsonArray array2;
        json.put("acceptBacklog", obj2.getAcceptBacklog());
        if (obj2.getActivityLogDataFormat() != null) {
            json.put("activityLogDataFormat", obj2.getActivityLogDataFormat().name());
        }
        if (obj2.getClientAuth() != null) {
            json.put("clientAuth", obj2.getClientAuth().name());
        }
        if (obj2.getClusterNodeMetadata() != null) {
            json.put("clusterNodeMetadata", obj2.getClusterNodeMetadata());
        }
        json.put("clusterPingInterval", obj2.getClusterPingInterval());
        json.put("clusterPingReplyInterval", obj2.getClusterPingReplyInterval());
        if (obj2.getClusterPublicHost() != null) {
            json.put("clusterPublicHost", obj2.getClusterPublicHost());
        }
        json.put("clusterPublicPort", obj2.getClusterPublicPort());
        json.put("connectTimeout", obj2.getConnectTimeout());
        if (obj2.getCrlPaths() != null) {
            array2 = new JsonArray();
            obj2.getCrlPaths().forEach(item -> array2.add(item));
            json.put("crlPaths", array2);
        }
        if (obj2.getCrlValues() != null) {
            array2 = new JsonArray();
            obj2.getCrlValues().forEach(item -> array2.add(BASE64_ENCODER.encodeToString(item.getBytes())));
            json.put("crlValues", array2);
        }
        if (obj2.getEnabledCipherSuites() != null) {
            array2 = new JsonArray();
            obj2.getEnabledCipherSuites().forEach(item -> array2.add(item));
            json.put("enabledCipherSuites", array2);
        }
        if (obj2.getEnabledSecureTransportProtocols() != null) {
            array2 = new JsonArray();
            obj2.getEnabledSecureTransportProtocols().forEach(item -> array2.add(item));
            json.put("enabledSecureTransportProtocols", array2);
        }
        if (obj2.getHost() != null) {
            json.put("host", obj2.getHost());
        }
        json.put("idleTimeout", obj2.getIdleTimeout());
        if (obj2.getIdleTimeoutUnit() != null) {
            json.put("idleTimeoutUnit", obj2.getIdleTimeoutUnit().name());
        }
        if (obj2.getJdkSslEngineOptions() != null) {
            json.put("jdkSslEngineOptions", obj2.getJdkSslEngineOptions().toJson());
        }
        if (obj2.getKeyStoreOptions() != null) {
            json.put("keyStoreOptions", obj2.getKeyStoreOptions().toJson());
        }
        json.put("logActivity", obj2.getLogActivity());
        if (obj2.getOpenSslEngineOptions() != null) {
            json.put("openSslEngineOptions", obj2.getOpenSslEngineOptions().toJson());
        }
        if (obj2.getPemKeyCertOptions() != null) {
            json.put("pemKeyCertOptions", obj2.getPemKeyCertOptions().toJson());
        }
        if (obj2.getPemTrustOptions() != null) {
            json.put("pemTrustOptions", obj2.getPemTrustOptions().toJson());
        }
        if (obj2.getPfxKeyCertOptions() != null) {
            json.put("pfxKeyCertOptions", obj2.getPfxKeyCertOptions().toJson());
        }
        if (obj2.getPfxTrustOptions() != null) {
            json.put("pfxTrustOptions", obj2.getPfxTrustOptions().toJson());
        }
        json.put("port", obj2.getPort());
        json.put("readIdleTimeout", obj2.getReadIdleTimeout());
        json.put("receiveBufferSize", obj2.getReceiveBufferSize());
        json.put("reconnectAttempts", obj2.getReconnectAttempts());
        json.put("reconnectInterval", obj2.getReconnectInterval());
        json.put("reuseAddress", obj2.isReuseAddress());
        json.put("reusePort", obj2.isReusePort());
        json.put("sendBufferSize", obj2.getSendBufferSize());
        json.put("soLinger", obj2.getSoLinger());
        json.put("ssl", obj2.isSsl());
        json.put("sslHandshakeTimeout", obj2.getSslHandshakeTimeout());
        if (obj2.getSslHandshakeTimeoutUnit() != null) {
            json.put("sslHandshakeTimeoutUnit", obj2.getSslHandshakeTimeoutUnit().name());
        }
        json.put("tcpCork", obj2.isTcpCork());
        json.put("tcpFastOpen", obj2.isTcpFastOpen());
        json.put("tcpKeepAlive", obj2.isTcpKeepAlive());
        json.put("tcpNoDelay", obj2.isTcpNoDelay());
        json.put("tcpQuickAck", obj2.isTcpQuickAck());
        json.put("tcpUserTimeout", obj2.getTcpUserTimeout());
        json.put("trafficClass", obj2.getTrafficClass());
        json.put("trustAll", obj2.isTrustAll());
        if (obj2.getTrustStoreOptions() != null) {
            json.put("trustStoreOptions", obj2.getTrustStoreOptions().toJson());
        }
        json.put("useAlpn", obj2.isUseAlpn());
        json.put("writeIdleTimeout", obj2.getWriteIdleTimeout());
    }
}

