/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.dns.impl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.MaxMessagesRecvByteBufAllocator;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.handler.codec.dns.DatagramDnsQuery;
import io.netty.handler.codec.dns.DatagramDnsQueryEncoder;
import io.netty.handler.codec.dns.DatagramDnsResponseDecoder;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.collection.LongObjectHashMap;
import io.netty.util.collection.LongObjectMap;
import io.netty.util.concurrent.Promise;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.impl.PartialPooledByteBufAllocator;
import io.vertx.core.dns.DnsClient;
import io.vertx.core.dns.DnsClientOptions;
import io.vertx.core.dns.DnsException;
import io.vertx.core.dns.DnsResponseCode;
import io.vertx.core.dns.MxRecord;
import io.vertx.core.dns.SrvRecord;
import io.vertx.core.dns.impl.MxRecordImpl;
import io.vertx.core.dns.impl.SrvRecordImpl;
import io.vertx.core.dns.impl.decoder.RecordDecoder;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.spi.transport.Transport;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;

public final class DnsClientImpl
implements DnsClient {
    private static final char[] HEX_TABLE = "0123456789abcdef".toCharArray();
    private final VertxInternal vertx;
    private final LongObjectMap<Query> inProgressMap = new LongObjectHashMap<Query>();
    private final InetSocketAddress dnsServer;
    private final ContextInternal actualCtx;
    private final DatagramChannel channel;
    private final DnsClientOptions options;

    public DnsClientImpl(VertxInternal vertx, DnsClientOptions options2) {
        Objects.requireNonNull(options2, "no null options accepted");
        Objects.requireNonNull(options2.getHost(), "no null host accepted");
        this.options = new DnsClientOptions(options2);
        ContextInternal creatingContext = vertx.getContext();
        this.dnsServer = new InetSocketAddress(options2.getHost(), options2.getPort());
        if (this.dnsServer.isUnresolved()) {
            throw new IllegalArgumentException("Cannot resolve the host to a valid ip address");
        }
        this.vertx = vertx;
        Transport transport = vertx.transport();
        this.actualCtx = vertx.getOrCreateContext();
        this.channel = transport.datagramChannel(this.dnsServer.getAddress() instanceof Inet4Address ? InternetProtocolFamily.IPv4 : InternetProtocolFamily.IPv6);
        this.channel.config().setOption(ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION, true);
        MaxMessagesRecvByteBufAllocator bufAllocator = (MaxMessagesRecvByteBufAllocator)this.channel.config().getRecvByteBufAllocator();
        bufAllocator.maxMessagesPerRead(1);
        this.channel.config().setAllocator(PartialPooledByteBufAllocator.INSTANCE);
        this.actualCtx.nettyEventLoop().register(this.channel);
        if (options2.getLogActivity()) {
            this.channel.pipeline().addLast("logging", (ChannelHandler)new LoggingHandler(options2.getActivityLogFormat()));
        }
        this.channel.pipeline().addLast(new DatagramDnsQueryEncoder());
        this.channel.pipeline().addLast(new DatagramDnsResponseDecoder());
        this.channel.pipeline().addLast(new SimpleChannelInboundHandler<DnsResponse>(){

            @Override
            protected void channelRead0(ChannelHandlerContext ctx, DnsResponse msg) throws Exception {
                DefaultDnsQuestion question = (DefaultDnsQuestion)msg.recordAt(DnsSection.QUESTION);
                Query query = (Query)DnsClientImpl.this.inProgressMap.get(DnsClientImpl.this.dnsMessageId(msg.id(), question.name()));
                if (query != null) {
                    query.handle(msg);
                }
            }
        });
    }

    @Override
    public DnsClient lookup4(String name2, Handler<AsyncResult<String>> handler) {
        this.lookup4(name2).onComplete(handler);
        return this;
    }

    @Override
    public Future<@Nullable String> lookup4(String name2) {
        return this.lookupSingle(name2, DnsRecordType.A);
    }

    @Override
    public DnsClient lookup6(String name2, Handler<AsyncResult<String>> handler) {
        this.lookup6(name2).onComplete(handler);
        return this;
    }

    @Override
    public Future<@Nullable String> lookup6(String name2) {
        return this.lookupSingle(name2, DnsRecordType.AAAA);
    }

    @Override
    public DnsClient lookup(String name2, Handler<AsyncResult<String>> handler) {
        this.lookup(name2).onComplete(handler);
        return this;
    }

    @Override
    public Future<@Nullable String> lookup(String name2) {
        return this.lookupSingle(name2, DnsRecordType.A, DnsRecordType.AAAA);
    }

    @Override
    public DnsClient resolveA(String name2, Handler<AsyncResult<List<String>>> handler) {
        this.resolveA(name2).onComplete(handler);
        return this;
    }

    @Override
    public Future<List<String>> resolveA(String name2) {
        return this.lookupList(name2, DnsRecordType.A);
    }

    @Override
    public DnsClient resolveCNAME(String name2, Handler<AsyncResult<List<String>>> handler) {
        this.resolveCNAME(name2).onComplete(handler);
        return this;
    }

    @Override
    public Future<List<String>> resolveCNAME(String name2) {
        return this.lookupList(name2, DnsRecordType.CNAME);
    }

    @Override
    public DnsClient resolveMX(String name2, Handler<AsyncResult<List<MxRecord>>> handler) {
        this.resolveMX(name2).onComplete(handler);
        return this;
    }

    @Override
    public Future<List<MxRecord>> resolveMX(String name2) {
        return this.lookupList(name2, DnsRecordType.MX);
    }

    @Override
    public Future<List<String>> resolveTXT(String name2) {
        return this.lookupList(name2, DnsRecordType.TXT).map(records -> {
            ArrayList txts = new ArrayList();
            for (List txt : records) {
                txts.addAll(txt);
            }
            return txts;
        });
    }

    @Override
    public DnsClient resolveTXT(String name2, Handler<AsyncResult<List<String>>> handler) {
        this.resolveTXT(name2).onComplete(handler);
        return this;
    }

    @Override
    public Future<@Nullable String> resolvePTR(String name2) {
        return this.lookupSingle(name2, DnsRecordType.PTR);
    }

    @Override
    public DnsClient resolvePTR(String name2, Handler<AsyncResult<String>> handler) {
        this.resolvePTR(name2).onComplete(handler);
        return this;
    }

    @Override
    public DnsClient resolveAAAA(String name2, Handler<AsyncResult<List<String>>> handler) {
        this.resolveAAAA(name2).onComplete(handler);
        return this;
    }

    @Override
    public Future<List<String>> resolveAAAA(String name2) {
        return this.lookupList(name2, DnsRecordType.AAAA);
    }

    @Override
    public Future<List<String>> resolveNS(String name2) {
        return this.lookupList(name2, DnsRecordType.NS);
    }

    @Override
    public DnsClient resolveNS(String name2, Handler<AsyncResult<List<String>>> handler) {
        this.resolveNS(name2).onComplete(handler);
        return this;
    }

    @Override
    public Future<List<SrvRecord>> resolveSRV(String name2) {
        return this.lookupList(name2, DnsRecordType.SRV);
    }

    @Override
    public DnsClient resolveSRV(String name2, Handler<AsyncResult<List<SrvRecord>>> handler) {
        this.resolveSRV(name2).onComplete(handler);
        return this;
    }

    @Override
    public Future<@Nullable String> reverseLookup(String address) {
        try {
            InetAddress inetAddress = InetAddress.getByName(address);
            byte[] addr = inetAddress.getAddress();
            StringBuilder reverseName = new StringBuilder(64);
            if (inetAddress instanceof Inet4Address) {
                reverseName.append(addr[3] & 0xFF).append(".").append(addr[2] & 0xFF).append(".").append(addr[1] & 0xFF).append(".").append(addr[0] & 0xFF);
            } else {
                for (int i = 0; i < 16; ++i) {
                    reverseName.append(HEX_TABLE[addr[15 - i] & 0xF]);
                    reverseName.append(".");
                    reverseName.append(HEX_TABLE[addr[15 - i] >> 4 & 0xF]);
                    if (i == 15) continue;
                    reverseName.append(".");
                }
            }
            reverseName.append(".in-addr.arpa");
            return this.resolvePTR(reverseName.toString());
        }
        catch (UnknownHostException e2) {
            return Future.failedFuture(e2);
        }
    }

    @Override
    public DnsClient reverseLookup(String address, Handler<AsyncResult<String>> handler) {
        this.reverseLookup(address).onComplete(handler);
        return this;
    }

    private <T> Future<T> lookupSingle(String name2, DnsRecordType ... types) {
        return this.lookupList(name2, types).map(result2 -> result2.isEmpty() ? null : result2.get(0));
    }

    private <T> Future<List<T>> lookupList(String name2, DnsRecordType ... types) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        PromiseInternal promise2 = ctx.promise();
        Objects.requireNonNull(name2, "no null name accepted");
        EventLoop el = this.actualCtx.nettyEventLoop();
        Query query = new Query(name2, types);
        query.promise.addListener(promise2);
        if (el.inEventLoop()) {
            query.run();
        } else {
            el.execute(query::run);
        }
        return promise2.future();
    }

    private long dnsMessageId(int id, String query) {
        return ((long)query.hashCode() << 16) + (long)(id & 0xFFFF);
    }

    public void inProgressQueries(Handler<Integer> handler) {
        this.actualCtx.runOnContext(v -> handler.handle(this.inProgressMap.size()));
    }

    private class Query<T> {
        final DatagramDnsQuery msg;
        final Promise<List<T>> promise;
        final String name;
        final DnsRecordType[] types;
        long timerID;

        public Query(String name2, DnsRecordType[] types) {
            this.msg = new DatagramDnsQuery(null, DnsClientImpl.this.dnsServer, ThreadLocalRandom.current().nextInt()).setRecursionDesired(DnsClientImpl.this.options.isRecursionDesired());
            if (!name2.endsWith(".")) {
                name2 = name2 + ".";
            }
            for (DnsRecordType type2 : types) {
                this.msg.addRecord(DnsSection.QUESTION, new DefaultDnsQuestion(name2, type2, 1));
            }
            this.promise = DnsClientImpl.this.actualCtx.nettyEventLoop().newPromise();
            this.types = types;
            this.name = name2;
        }

        private void fail(Throwable cause) {
            DnsClientImpl.this.inProgressMap.remove(DnsClientImpl.this.dnsMessageId(this.msg.id(), this.name));
            if (this.timerID >= 0L) {
                DnsClientImpl.this.vertx.cancelTimer(this.timerID);
            }
            this.promise.setFailure(cause);
        }

        void handle(DnsResponse msg) {
            DnsResponseCode code = DnsResponseCode.valueOf(msg.code().intValue());
            if (code == DnsResponseCode.NOERROR) {
                DnsClientImpl.this.inProgressMap.remove(DnsClientImpl.this.dnsMessageId(msg.id(), this.name));
                if (this.timerID >= 0L) {
                    DnsClientImpl.this.vertx.cancelTimer(this.timerID);
                }
                int count2 = msg.count(DnsSection.ANSWER);
                ArrayList records = new ArrayList(count2);
                for (int idx = 0; idx < count2; ++idx) {
                    Object a = msg.recordAt(DnsSection.ANSWER, idx);
                    Object record2 = RecordDecoder.decode(a);
                    if (!this.isRequestedType(a.type(), this.types)) continue;
                    records.add(record2);
                }
                if (records.size() > 0 && (records.get(0) instanceof MxRecordImpl || records.get(0) instanceof SrvRecordImpl)) {
                    Collections.sort(records);
                }
                this.promise.setSuccess(records);
            } else {
                this.fail(new DnsException(code));
            }
        }

        void run() {
            DnsClientImpl.this.inProgressMap.put(DnsClientImpl.this.dnsMessageId(this.msg.id(), this.name), this);
            this.timerID = DnsClientImpl.this.vertx.setTimer(DnsClientImpl.this.options.getQueryTimeout(), id -> {
                this.timerID = -1L;
                DnsClientImpl.this.actualCtx.runOnContext(v -> this.fail(new VertxException("DNS query timeout for " + this.name)));
            });
            DnsClientImpl.this.channel.writeAndFlush(this.msg).addListener(future2 -> {
                if (!future2.isSuccess()) {
                    DnsClientImpl.this.actualCtx.emit(future2.cause(), this::fail);
                }
            });
        }

        private boolean isRequestedType(DnsRecordType dnsRecordType, DnsRecordType[] types) {
            for (DnsRecordType t3 : types) {
                if (!t3.equals(dnsRecordType)) continue;
                return true;
            }
            return false;
        }
    }
}

