/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.dns;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;

public class AddressResolverOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, AddressResolverOptions obj2) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "cacheMaxTimeToLive": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setCacheMaxTimeToLive(((Number)member.getValue()).intValue());
                    break;
                }
                case "cacheMinTimeToLive": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setCacheMinTimeToLive(((Number)member.getValue()).intValue());
                    break;
                }
                case "cacheNegativeTimeToLive": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setCacheNegativeTimeToLive(((Number)member.getValue()).intValue());
                    break;
                }
                case "hostsPath": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setHostsPath((String)member.getValue());
                    break;
                }
                case "hostsValue": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setHostsValue(Buffer.buffer(BASE64_DECODER.decode((String)member.getValue())));
                    break;
                }
                case "maxQueries": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setMaxQueries(((Number)member.getValue()).intValue());
                    break;
                }
                case "ndots": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setNdots(((Number)member.getValue()).intValue());
                    break;
                }
                case "optResourceEnabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setOptResourceEnabled((Boolean)member.getValue());
                    break;
                }
                case "queryTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setQueryTimeout(((Number)member.getValue()).longValue());
                    break;
                }
                case "rdFlag": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setRdFlag((Boolean)member.getValue());
                    break;
                }
                case "rotateServers": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setRotateServers((Boolean)member.getValue());
                    break;
                }
                case "roundRobinInetAddress": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setRoundRobinInetAddress((Boolean)member.getValue());
                    break;
                }
                case "searchDomains": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj2.setSearchDomains(list);
                    break;
                }
                case "servers": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj2.setServers(list);
                }
            }
        }
    }

    static void toJson(AddressResolverOptions obj2, JsonObject json) {
        AddressResolverOptionsConverter.toJson(obj2, json.getMap());
    }

    static void toJson(AddressResolverOptions obj2, Map<String, Object> json) {
        JsonArray array2;
        json.put("cacheMaxTimeToLive", obj2.getCacheMaxTimeToLive());
        json.put("cacheMinTimeToLive", obj2.getCacheMinTimeToLive());
        json.put("cacheNegativeTimeToLive", obj2.getCacheNegativeTimeToLive());
        if (obj2.getHostsPath() != null) {
            json.put("hostsPath", obj2.getHostsPath());
        }
        if (obj2.getHostsValue() != null) {
            json.put("hostsValue", BASE64_ENCODER.encodeToString(obj2.getHostsValue().getBytes()));
        }
        json.put("maxQueries", obj2.getMaxQueries());
        json.put("ndots", obj2.getNdots());
        json.put("optResourceEnabled", obj2.isOptResourceEnabled());
        json.put("queryTimeout", obj2.getQueryTimeout());
        json.put("rdFlag", obj2.getRdFlag());
        json.put("rotateServers", obj2.isRotateServers());
        json.put("roundRobinInetAddress", obj2.isRoundRobinInetAddress());
        if (obj2.getSearchDomains() != null) {
            array2 = new JsonArray();
            obj2.getSearchDomains().forEach(item -> array2.add(item));
            json.put("searchDomains", array2);
        }
        if (obj2.getServers() != null) {
            array2 = new JsonArray();
            obj2.getServers().forEach(item -> array2.add(item));
            json.put("servers", array2);
        }
    }
}

