/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.cli.impl;

import io.vertx.core.cli.AmbiguousOptionException;
import io.vertx.core.cli.Argument;
import io.vertx.core.cli.CLI;
import io.vertx.core.cli.CLIException;
import io.vertx.core.cli.CommandLine;
import io.vertx.core.cli.InvalidValueException;
import io.vertx.core.cli.MissingOptionException;
import io.vertx.core.cli.MissingValueException;
import io.vertx.core.cli.Option;
import io.vertx.core.cli.impl.DefaultCommandLine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DefaultParser {
    protected String token;
    protected Option current;
    protected List<Option> expectedOpts;
    private DefaultCommandLine commandLine;
    private boolean skipParsing;
    private CLI cli;

    static String stripLeadingHyphens(String str2) {
        if (str2 == null) {
            return null;
        }
        if (str2.startsWith("--")) {
            return str2.substring(2, str2.length());
        }
        if (str2.startsWith("-")) {
            return str2.substring(1, str2.length());
        }
        return str2;
    }

    static String stripLeadingAndTrailingQuotes(String str2) {
        int length = str2.length();
        if (length > 1 && str2.startsWith("\"") && str2.endsWith("\"") && str2.substring(1, length - 1).indexOf(34) == -1) {
            str2 = str2.substring(1, length - 1);
        }
        return str2;
    }

    public CommandLine parse(CLI cli, List<String> cla) throws CLIException {
        return this.parse(cli, cla, true);
    }

    public CommandLine parse(CLI cli, List<String> cla, boolean validate2) throws CLIException {
        this.commandLine = (DefaultCommandLine)CommandLine.create(cli);
        this.current = null;
        this.skipParsing = false;
        this.cli = cli;
        int current = 0;
        for (Argument argument : cli.getArguments()) {
            if (argument.getIndex() == -1) {
                argument.setIndex(current);
                ++current;
                continue;
            }
            current = argument.getIndex() + 1;
        }
        cli.getArguments().sort((o1, o2) -> {
            if (o1.getIndex() == o2.getIndex()) {
                return 1;
            }
            return Integer.valueOf(o1.getIndex()).compareTo(o2.getIndex());
        });
        cli.getOptions().stream().forEach(Option::ensureValidity);
        cli.getArguments().stream().forEach(Argument::ensureValidity);
        this.expectedOpts = this.getRequiredOptions();
        if (cla != null) {
            cla.forEach(this::visit);
        }
        try {
            this.checkRequiredValues();
            this.checkRequiredOptions();
            this.validate();
            this.commandLine.setValidity(true);
        }
        catch (CLIException e2) {
            if (validate2 && !this.commandLine.isAskingForHelp()) {
                throw e2;
            }
            this.commandLine.setValidity(false);
        }
        return this.commandLine;
    }

    protected void validate() throws CLIException {
        boolean multiValue = false;
        ArrayList<Integer> usedIndexes = new ArrayList<Integer>();
        for (Argument argument : this.cli.getArguments()) {
            if (usedIndexes.contains(argument.getIndex())) {
                throw new CLIException("Only one argument can use the index " + argument.getIndex());
            }
            usedIndexes.add(argument.getIndex());
            if (multiValue) {
                throw new CLIException("Only the last argument can be multi-valued");
            }
            multiValue = argument.isMultiValued();
        }
        Iterator<Argument> iterator2 = this.cli.getArguments().iterator();
        Argument current = null;
        if (iterator2.hasNext()) {
            current = iterator2.next();
        }
        for (String v : this.commandLine.allArguments()) {
            if (current == null) continue;
            this.commandLine.setRawValue(current, v);
            if (current.isMultiValued()) continue;
            if (iterator2.hasNext()) {
                current = iterator2.next();
                continue;
            }
            current = null;
        }
        for (Argument arg : this.cli.getArguments()) {
            if (!arg.isRequired() || this.commandLine.isArgumentAssigned(arg)) continue;
            throw new MissingValueException(arg);
        }
    }

    private List<Option> getRequiredOptions() {
        return this.cli.getOptions().stream().filter(Option::isRequired).collect(Collectors.toList());
    }

    private void checkRequiredOptions() throws MissingOptionException {
        if (!this.expectedOpts.isEmpty()) {
            throw new MissingOptionException(this.expectedOpts);
        }
    }

    private void checkRequiredValues() throws MissingValueException {
        if (this.current != null && this.current.acceptValue() && !this.commandLine.isOptionAssigned(this.current) && !this.current.isFlag()) {
            throw new MissingValueException(this.current);
        }
    }

    private void visit(String token2) throws CLIException {
        this.token = token2;
        if (this.skipParsing) {
            this.commandLine.addArgumentValue(token2);
        } else if (token2.equals("--")) {
            this.skipParsing = true;
        } else if (this.current != null && this.current.acceptValue() && this.isValue(token2)) {
            this.commandLine.addRawValue(this.current, DefaultParser.stripLeadingAndTrailingQuotes(token2));
        } else if (token2.startsWith("--")) {
            this.handleLongOption(token2);
        } else if (token2.startsWith("-") && !"-".equals(token2)) {
            this.handleShortAndLongOption(token2);
        } else {
            this.handleArgument(token2);
        }
        if (this.current != null && !this.commandLine.acceptMoreValues(this.current)) {
            this.current = null;
        }
    }

    private boolean isValue(String token2) {
        return !this.isOption(token2) || this.isNegativeNumber(token2);
    }

    private boolean isNegativeNumber(String token2) {
        try {
            Double.parseDouble(token2);
            return true;
        }
        catch (NumberFormatException e2) {
            return false;
        }
    }

    private boolean isOption(String token2) {
        return this.isLongOption(token2) || this.isShortOption(token2);
    }

    private boolean isShortOption(String token2) {
        return token2.startsWith("-") && token2.length() >= 2 && this.hasOptionWithShortName(token2.substring(1, 2));
    }

    private boolean isLongOption(String token2) {
        String t3;
        if (!token2.startsWith("-") || token2.length() == 1) {
            return false;
        }
        int pos = token2.indexOf("=");
        String string2 = t3 = pos == -1 ? token2 : token2.substring(0, pos);
        if (!this.getMatchingOptions(t3).isEmpty()) {
            return true;
        }
        return this.getLongPrefix(token2) != null && !token2.startsWith("--");
    }

    private void handleArgument(String token2) {
        this.commandLine.addArgumentValue(token2);
    }

    private void handleLongOption(String token2) throws CLIException {
        if (token2.indexOf(61) == -1) {
            this.handleLongOptionWithoutEqual(token2);
        } else {
            this.handleLongOptionWithEqual(token2);
        }
    }

    private void handleLongOptionWithoutEqual(String token2) throws CLIException {
        List<Option> matchingOpts = this.getMatchingOptions(token2);
        if (matchingOpts.isEmpty()) {
            this.handleArgument(token2);
        } else {
            if (matchingOpts.size() > 1) {
                throw new AmbiguousOptionException(token2, matchingOpts);
            }
            Option option = matchingOpts.get(0);
            this.handleOption(option);
        }
    }

    private void handleLongOptionWithEqual(String token2) throws CLIException {
        int pos = token2.indexOf(61);
        String value = token2.substring(pos + 1);
        String opt = token2.substring(0, pos);
        List<Option> matchingOpts = this.getMatchingOptions(opt);
        if (matchingOpts.isEmpty()) {
            this.handleArgument(token2);
        } else {
            if (matchingOpts.size() > 1) {
                throw new AmbiguousOptionException(opt, matchingOpts);
            }
            Option option = matchingOpts.get(0);
            if (this.commandLine.acceptMoreValues(option)) {
                this.handleOption(option);
                this.commandLine.addRawValue(option, value);
                this.current = null;
            } else {
                throw new InvalidValueException(option, value);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleShortAndLongOption(String token2) throws CLIException {
        String t3 = DefaultParser.stripLeadingHyphens(token2);
        int pos = t3.indexOf(61);
        if (t3.length() == 1) {
            if (this.hasOptionWithShortName(t3)) {
                this.handleOption(this.getOption(t3));
                return;
            } else {
                this.handleArgument(token2);
            }
            return;
        } else if (pos == -1) {
            if (this.hasOptionWithShortName(t3)) {
                this.handleOption(this.getOption(t3));
                return;
            } else if (!this.getMatchingOptions(t3).isEmpty()) {
                this.handleLongOptionWithoutEqual(token2);
                return;
            } else {
                String opt = this.getLongPrefix(t3);
                if (opt != null) {
                    if (!this.commandLine.acceptMoreValues(this.getOption(opt))) throw new InvalidValueException(this.getOption(opt), t3.substring(opt.length()));
                    this.handleOption(this.getOption(opt));
                    this.commandLine.addRawValue(this.getOption(opt), t3.substring(opt.length()));
                    this.current = null;
                    return;
                } else if (this.isAValidShortOption(t3)) {
                    String strip = t3.substring(0, 1);
                    Option option = this.getOption(strip);
                    this.handleOption(option);
                    this.commandLine.addRawValue(this.current, t3.substring(1));
                    this.current = null;
                    return;
                } else {
                    this.handleConcatenatedOptions(token2);
                }
            }
            return;
        } else {
            String opt = t3.substring(0, pos);
            String value = t3.substring(pos + 1);
            if (opt.length() == 1) {
                Option option = this.getOption(opt);
                if (option != null) {
                    if (!this.commandLine.acceptMoreValues(option)) throw new InvalidValueException(option, value);
                    this.handleOption(option);
                    this.commandLine.addRawValue(option, value);
                    this.current = null;
                    return;
                } else {
                    this.handleArgument(token2);
                }
                return;
            } else if (this.isAValidShortOption(opt) && !this.hasOptionWithLongName(opt)) {
                this.handleOption(this.getOption(opt.substring(0, 1)));
                this.commandLine.addRawValue(this.current, opt.substring(1) + "=" + value);
                this.current = null;
                return;
            } else {
                this.handleLongOptionWithEqual(token2);
            }
        }
    }

    private String getLongPrefix(String token2) {
        String t3 = DefaultParser.stripLeadingHyphens(token2);
        String opt = null;
        for (int i = t3.length() - 2; i > 1; --i) {
            String prefix = t3.substring(0, i);
            if (!this.hasOptionWithLongName(prefix)) continue;
            opt = prefix;
            break;
        }
        return opt;
    }

    private boolean hasOptionWithLongName(String name2) {
        for (Option option : this.cli.getOptions()) {
            if (!name2.equals(option.getLongName())) continue;
            return true;
        }
        return false;
    }

    private boolean hasOptionWithShortName(String name2) {
        for (Option option : this.cli.getOptions()) {
            if (!name2.equals(option.getShortName())) continue;
            return true;
        }
        return false;
    }

    private void handleOption(Option option) throws CLIException {
        this.checkRequiredValues();
        this.updateRequiredOptions(option);
        this.commandLine.setSeenInCommandLine(option);
        this.current = this.commandLine.acceptMoreValues(option) ? option : null;
    }

    private void updateRequiredOptions(Option option) {
        if (option.isRequired()) {
            this.expectedOpts.remove(option);
        }
    }

    public Option getOption(String opt) {
        opt = DefaultParser.stripLeadingHyphens(opt);
        for (Option option : this.cli.getOptions()) {
            if (!opt.equals(option.getShortName()) && !opt.equalsIgnoreCase(option.getLongName())) continue;
            return option;
        }
        return null;
    }

    private boolean isAValidShortOption(String token2) {
        String opt = token2.substring(0, 1);
        Option option = this.getOption(opt);
        return option != null && this.commandLine.acceptMoreValues(option);
    }

    public List<Option> getMatchingOptions(String opt) {
        Objects.requireNonNull(opt);
        opt = DefaultParser.stripLeadingHyphens(opt);
        ArrayList<Option> matching = new ArrayList<Option>();
        List<Option> options2 = this.cli.getOptions();
        for (Option option : options2) {
            if (!opt.equals(option.getLongName())) continue;
            return Collections.singletonList(option);
        }
        for (Option option : options2) {
            if (!opt.equalsIgnoreCase(option.getLongName())) continue;
            matching.add(option);
        }
        for (Option option : options2) {
            if (option.getLongName() == null || !option.getLongName().startsWith(opt)) continue;
            matching.add(option);
        }
        return matching;
    }

    protected void handleConcatenatedOptions(String token2) throws CLIException {
        for (int i = 1; i < token2.length(); ++i) {
            String ch = String.valueOf(token2.charAt(i));
            if (this.hasOptionWithShortName(ch)) {
                this.handleOption(this.getOption(ch));
                if (this.current == null || token2.length() == i + 1) continue;
                this.commandLine.addRawValue(this.current, token2.substring(i + 1));
                break;
            }
            this.handleArgument(token2);
            break;
        }
    }
}

