/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.cli.impl;

import io.vertx.core.cli.Argument;
import io.vertx.core.cli.CLI;
import io.vertx.core.cli.CommandLine;
import io.vertx.core.cli.Option;
import io.vertx.core.cli.UsageMessageFormatter;
import io.vertx.core.cli.impl.DefaultParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DefaultCLI
implements CLI {
    protected String name;
    protected int priority;
    protected String description;
    protected String summary;
    protected boolean hidden;
    protected List<Option> options = new ArrayList<Option>();
    private List<Argument> arguments = new ArrayList<Argument>();

    @Override
    public CommandLine parse(List<String> arguments2) {
        return new DefaultParser().parse(this, arguments2);
    }

    @Override
    public CommandLine parse(List<String> arguments2, boolean validate2) {
        return new DefaultParser().parse(this, arguments2, validate2);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CLI setName(String name2) {
        Objects.requireNonNull(name2);
        if (name2.isEmpty()) {
            throw new IllegalArgumentException("Invalid command name");
        }
        this.name = name2;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public CLI setDescription(String desc) {
        Objects.requireNonNull(desc);
        this.description = desc;
        return this;
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public CLI setSummary(String summary) {
        Objects.requireNonNull(summary);
        this.summary = summary;
        return this;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public CLI setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Override
    public List<Option> getOptions() {
        return this.options;
    }

    @Override
    public CLI addOption(Option option) {
        Objects.requireNonNull(option);
        this.options.add(option);
        return this;
    }

    @Override
    public CLI addOptions(List<Option> options2) {
        Objects.requireNonNull(options2);
        options2.forEach(this::addOption);
        return this;
    }

    @Override
    public CLI setOptions(List<Option> options2) {
        Objects.requireNonNull(options2);
        this.options = new ArrayList<Option>();
        return this.addOptions(options2);
    }

    @Override
    public List<Argument> getArguments() {
        return this.arguments;
    }

    @Override
    public CLI addArgument(Argument arg) {
        Objects.requireNonNull(arg);
        this.arguments.add(arg);
        return this;
    }

    @Override
    public CLI addArguments(List<Argument> args2) {
        Objects.requireNonNull(args2);
        args2.forEach(this::addArgument);
        return this;
    }

    @Override
    public CLI setArguments(List<Argument> args2) {
        Objects.requireNonNull(args2);
        this.arguments = new ArrayList<Argument>(args2);
        return this;
    }

    @Override
    public Option getOption(String name2) {
        Objects.requireNonNull(name2);
        List<Predicate> equalityChecks = Arrays.asList(option -> name2.equals(option.getLongName()), option -> name2.equals(option.getShortName()), option -> name2.equals(option.getArgName()), option -> name2.equalsIgnoreCase(option.getLongName()), option -> name2.equalsIgnoreCase(option.getShortName()), option -> name2.equalsIgnoreCase(option.getArgName()));
        for (Predicate equalityCheck : equalityChecks) {
            for (Option option2 : this.options) {
                if (!equalityCheck.test(option2)) continue;
                return option2;
            }
        }
        return null;
    }

    @Override
    public Argument getArgument(String name2) {
        Objects.requireNonNull(name2);
        for (Argument arg : this.arguments) {
            if (!name2.equalsIgnoreCase(arg.getArgName())) continue;
            return arg;
        }
        return null;
    }

    @Override
    public Argument getArgument(int index2) {
        if (index2 < 0) {
            throw new IllegalArgumentException("Given index cannot be negative");
        }
        for (Argument arg : this.arguments) {
            if (index2 != arg.getIndex()) continue;
            return arg;
        }
        return null;
    }

    @Override
    public CLI removeOption(String name2) {
        this.options = this.options.stream().filter(o -> !o.getLongName().equals(name2) && !o.getShortName().equals(name2)).collect(Collectors.toList());
        return this;
    }

    @Override
    public CLI removeArgument(int index2) {
        for (Argument arg : new TreeSet<Argument>(this.arguments)) {
            if (arg.getIndex() != index2) continue;
            this.arguments.remove(arg);
            return this;
        }
        return this;
    }

    @Override
    public CLI usage(StringBuilder builder) {
        new UsageMessageFormatter().usage(builder, this);
        return this;
    }

    @Override
    public CLI usage(StringBuilder builder, String prefix) {
        new UsageMessageFormatter().usage(builder, prefix, this);
        return this;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public CLI setPriority(int priority) {
        this.priority = priority;
        return this;
    }
}

