/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.cli.converters;

import io.vertx.core.cli.converters.Converter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class FromBasedConverter<T>
implements Converter<T> {
    public static final String FROM = "from";
    private final Method method;
    private final Class<T> clazz;

    private FromBasedConverter(Class<T> clazz, Method method) {
        this.clazz = clazz;
        this.method = method;
    }

    public static <T> FromBasedConverter<T> getIfEligible(Class<T> clazz) {
        try {
            Method method = clazz.getMethod(FROM, String.class);
            if (Modifier.isStatic(method.getModifiers())) {
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                return new FromBasedConverter<T>(clazz, method);
            }
            return null;
        }
        catch (NoSuchMethodException e2) {
            return null;
        }
    }

    @Override
    public T fromString(String input2) throws IllegalArgumentException {
        try {
            return this.clazz.cast(this.method.invoke(null, input2));
        }
        catch (IllegalAccessException | InvocationTargetException e2) {
            if (e2.getCause() != null) {
                throw new IllegalArgumentException(e2.getCause());
            }
            throw new IllegalArgumentException(e2);
        }
    }
}

