/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.cli.converters;

import io.vertx.core.cli.converters.Converter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public final class ConstructorBasedConverter<T>
implements Converter<T> {
    private final Constructor<T> constructor;

    private ConstructorBasedConverter(Constructor<T> constructor) {
        this.constructor = constructor;
    }

    public static <T> ConstructorBasedConverter<T> getIfEligible(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getConstructor(String.class);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return new ConstructorBasedConverter<T>(constructor);
        }
        catch (NoSuchMethodException e2) {
            return null;
        }
    }

    @Override
    public T fromString(String input2) throws IllegalArgumentException {
        try {
            return this.constructor.newInstance(input2);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e2) {
            if (e2.getCause() != null) {
                throw new IllegalArgumentException(e2.getCause());
            }
            throw new IllegalArgumentException(e2);
        }
    }
}

