/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.cli.annotations;

import io.vertx.core.cli.CLI;
import io.vertx.core.cli.CLIException;
import io.vertx.core.cli.CommandLine;
import io.vertx.core.cli.Option;
import io.vertx.core.cli.TypedArgument;
import io.vertx.core.cli.TypedOption;
import io.vertx.core.cli.annotations.Argument;
import io.vertx.core.cli.annotations.ConvertedBy;
import io.vertx.core.cli.annotations.DefaultValue;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Hidden;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.ParsedAsList;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.core.cli.impl.DefaultCLI;
import io.vertx.core.cli.impl.ReflectionUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class CLIConfigurator {
    public static CLI define(Class<?> clazz) {
        DefaultCLI cli = new DefaultCLI();
        Summary summary = clazz.getAnnotation(Summary.class);
        Description desc = clazz.getAnnotation(Description.class);
        Hidden hidden = clazz.getAnnotation(Hidden.class);
        Name name2 = clazz.getAnnotation(Name.class);
        if (name2 == null) {
            throw new IllegalArgumentException("The command cannot be defined, the @Name annotation is missing.");
        }
        if (name2.value().isEmpty()) {
            throw new IllegalArgumentException("The command cannot be defined, the @Name value is empty or null.");
        }
        cli.setName(name2.value());
        cli.setPriority(name2.priority());
        if (summary != null) {
            cli.setSummary(summary.value());
        }
        if (desc != null) {
            cli.setDescription(desc.value());
        }
        if (hidden != null) {
            cli.setHidden(true);
        }
        List<Method> methods2 = ReflectionUtils.getSetterMethods(clazz);
        for (Method method : methods2) {
            io.vertx.core.cli.annotations.Option option = method.getAnnotation(io.vertx.core.cli.annotations.Option.class);
            Argument argument = method.getAnnotation(Argument.class);
            if (option != null) {
                cli.addOption(CLIConfigurator.createOption(method));
            }
            if (argument == null) continue;
            cli.addArgument(CLIConfigurator.createArgument(method));
        }
        return cli;
    }

    private static Option createOption(Method method) {
        DefaultValue defaultValue;
        ParsedAsList parsedAsList;
        Hidden hidden;
        TypedOption opt = new TypedOption();
        io.vertx.core.cli.annotations.Option option = method.getAnnotation(io.vertx.core.cli.annotations.Option.class);
        ((TypedOption)((TypedOption)((TypedOption)((TypedOption)((TypedOption)opt.setLongName(option.longName())).setShortName(option.shortName())).setMultiValued(option.acceptMultipleValues())).setSingleValued(option.acceptValue())).setArgName(option.argName())).setFlag(option.flag()).setHelp(option.help()).setRequired(option.required());
        Description description2 = method.getAnnotation(Description.class);
        if (description2 != null) {
            opt.setDescription(description2.value());
        }
        if ((hidden = method.getAnnotation(Hidden.class)) != null) {
            opt.setHidden(true);
        }
        if (ReflectionUtils.isMultiple(method)) {
            opt.setType(ReflectionUtils.getComponentType(method.getParameters()[0])).setMultiValued(true);
        } else {
            Class<?> type2 = method.getParameters()[0].getType();
            opt.setType(type2);
            if (type2 != Boolean.TYPE && type2 != Boolean.class) {
                opt.setSingleValued(true);
            }
        }
        ConvertedBy convertedBy = method.getAnnotation(ConvertedBy.class);
        if (convertedBy != null) {
            opt.setConverter(ReflectionUtils.newInstance(convertedBy.value()));
        }
        if ((parsedAsList = method.getAnnotation(ParsedAsList.class)) != null) {
            opt.setParsedAsList(true).setListSeparator(parsedAsList.separator());
        }
        if ((defaultValue = method.getAnnotation(DefaultValue.class)) != null) {
            opt.setDefaultValue(defaultValue.value());
        }
        opt.ensureValidity();
        return opt;
    }

    private static io.vertx.core.cli.Argument createArgument(Method method) {
        DefaultValue defaultValue;
        ConvertedBy convertedBy;
        TypedArgument arg = new TypedArgument();
        Argument argument = method.getAnnotation(Argument.class);
        arg.setIndex(argument.index());
        arg.setArgName(argument.argName());
        arg.setRequired(argument.required());
        Description description2 = method.getAnnotation(Description.class);
        if (description2 != null) {
            arg.setDescription(description2.value());
        }
        if (ReflectionUtils.isMultiple(method)) {
            arg.setType(ReflectionUtils.getComponentType(method.getParameters()[0])).setMultiValued(true);
        } else {
            Class<?> type2 = method.getParameters()[0].getType();
            arg.setType(type2);
        }
        Hidden hidden = method.getAnnotation(Hidden.class);
        if (hidden != null) {
            arg.setHidden(true);
        }
        if ((convertedBy = method.getAnnotation(ConvertedBy.class)) != null) {
            arg.setConverter(ReflectionUtils.newInstance(convertedBy.value()));
        }
        if ((defaultValue = method.getAnnotation(DefaultValue.class)) != null) {
            arg.setDefaultValue(defaultValue.value());
        }
        return arg;
    }

    private static Object getOptionValue(Method method, String name2, CommandLine commandLine) {
        Option option = commandLine.cli().getOption(name2);
        if (option == null) {
            return null;
        }
        boolean multiple = ReflectionUtils.isMultiple(method);
        if (multiple) {
            return CLIConfigurator.createMultiValueContainer(method, commandLine.getOptionValues(name2));
        }
        return commandLine.getOptionValue(name2);
    }

    private static Object getArgumentValue(Method method, int index2, CommandLine commandLine) {
        io.vertx.core.cli.Argument argument = commandLine.cli().getArgument(index2);
        if (argument == null) {
            return null;
        }
        boolean multiple = ReflectionUtils.isMultiple(method);
        if (multiple) {
            return CLIConfigurator.createMultiValueContainer(method, commandLine.getArgumentValues(argument.getIndex()));
        }
        return commandLine.getArgumentValue(argument.getIndex());
    }

    public static void inject(CommandLine cli, Object object) throws CLIException {
        List<Method> methods2 = ReflectionUtils.getSetterMethods(object.getClass());
        for (Method method : methods2) {
            Object injected;
            io.vertx.core.cli.annotations.Option option = method.getAnnotation(io.vertx.core.cli.annotations.Option.class);
            Argument argument = method.getAnnotation(Argument.class);
            if (option != null) {
                String name2 = option.longName();
                if (name2 == null) {
                    name2 = option.shortName();
                }
                try {
                    injected = CLIConfigurator.getOptionValue(method, name2, cli);
                    if (injected != null) {
                        method.setAccessible(true);
                        method.invoke(object, injected);
                    }
                }
                catch (Exception e2) {
                    throw new CLIException("Cannot inject value for option '" + name2 + "'", e2);
                }
            }
            if (argument == null) continue;
            int index2 = argument.index();
            try {
                injected = CLIConfigurator.getArgumentValue(method, index2, cli);
                if (injected == null) continue;
                method.setAccessible(true);
                method.invoke(object, injected);
            }
            catch (Exception e3) {
                throw new CLIException("Cannot inject value for argument '" + index2 + "'", e3);
            }
        }
    }

    private static <T> Object createMultiValueContainer(Method setter, List<T> values2) {
        Class<?> type2 = setter.getParameterTypes()[0];
        if (type2.isArray()) {
            Object array2 = Array.newInstance(type2.getComponentType(), values2.size());
            for (int i = 0; i < values2.size(); ++i) {
                Array.set(array2, i, values2.get(i));
            }
            return array2;
        }
        if (Set.class.isAssignableFrom(type2)) {
            return new LinkedHashSet<T>(values2);
        }
        if (List.class.isAssignableFrom(type2) || Collection.class.isAssignableFrom(type2)) {
            return values2;
        }
        return null;
    }
}

