/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.VertxOptions;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.eventbus.EventBusOptions;
import io.vertx.core.file.FileSystemOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.tracing.TracingOptions;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class VertxOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, VertxOptions obj2) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "addressResolverOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setAddressResolverOptions(new AddressResolverOptions((JsonObject)member.getValue()));
                    break;
                }
                case "blockedThreadCheckInterval": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setBlockedThreadCheckInterval(((Number)member.getValue()).longValue());
                    break;
                }
                case "blockedThreadCheckIntervalUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setBlockedThreadCheckIntervalUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "disableTCCL": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setDisableTCCL((Boolean)member.getValue());
                    break;
                }
                case "eventBusOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setEventBusOptions(new EventBusOptions((JsonObject)member.getValue()));
                    break;
                }
                case "eventLoopPoolSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setEventLoopPoolSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "fileSystemOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setFileSystemOptions(new FileSystemOptions((JsonObject)member.getValue()));
                    break;
                }
                case "haEnabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setHAEnabled((Boolean)member.getValue());
                    break;
                }
                case "haGroup": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setHAGroup((String)member.getValue());
                    break;
                }
                case "internalBlockingPoolSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setInternalBlockingPoolSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxEventLoopExecuteTime": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setMaxEventLoopExecuteTime(((Number)member.getValue()).longValue());
                    break;
                }
                case "maxEventLoopExecuteTimeUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setMaxEventLoopExecuteTimeUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "maxWorkerExecuteTime": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setMaxWorkerExecuteTime(((Number)member.getValue()).longValue());
                    break;
                }
                case "maxWorkerExecuteTimeUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setMaxWorkerExecuteTimeUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "metricsOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setMetricsOptions(new MetricsOptions((JsonObject)member.getValue()));
                    break;
                }
                case "preferNativeTransport": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setPreferNativeTransport((Boolean)member.getValue());
                    break;
                }
                case "quorumSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setQuorumSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "tracingOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setTracingOptions(new TracingOptions((JsonObject)member.getValue()));
                    break;
                }
                case "useDaemonThread": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setUseDaemonThread((Boolean)member.getValue());
                    break;
                }
                case "warningExceptionTime": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setWarningExceptionTime(((Number)member.getValue()).longValue());
                    break;
                }
                case "warningExceptionTimeUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setWarningExceptionTimeUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "workerPoolSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setWorkerPoolSize(((Number)member.getValue()).intValue());
                }
            }
        }
    }

    static void toJson(VertxOptions obj2, JsonObject json) {
        VertxOptionsConverter.toJson(obj2, json.getMap());
    }

    static void toJson(VertxOptions obj2, Map<String, Object> json) {
        if (obj2.getAddressResolverOptions() != null) {
            json.put("addressResolverOptions", obj2.getAddressResolverOptions().toJson());
        }
        json.put("blockedThreadCheckInterval", obj2.getBlockedThreadCheckInterval());
        if (obj2.getBlockedThreadCheckIntervalUnit() != null) {
            json.put("blockedThreadCheckIntervalUnit", obj2.getBlockedThreadCheckIntervalUnit().name());
        }
        json.put("disableTCCL", obj2.getDisableTCCL());
        if (obj2.getEventBusOptions() != null) {
            json.put("eventBusOptions", obj2.getEventBusOptions().toJson());
        }
        json.put("eventLoopPoolSize", obj2.getEventLoopPoolSize());
        if (obj2.getFileSystemOptions() != null) {
            json.put("fileSystemOptions", obj2.getFileSystemOptions().toJson());
        }
        json.put("haEnabled", obj2.isHAEnabled());
        if (obj2.getHAGroup() != null) {
            json.put("haGroup", obj2.getHAGroup());
        }
        json.put("internalBlockingPoolSize", obj2.getInternalBlockingPoolSize());
        json.put("maxEventLoopExecuteTime", obj2.getMaxEventLoopExecuteTime());
        if (obj2.getMaxEventLoopExecuteTimeUnit() != null) {
            json.put("maxEventLoopExecuteTimeUnit", obj2.getMaxEventLoopExecuteTimeUnit().name());
        }
        json.put("maxWorkerExecuteTime", obj2.getMaxWorkerExecuteTime());
        if (obj2.getMaxWorkerExecuteTimeUnit() != null) {
            json.put("maxWorkerExecuteTimeUnit", obj2.getMaxWorkerExecuteTimeUnit().name());
        }
        if (obj2.getMetricsOptions() != null) {
            json.put("metricsOptions", obj2.getMetricsOptions().toJson());
        }
        json.put("preferNativeTransport", obj2.getPreferNativeTransport());
        json.put("quorumSize", obj2.getQuorumSize());
        if (obj2.getTracingOptions() != null) {
            json.put("tracingOptions", obj2.getTracingOptions().toJson());
        }
        if (obj2.getUseDaemonThread() != null) {
            json.put("useDaemonThread", obj2.getUseDaemonThread());
        }
        json.put("warningExceptionTime", obj2.getWarningExceptionTime());
        if (obj2.getWarningExceptionTimeUnit() != null) {
            json.put("warningExceptionTimeUnit", obj2.getWarningExceptionTimeUnit().name());
        }
        json.put("workerPoolSize", obj2.getWorkerPoolSize());
    }
}

