/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DeploymentOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, DeploymentOptions obj2) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "config": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setConfig(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "ha": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setHa((Boolean)member.getValue());
                    break;
                }
                case "instances": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setInstances(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxWorkerExecuteTime": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setMaxWorkerExecuteTime(((Number)member.getValue()).longValue());
                    break;
                }
                case "maxWorkerExecuteTimeUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setMaxWorkerExecuteTimeUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "worker": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setWorker((Boolean)member.getValue());
                    break;
                }
                case "workerPoolName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setWorkerPoolName((String)member.getValue());
                    break;
                }
                case "workerPoolSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setWorkerPoolSize(((Number)member.getValue()).intValue());
                }
            }
        }
    }

    static void toJson(DeploymentOptions obj2, JsonObject json) {
        DeploymentOptionsConverter.toJson(obj2, json.getMap());
    }

    static void toJson(DeploymentOptions obj2, Map<String, Object> json) {
        if (obj2.getConfig() != null) {
            json.put("config", obj2.getConfig());
        }
        json.put("ha", obj2.isHa());
        json.put("instances", obj2.getInstances());
        json.put("maxWorkerExecuteTime", obj2.getMaxWorkerExecuteTime());
        if (obj2.getMaxWorkerExecuteTimeUnit() != null) {
            json.put("maxWorkerExecuteTimeUnit", obj2.getMaxWorkerExecuteTimeUnit().name());
        }
        json.put("worker", obj2.isWorker());
        if (obj2.getWorkerPoolName() != null) {
            json.put("workerPoolName", obj2.getWorkerPoolName());
        }
        json.put("workerPoolSize", obj2.getWorkerPoolSize());
    }
}

