/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import io.netty.handler.ssl.JdkSslEngine;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.util.LinkedHashSet;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.eclipse.jetty.npn.NextProtoNego;

final class JettyNpnSslEngine
extends JdkSslEngine {
    private static boolean available;

    static boolean isAvailable() {
        JettyNpnSslEngine.updateAvailability();
        return available;
    }

    private static void updateAvailability() {
        if (available) {
            return;
        }
        try {
            Class.forName("sun.security.ssl.NextProtoNegoExtension", true, null);
            available = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    JettyNpnSslEngine(SSLEngine engine2, final JdkApplicationProtocolNegotiator applicationNegotiator, boolean server2) {
        super(engine2);
        ObjectUtil.checkNotNull(applicationNegotiator, "applicationNegotiator");
        if (server2) {
            final JdkApplicationProtocolNegotiator.ProtocolSelectionListener protocolListener = ObjectUtil.checkNotNull(applicationNegotiator.protocolListenerFactory().newListener(this, applicationNegotiator.protocols()), "protocolListener");
            NextProtoNego.put((SSLEngine)engine2, (NextProtoNego.Provider)new NextProtoNego.ServerProvider(){

                public void unsupported() {
                    protocolListener.unsupported();
                }

                public List<String> protocols() {
                    return applicationNegotiator.protocols();
                }

                public void protocolSelected(String protocol2) {
                    try {
                        protocolListener.selected(protocol2);
                    }
                    catch (Throwable t3) {
                        PlatformDependent.throwException(t3);
                    }
                }
            });
        } else {
            final JdkApplicationProtocolNegotiator.ProtocolSelector protocolSelector = ObjectUtil.checkNotNull(applicationNegotiator.protocolSelectorFactory().newSelector(this, new LinkedHashSet<String>(applicationNegotiator.protocols())), "protocolSelector");
            NextProtoNego.put((SSLEngine)engine2, (NextProtoNego.Provider)new NextProtoNego.ClientProvider(){

                public boolean supports() {
                    return true;
                }

                public void unsupported() {
                    protocolSelector.unsupported();
                }

                public String selectProtocol(List<String> protocols2) {
                    try {
                        return protocolSelector.select(protocols2);
                    }
                    catch (Throwable t3) {
                        PlatformDependent.throwException(t3);
                        return null;
                    }
                }
            });
        }
    }

    @Override
    public void closeInbound() throws SSLException {
        NextProtoNego.remove((SSLEngine)this.getWrappedEngine());
        super.closeInbound();
    }

    @Override
    public void closeOutbound() {
        NextProtoNego.remove((SSLEngine)this.getWrappedEngine());
        super.closeOutbound();
    }
}

