/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.CharSequenceValueConverter;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import io.netty.util.HashingStrategy;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class ReadOnlyHttp2Headers
implements Http2Headers {
    private static final byte PSEUDO_HEADER_TOKEN = 58;
    private final AsciiString[] pseudoHeaders;
    private final AsciiString[] otherHeaders;

    public static ReadOnlyHttp2Headers trailers(boolean validateHeaders, AsciiString ... otherHeaders) {
        return new ReadOnlyHttp2Headers(validateHeaders, EmptyArrays.EMPTY_ASCII_STRINGS, otherHeaders);
    }

    public static ReadOnlyHttp2Headers clientHeaders(boolean validateHeaders, AsciiString method, AsciiString path2, AsciiString scheme, AsciiString authority, AsciiString ... otherHeaders) {
        return new ReadOnlyHttp2Headers(validateHeaders, new AsciiString[]{Http2Headers.PseudoHeaderName.METHOD.value(), method, Http2Headers.PseudoHeaderName.PATH.value(), path2, Http2Headers.PseudoHeaderName.SCHEME.value(), scheme, Http2Headers.PseudoHeaderName.AUTHORITY.value(), authority}, otherHeaders);
    }

    public static ReadOnlyHttp2Headers serverHeaders(boolean validateHeaders, AsciiString status, AsciiString ... otherHeaders) {
        return new ReadOnlyHttp2Headers(validateHeaders, new AsciiString[]{Http2Headers.PseudoHeaderName.STATUS.value(), status}, otherHeaders);
    }

    private ReadOnlyHttp2Headers(boolean validateHeaders, AsciiString[] pseudoHeaders, AsciiString ... otherHeaders) {
        assert ((pseudoHeaders.length & 1) == 0);
        if ((otherHeaders.length & 1) != 0) {
            throw ReadOnlyHttp2Headers.newInvalidArraySizeException();
        }
        if (validateHeaders) {
            ReadOnlyHttp2Headers.validateHeaders(pseudoHeaders, otherHeaders);
        }
        this.pseudoHeaders = pseudoHeaders;
        this.otherHeaders = otherHeaders;
    }

    private static IllegalArgumentException newInvalidArraySizeException() {
        return new IllegalArgumentException("pseudoHeaders and otherHeaders must be arrays of [name, value] pairs");
    }

    private static void validateHeaders(AsciiString[] pseudoHeaders, AsciiString ... otherHeaders) {
        for (int i = 1; i < pseudoHeaders.length; i += 2) {
            ObjectUtil.checkNotNullArrayParam(pseudoHeaders[i], i, "pseudoHeaders");
        }
        boolean seenNonPseudoHeader = false;
        int otherHeadersEnd = otherHeaders.length - 1;
        for (int i = 0; i < otherHeadersEnd; i += 2) {
            AsciiString name2 = otherHeaders[i];
            DefaultHttp2Headers.HTTP2_NAME_VALIDATOR.validateName(name2);
            if (!seenNonPseudoHeader && !name2.isEmpty() && name2.byteAt(0) != 58) {
                seenNonPseudoHeader = true;
            } else if (seenNonPseudoHeader && !name2.isEmpty() && name2.byteAt(0) == 58) {
                throw new IllegalArgumentException("otherHeaders name at index " + i + " is a pseudo header that appears after non-pseudo headers.");
            }
            ObjectUtil.checkNotNullArrayParam(otherHeaders[i + 1], i + 1, "otherHeaders");
        }
    }

    private AsciiString get0(CharSequence name2) {
        int nameHash = AsciiString.hashCode(name2);
        int pseudoHeadersEnd = this.pseudoHeaders.length - 1;
        for (int i = 0; i < pseudoHeadersEnd; i += 2) {
            AsciiString roName = this.pseudoHeaders[i];
            if (roName.hashCode() != nameHash || !roName.contentEqualsIgnoreCase(name2)) continue;
            return this.pseudoHeaders[i + 1];
        }
        int otherHeadersEnd = this.otherHeaders.length - 1;
        for (int i = 0; i < otherHeadersEnd; i += 2) {
            AsciiString roName = this.otherHeaders[i];
            if (roName.hashCode() != nameHash || !roName.contentEqualsIgnoreCase(name2)) continue;
            return this.otherHeaders[i + 1];
        }
        return null;
    }

    @Override
    public CharSequence get(CharSequence name2) {
        return this.get0(name2);
    }

    @Override
    public CharSequence get(CharSequence name2, CharSequence defaultValue) {
        CharSequence value = this.get(name2);
        return value != null ? value : defaultValue;
    }

    @Override
    public CharSequence getAndRemove(CharSequence name2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public CharSequence getAndRemove(CharSequence name2, CharSequence defaultValue) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public List<CharSequence> getAll(CharSequence name2) {
        int nameHash = AsciiString.hashCode(name2);
        ArrayList<CharSequence> values2 = new ArrayList<CharSequence>();
        int pseudoHeadersEnd = this.pseudoHeaders.length - 1;
        for (int i = 0; i < pseudoHeadersEnd; i += 2) {
            AsciiString roName = this.pseudoHeaders[i];
            if (roName.hashCode() != nameHash || !roName.contentEqualsIgnoreCase(name2)) continue;
            values2.add(this.pseudoHeaders[i + 1]);
        }
        int otherHeadersEnd = this.otherHeaders.length - 1;
        for (int i = 0; i < otherHeadersEnd; i += 2) {
            AsciiString roName = this.otherHeaders[i];
            if (roName.hashCode() != nameHash || !roName.contentEqualsIgnoreCase(name2)) continue;
            values2.add(this.otherHeaders[i + 1]);
        }
        return values2;
    }

    @Override
    public List<CharSequence> getAllAndRemove(CharSequence name2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Boolean getBoolean(CharSequence name2) {
        AsciiString value = this.get0(name2);
        return value != null ? Boolean.valueOf(CharSequenceValueConverter.INSTANCE.convertToBoolean(value)) : null;
    }

    @Override
    public boolean getBoolean(CharSequence name2, boolean defaultValue) {
        Boolean value = this.getBoolean(name2);
        return value != null ? value : defaultValue;
    }

    @Override
    public Byte getByte(CharSequence name2) {
        AsciiString value = this.get0(name2);
        return value != null ? Byte.valueOf(CharSequenceValueConverter.INSTANCE.convertToByte(value)) : null;
    }

    @Override
    public byte getByte(CharSequence name2, byte defaultValue) {
        Byte value = this.getByte(name2);
        return value != null ? value : defaultValue;
    }

    @Override
    public Character getChar(CharSequence name2) {
        AsciiString value = this.get0(name2);
        return value != null ? Character.valueOf(CharSequenceValueConverter.INSTANCE.convertToChar(value)) : null;
    }

    @Override
    public char getChar(CharSequence name2, char defaultValue) {
        Character value = this.getChar(name2);
        return value != null ? value.charValue() : defaultValue;
    }

    @Override
    public Short getShort(CharSequence name2) {
        AsciiString value = this.get0(name2);
        return value != null ? Short.valueOf(CharSequenceValueConverter.INSTANCE.convertToShort(value)) : null;
    }

    @Override
    public short getShort(CharSequence name2, short defaultValue) {
        Short value = this.getShort(name2);
        return value != null ? value : defaultValue;
    }

    @Override
    public Integer getInt(CharSequence name2) {
        AsciiString value = this.get0(name2);
        return value != null ? Integer.valueOf(CharSequenceValueConverter.INSTANCE.convertToInt(value)) : null;
    }

    @Override
    public int getInt(CharSequence name2, int defaultValue) {
        Integer value = this.getInt(name2);
        return value != null ? value : defaultValue;
    }

    @Override
    public Long getLong(CharSequence name2) {
        AsciiString value = this.get0(name2);
        return value != null ? Long.valueOf(CharSequenceValueConverter.INSTANCE.convertToLong(value)) : null;
    }

    @Override
    public long getLong(CharSequence name2, long defaultValue) {
        Long value = this.getLong(name2);
        return value != null ? value : defaultValue;
    }

    @Override
    public Float getFloat(CharSequence name2) {
        AsciiString value = this.get0(name2);
        return value != null ? Float.valueOf(CharSequenceValueConverter.INSTANCE.convertToFloat(value)) : null;
    }

    @Override
    public float getFloat(CharSequence name2, float defaultValue) {
        Float value = this.getFloat(name2);
        return value != null ? value.floatValue() : defaultValue;
    }

    @Override
    public Double getDouble(CharSequence name2) {
        AsciiString value = this.get0(name2);
        return value != null ? Double.valueOf(CharSequenceValueConverter.INSTANCE.convertToDouble(value)) : null;
    }

    @Override
    public double getDouble(CharSequence name2, double defaultValue) {
        Double value = this.getDouble(name2);
        return value != null ? value : defaultValue;
    }

    @Override
    public Long getTimeMillis(CharSequence name2) {
        AsciiString value = this.get0(name2);
        return value != null ? Long.valueOf(CharSequenceValueConverter.INSTANCE.convertToTimeMillis(value)) : null;
    }

    @Override
    public long getTimeMillis(CharSequence name2, long defaultValue) {
        Long value = this.getTimeMillis(name2);
        return value != null ? value : defaultValue;
    }

    @Override
    public Boolean getBooleanAndRemove(CharSequence name2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public boolean getBooleanAndRemove(CharSequence name2, boolean defaultValue) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Byte getByteAndRemove(CharSequence name2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public byte getByteAndRemove(CharSequence name2, byte defaultValue) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Character getCharAndRemove(CharSequence name2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public char getCharAndRemove(CharSequence name2, char defaultValue) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Short getShortAndRemove(CharSequence name2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public short getShortAndRemove(CharSequence name2, short defaultValue) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Integer getIntAndRemove(CharSequence name2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public int getIntAndRemove(CharSequence name2, int defaultValue) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Long getLongAndRemove(CharSequence name2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public long getLongAndRemove(CharSequence name2, long defaultValue) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Float getFloatAndRemove(CharSequence name2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public float getFloatAndRemove(CharSequence name2, float defaultValue) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Double getDoubleAndRemove(CharSequence name2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public double getDoubleAndRemove(CharSequence name2, double defaultValue) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Long getTimeMillisAndRemove(CharSequence name2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public long getTimeMillisAndRemove(CharSequence name2, long defaultValue) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public boolean contains(CharSequence name2) {
        return this.get(name2) != null;
    }

    @Override
    public boolean contains(CharSequence name2, CharSequence value) {
        return this.contains(name2, value, false);
    }

    @Override
    public boolean containsObject(CharSequence name2, Object value) {
        if (value instanceof CharSequence) {
            return this.contains(name2, (CharSequence)value);
        }
        return this.contains(name2, value.toString());
    }

    @Override
    public boolean containsBoolean(CharSequence name2, boolean value) {
        return this.contains(name2, String.valueOf(value));
    }

    @Override
    public boolean containsByte(CharSequence name2, byte value) {
        return this.contains(name2, String.valueOf(value));
    }

    @Override
    public boolean containsChar(CharSequence name2, char value) {
        return this.contains(name2, String.valueOf(value));
    }

    @Override
    public boolean containsShort(CharSequence name2, short value) {
        return this.contains(name2, String.valueOf(value));
    }

    @Override
    public boolean containsInt(CharSequence name2, int value) {
        return this.contains(name2, String.valueOf(value));
    }

    @Override
    public boolean containsLong(CharSequence name2, long value) {
        return this.contains(name2, String.valueOf(value));
    }

    @Override
    public boolean containsFloat(CharSequence name2, float value) {
        return false;
    }

    @Override
    public boolean containsDouble(CharSequence name2, double value) {
        return this.contains(name2, String.valueOf(value));
    }

    @Override
    public boolean containsTimeMillis(CharSequence name2, long value) {
        return this.contains(name2, String.valueOf(value));
    }

    @Override
    public int size() {
        return this.pseudoHeaders.length + this.otherHeaders.length >>> 1;
    }

    @Override
    public boolean isEmpty() {
        return this.pseudoHeaders.length == 0 && this.otherHeaders.length == 0;
    }

    @Override
    public Set<CharSequence> names() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<CharSequence> names = new LinkedHashSet<CharSequence>(this.size());
        int pseudoHeadersEnd = this.pseudoHeaders.length - 1;
        for (int i = 0; i < pseudoHeadersEnd; i += 2) {
            names.add(this.pseudoHeaders[i]);
        }
        int otherHeadersEnd = this.otherHeaders.length - 1;
        for (int i = 0; i < otherHeadersEnd; i += 2) {
            names.add(this.otherHeaders[i]);
        }
        return names;
    }

    @Override
    public Http2Headers add(CharSequence name2, CharSequence value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers add(CharSequence name2, Iterable<? extends CharSequence> values2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers add(CharSequence name2, CharSequence ... values2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addObject(CharSequence name2, Object value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addObject(CharSequence name2, Iterable<?> values2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addObject(CharSequence name2, Object ... values2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addBoolean(CharSequence name2, boolean value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addByte(CharSequence name2, byte value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addChar(CharSequence name2, char value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addShort(CharSequence name2, short value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addInt(CharSequence name2, int value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addLong(CharSequence name2, long value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addFloat(CharSequence name2, float value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addDouble(CharSequence name2, double value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers addTimeMillis(CharSequence name2, long value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers add(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers set(CharSequence name2, CharSequence value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers set(CharSequence name2, Iterable<? extends CharSequence> values2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers set(CharSequence name2, CharSequence ... values2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setObject(CharSequence name2, Object value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setObject(CharSequence name2, Iterable<?> values2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setObject(CharSequence name2, Object ... values2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setBoolean(CharSequence name2, boolean value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setByte(CharSequence name2, byte value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setChar(CharSequence name2, char value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setShort(CharSequence name2, short value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setInt(CharSequence name2, int value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setLong(CharSequence name2, long value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setFloat(CharSequence name2, float value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setDouble(CharSequence name2, double value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setTimeMillis(CharSequence name2, long value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers set(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers setAll(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public boolean remove(CharSequence name2) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers clear() {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iterator() {
        return new ReadOnlyIterator();
    }

    @Override
    public Iterator<CharSequence> valueIterator(CharSequence name2) {
        return new ReadOnlyValueIterator(name2);
    }

    @Override
    public Http2Headers method(CharSequence value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers scheme(CharSequence value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers authority(CharSequence value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers path(CharSequence value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public Http2Headers status(CharSequence value) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public CharSequence method() {
        return this.get(Http2Headers.PseudoHeaderName.METHOD.value());
    }

    @Override
    public CharSequence scheme() {
        return this.get(Http2Headers.PseudoHeaderName.SCHEME.value());
    }

    @Override
    public CharSequence authority() {
        return this.get(Http2Headers.PseudoHeaderName.AUTHORITY.value());
    }

    @Override
    public CharSequence path() {
        return this.get(Http2Headers.PseudoHeaderName.PATH.value());
    }

    @Override
    public CharSequence status() {
        return this.get(Http2Headers.PseudoHeaderName.STATUS.value());
    }

    @Override
    public boolean contains(CharSequence name2, CharSequence value, boolean caseInsensitive) {
        int nameHash = AsciiString.hashCode(name2);
        HashingStrategy<CharSequence> strategy = caseInsensitive ? AsciiString.CASE_INSENSITIVE_HASHER : AsciiString.CASE_SENSITIVE_HASHER;
        int valueHash = strategy.hashCode(value);
        return ReadOnlyHttp2Headers.contains(name2, nameHash, value, valueHash, strategy, this.otherHeaders) || ReadOnlyHttp2Headers.contains(name2, nameHash, value, valueHash, strategy, this.pseudoHeaders);
    }

    private static boolean contains(CharSequence name2, int nameHash, CharSequence value, int valueHash, HashingStrategy<CharSequence> hashingStrategy, AsciiString[] headers) {
        int headersEnd = headers.length - 1;
        for (int i = 0; i < headersEnd; i += 2) {
            AsciiString roName = headers[i];
            AsciiString roValue = headers[i + 1];
            if (roName.hashCode() != nameHash || roValue.hashCode() != valueHash || !roName.contentEqualsIgnoreCase(name2) || !hashingStrategy.equals(roValue, value)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName()).append('[');
        String separator = "";
        for (Map.Entry<CharSequence, CharSequence> entry : this) {
            builder.append(separator);
            builder.append(entry.getKey()).append(": ").append(entry.getValue());
            separator = ", ";
        }
        return builder.append(']').toString();
    }

    private final class ReadOnlyIterator
    implements Map.Entry<CharSequence, CharSequence>,
    Iterator<Map.Entry<CharSequence, CharSequence>> {
        private int i;
        private AsciiString[] current;
        private AsciiString key;
        private AsciiString value;

        private ReadOnlyIterator() {
            this.current = ReadOnlyHttp2Headers.this.pseudoHeaders.length != 0 ? ReadOnlyHttp2Headers.this.pseudoHeaders : ReadOnlyHttp2Headers.this.otherHeaders;
        }

        @Override
        public boolean hasNext() {
            return this.i != this.current.length;
        }

        @Override
        public Map.Entry<CharSequence, CharSequence> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.key = this.current[this.i];
            this.value = this.current[this.i + 1];
            this.i += 2;
            if (this.i == this.current.length && this.current == ReadOnlyHttp2Headers.this.pseudoHeaders) {
                this.current = ReadOnlyHttp2Headers.this.otherHeaders;
                this.i = 0;
            }
            return this;
        }

        @Override
        public CharSequence getKey() {
            return this.key;
        }

        @Override
        public CharSequence getValue() {
            return this.value;
        }

        @Override
        public CharSequence setValue(CharSequence value) {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("read only");
        }

        public String toString() {
            return this.key.toString() + '=' + this.value.toString();
        }
    }

    private final class ReadOnlyValueIterator
    implements Iterator<CharSequence> {
        private int i;
        private final int nameHash;
        private final CharSequence name;
        private AsciiString[] current;
        private AsciiString next;

        ReadOnlyValueIterator(CharSequence name2) {
            this.current = ReadOnlyHttp2Headers.this.pseudoHeaders.length != 0 ? ReadOnlyHttp2Headers.this.pseudoHeaders : ReadOnlyHttp2Headers.this.otherHeaders;
            this.nameHash = AsciiString.hashCode(name2);
            this.name = name2;
            this.calculateNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public CharSequence next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            AsciiString current = this.next;
            this.calculateNext();
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("read only");
        }

        private void calculateNext() {
            while (this.i < this.current.length) {
                AsciiString roName = this.current[this.i];
                if (roName.hashCode() == this.nameHash && roName.contentEqualsIgnoreCase(this.name)) {
                    if (this.i + 1 < this.current.length) {
                        this.next = this.current[this.i + 1];
                        this.i += 2;
                    }
                    return;
                }
                this.i += 2;
            }
            if (this.current == ReadOnlyHttp2Headers.this.pseudoHeaders) {
                this.i = 0;
                this.current = ReadOnlyHttp2Headers.this.otherHeaders;
                this.calculateNext();
            } else {
                this.next = null;
            }
        }
    }
}

