/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.multipart.AbstractMixedHttpData;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.MemoryAttribute;
import java.io.IOException;
import java.nio.charset.Charset;

public class MixedAttribute
extends AbstractMixedHttpData<Attribute>
implements Attribute {
    public MixedAttribute(String name2, long limitSize) {
        this(name2, limitSize, HttpConstants.DEFAULT_CHARSET);
    }

    public MixedAttribute(String name2, long definedSize, long limitSize) {
        this(name2, definedSize, limitSize, HttpConstants.DEFAULT_CHARSET);
    }

    public MixedAttribute(String name2, long limitSize, Charset charset) {
        this(name2, limitSize, charset, DiskAttribute.baseDirectory, DiskAttribute.deleteOnExitTemporaryFile);
    }

    public MixedAttribute(String name2, long limitSize, Charset charset, String baseDir, boolean deleteOnExit) {
        this(name2, 0L, limitSize, charset, baseDir, deleteOnExit);
    }

    public MixedAttribute(String name2, long definedSize, long limitSize, Charset charset) {
        this(name2, definedSize, limitSize, charset, DiskAttribute.baseDirectory, DiskAttribute.deleteOnExitTemporaryFile);
    }

    public MixedAttribute(String name2, long definedSize, long limitSize, Charset charset, String baseDir, boolean deleteOnExit) {
        super(limitSize, baseDir, deleteOnExit, new MemoryAttribute(name2, definedSize, charset));
    }

    public MixedAttribute(String name2, String value, long limitSize) {
        this(name2, value, limitSize, HttpConstants.DEFAULT_CHARSET, DiskAttribute.baseDirectory, DiskFileUpload.deleteOnExitTemporaryFile);
    }

    public MixedAttribute(String name2, String value, long limitSize, Charset charset) {
        this(name2, value, limitSize, charset, DiskAttribute.baseDirectory, DiskFileUpload.deleteOnExitTemporaryFile);
    }

    private static Attribute makeInitialAttributeFromValue(String name2, String value, long limitSize, Charset charset, String baseDir, boolean deleteOnExit) {
        if ((long)value.length() > limitSize) {
            try {
                return new DiskAttribute(name2, value, charset, baseDir, deleteOnExit);
            }
            catch (IOException e2) {
                try {
                    return new MemoryAttribute(name2, value, charset);
                }
                catch (IOException ignore) {
                    throw new IllegalArgumentException(e2);
                }
            }
        }
        try {
            return new MemoryAttribute(name2, value, charset);
        }
        catch (IOException e3) {
            throw new IllegalArgumentException(e3);
        }
    }

    public MixedAttribute(String name2, String value, long limitSize, Charset charset, String baseDir, boolean deleteOnExit) {
        super(limitSize, baseDir, deleteOnExit, MixedAttribute.makeInitialAttributeFromValue(name2, value, limitSize, charset, baseDir, deleteOnExit));
    }

    @Override
    public String getValue() throws IOException {
        return ((Attribute)this.wrapped).getValue();
    }

    @Override
    public void setValue(String value) throws IOException {
        ((Attribute)this.wrapped).setValue(value);
    }

    @Override
    Attribute makeDiskData() {
        DiskAttribute diskAttribute = new DiskAttribute(this.getName(), this.definedLength(), this.baseDir, this.deleteOnExit);
        diskAttribute.setMaxSize(this.getMaxSize());
        return diskAttribute;
    }

    @Override
    public Attribute copy() {
        return (Attribute)super.copy();
    }

    @Override
    public Attribute duplicate() {
        return (Attribute)super.duplicate();
    }

    @Override
    public Attribute replace(ByteBuf content) {
        return (Attribute)super.replace(content);
    }

    @Override
    public Attribute retain() {
        return (Attribute)super.retain();
    }

    @Override
    public Attribute retain(int increment) {
        return (Attribute)super.retain(increment);
    }

    @Override
    public Attribute retainedDuplicate() {
        return (Attribute)super.retainedDuplicate();
    }

    @Override
    public Attribute touch() {
        return (Attribute)super.touch();
    }

    @Override
    public Attribute touch(Object hint) {
        return (Attribute)super.touch(hint);
    }
}

