/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.multipart.AbstractHttpData;
import io.netty.handler.codec.http.multipart.DeleteFileOnExitHook;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;

public abstract class AbstractDiskHttpData
extends AbstractHttpData {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractDiskHttpData.class);
    private File file;
    private boolean isRenamed;
    private FileChannel fileChannel;

    protected AbstractDiskHttpData(String name2, Charset charset, long size) {
        super(name2, charset, size);
    }

    protected abstract String getDiskFilename();

    protected abstract String getPrefix();

    protected abstract String getBaseDirectory();

    protected abstract String getPostfix();

    protected abstract boolean deleteOnExit();

    private File tempFile() throws IOException {
        String diskFilename = this.getDiskFilename();
        String newpostfix = diskFilename != null ? '_' + Integer.toString(diskFilename.hashCode()) : this.getPostfix();
        File tmpFile = this.getBaseDirectory() == null ? PlatformDependent.createTempFile(this.getPrefix(), newpostfix, null) : PlatformDependent.createTempFile(this.getPrefix(), newpostfix, new File(this.getBaseDirectory()));
        if (this.deleteOnExit()) {
            DeleteFileOnExitHook.add(tmpFile.getPath());
        }
        return tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContent(ByteBuf buffer) throws IOException {
        ObjectUtil.checkNotNull(buffer, "buffer");
        try {
            this.size = buffer.readableBytes();
            this.checkSize(this.size);
            if (this.definedSize > 0L && this.definedSize < this.size) {
                throw new IOException("Out of size: " + this.size + " > " + this.definedSize);
            }
            if (this.file == null) {
                this.file = this.tempFile();
            }
            if (buffer.readableBytes() == 0) {
                if (!this.file.createNewFile()) {
                    if (this.file.length() == 0L) {
                        return;
                    }
                    if (!this.file.delete() || !this.file.createNewFile()) {
                        throw new IOException("file exists already: " + this.file);
                    }
                }
                return;
            }
            RandomAccessFile accessFile = new RandomAccessFile(this.file, "rw");
            try {
                accessFile.setLength(0L);
                FileChannel localfileChannel = accessFile.getChannel();
                ByteBuffer byteBuffer = buffer.nioBuffer();
                int written = 0;
                while ((long)written < this.size) {
                    written += localfileChannel.write(byteBuffer);
                }
                buffer.readerIndex(buffer.readerIndex() + written);
                localfileChannel.force(false);
            }
            finally {
                accessFile.close();
            }
            this.setCompleted();
        }
        finally {
            buffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addContent(ByteBuf buffer, boolean last2) throws IOException {
        if (buffer != null) {
            try {
                int written;
                int localsize = buffer.readableBytes();
                this.checkSize(this.size + (long)localsize);
                if (this.definedSize > 0L && this.definedSize < this.size + (long)localsize) {
                    throw new IOException("Out of size: " + (this.size + (long)localsize) + " > " + this.definedSize);
                }
                if (this.file == null) {
                    this.file = this.tempFile();
                }
                if (this.fileChannel == null) {
                    RandomAccessFile accessFile = new RandomAccessFile(this.file, "rw");
                    this.fileChannel = accessFile.getChannel();
                }
                int remaining = localsize;
                long position = this.fileChannel.position();
                int index2 = buffer.readerIndex();
                while (remaining > 0 && (written = buffer.getBytes(index2, this.fileChannel, position, remaining)) >= 0) {
                    remaining -= written;
                    position += (long)written;
                    index2 += written;
                }
                this.fileChannel.position(position);
                buffer.readerIndex(index2);
                this.size += (long)(localsize - remaining);
            }
            finally {
                buffer.release();
            }
        }
        if (last2) {
            if (this.file == null) {
                this.file = this.tempFile();
            }
            if (this.fileChannel == null) {
                RandomAccessFile accessFile = new RandomAccessFile(this.file, "rw");
                this.fileChannel = accessFile.getChannel();
            }
            try {
                this.fileChannel.force(false);
            }
            finally {
                this.fileChannel.close();
            }
            this.fileChannel = null;
            this.setCompleted();
        } else {
            ObjectUtil.checkNotNull(buffer, "buffer");
        }
    }

    @Override
    public void setContent(File file2) throws IOException {
        long size = file2.length();
        this.checkSize(size);
        this.size = size;
        if (this.file != null) {
            this.delete();
        }
        this.file = file2;
        this.isRenamed = true;
        this.setCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContent(InputStream inputStream) throws IOException {
        ObjectUtil.checkNotNull(inputStream, "inputStream");
        if (this.file != null) {
            this.delete();
        }
        this.file = this.tempFile();
        RandomAccessFile accessFile = new RandomAccessFile(this.file, "rw");
        int written = 0;
        try {
            accessFile.setLength(0L);
            FileChannel localfileChannel = accessFile.getChannel();
            byte[] bytes2 = new byte[16384];
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes2);
            int read2 = inputStream.read(bytes2);
            while (read2 > 0) {
                byteBuffer.position(read2).flip();
                this.checkSize(written += localfileChannel.write(byteBuffer));
                byteBuffer.clear();
                read2 = inputStream.read(bytes2);
            }
            localfileChannel.force(false);
        }
        finally {
            accessFile.close();
        }
        this.size = written;
        if (this.definedSize > 0L && this.definedSize < this.size) {
            if (!this.file.delete()) {
                logger.warn("Failed to delete: {}", (Object)this.file);
            }
            this.file = null;
            throw new IOException("Out of size: " + this.size + " > " + this.definedSize);
        }
        this.isRenamed = true;
        this.setCompleted();
    }

    @Override
    public void delete() {
        if (this.fileChannel != null) {
            try {
                this.fileChannel.force(false);
            }
            catch (IOException e2) {
                logger.warn("Failed to force.", e2);
            }
            finally {
                try {
                    this.fileChannel.close();
                }
                catch (IOException e3) {
                    logger.warn("Failed to close a file.", e3);
                }
            }
            this.fileChannel = null;
        }
        if (!this.isRenamed) {
            String filePath = null;
            if (this.file != null && this.file.exists()) {
                filePath = this.file.getPath();
                if (!this.file.delete()) {
                    filePath = null;
                    logger.warn("Failed to delete: {}", (Object)this.file);
                }
            }
            if (this.deleteOnExit() && filePath != null) {
                DeleteFileOnExitHook.remove(filePath);
            }
            this.file = null;
        }
    }

    @Override
    public byte[] get() throws IOException {
        if (this.file == null) {
            return EmptyArrays.EMPTY_BYTES;
        }
        return AbstractDiskHttpData.readFrom(this.file);
    }

    @Override
    public ByteBuf getByteBuf() throws IOException {
        if (this.file == null) {
            return Unpooled.EMPTY_BUFFER;
        }
        byte[] array2 = AbstractDiskHttpData.readFrom(this.file);
        return Unpooled.wrappedBuffer(array2);
    }

    @Override
    public ByteBuf getChunk(int length) throws IOException {
        int read2;
        if (this.file == null || length == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (this.fileChannel == null) {
            RandomAccessFile accessFile = new RandomAccessFile(this.file, "r");
            this.fileChannel = accessFile.getChannel();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(length);
        try {
            int readnow;
            for (read2 = 0; read2 < length; read2 += readnow) {
                readnow = this.fileChannel.read(byteBuffer);
                if (readnow != -1) continue;
                this.fileChannel.close();
                this.fileChannel = null;
                break;
            }
        }
        catch (IOException e2) {
            this.fileChannel.close();
            this.fileChannel = null;
            throw e2;
        }
        if (read2 == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        byteBuffer.flip();
        ByteBuf buffer = Unpooled.wrappedBuffer(byteBuffer);
        buffer.readerIndex(0);
        buffer.writerIndex(read2);
        return buffer;
    }

    @Override
    public String getString() throws IOException {
        return this.getString(HttpConstants.DEFAULT_CHARSET);
    }

    @Override
    public String getString(Charset encoding2) throws IOException {
        if (this.file == null) {
            return "";
        }
        if (encoding2 == null) {
            byte[] array2 = AbstractDiskHttpData.readFrom(this.file);
            return new String(array2, HttpConstants.DEFAULT_CHARSET.name());
        }
        byte[] array3 = AbstractDiskHttpData.readFrom(this.file);
        return new String(array3, encoding2.name());
    }

    @Override
    public boolean isInMemory() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean renameTo(File dest) throws IOException {
        ObjectUtil.checkNotNull(dest, "dest");
        if (this.file == null) {
            throw new IOException("No file defined so cannot be renamed");
        }
        if (!this.file.renameTo(dest)) {
            long position;
            IOException exception = null;
            RandomAccessFile inputAccessFile = null;
            RandomAccessFile outputAccessFile = null;
            long chunkSize = 8196L;
            try {
                inputAccessFile = new RandomAccessFile(this.file, "r");
                outputAccessFile = new RandomAccessFile(dest, "rw");
                FileChannel in = inputAccessFile.getChannel();
                FileChannel out = outputAccessFile.getChannel();
                for (position = 0L; position < this.size; position += in.transferTo(position, chunkSize, out)) {
                    if (chunkSize >= this.size - position) continue;
                    chunkSize = this.size - position;
                }
            }
            catch (IOException e2) {
                exception = e2;
            }
            finally {
                if (inputAccessFile != null) {
                    try {
                        inputAccessFile.close();
                    }
                    catch (IOException e3) {
                        if (exception == null) {
                            exception = e3;
                        }
                        logger.warn("Multiple exceptions detected, the following will be suppressed {}", e3);
                    }
                }
                if (outputAccessFile != null) {
                    try {
                        outputAccessFile.close();
                    }
                    catch (IOException e4) {
                        if (exception == null) {
                            exception = e4;
                        }
                        logger.warn("Multiple exceptions detected, the following will be suppressed {}", e4);
                    }
                }
            }
            if (exception != null) {
                throw exception;
            }
            if (position == this.size) {
                if (!this.file.delete()) {
                    logger.warn("Failed to delete: {}", (Object)this.file);
                }
                this.file = dest;
                this.isRenamed = true;
                return true;
            }
            if (!dest.delete()) {
                logger.warn("Failed to delete: {}", (Object)dest);
            }
            return false;
        }
        this.file = dest;
        this.isRenamed = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFrom(File src) throws IOException {
        long srcsize = src.length();
        if (srcsize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too big to be loaded in memory");
        }
        RandomAccessFile accessFile = new RandomAccessFile(src, "r");
        byte[] array2 = new byte[(int)srcsize];
        try {
            FileChannel fileChannel = accessFile.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.wrap(array2);
            int read2 = 0;
            while ((long)read2 < srcsize) {
                read2 += fileChannel.read(byteBuffer);
            }
        }
        finally {
            accessFile.close();
        }
        return array2;
    }

    @Override
    public File getFile() throws IOException {
        return this.file;
    }

    @Override
    public HttpData touch() {
        return this;
    }

    @Override
    public HttpData touch(Object hint) {
        return this;
    }
}

