/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.CharSequenceValueConverter;
import io.netty.handler.codec.DateFormatter;
import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.DefaultHeadersImpl;
import io.netty.handler.codec.HeadersUtils;
import io.netty.handler.codec.ValueConverter;
import io.netty.handler.codec.http.HttpHeaderValidationUtil;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.util.AsciiString;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultHttpHeaders
extends HttpHeaders {
    static final DefaultHeaders.NameValidator<CharSequence> HttpNameValidator = new DefaultHeaders.NameValidator<CharSequence>(){

        @Override
        public void validateName(CharSequence name2) {
            if (name2 == null || name2.length() == 0) {
                throw new IllegalArgumentException("empty headers are not allowed [" + name2 + ']');
            }
            int index2 = HttpHeaderValidationUtil.validateToken(name2);
            if (index2 != -1) {
                throw new IllegalArgumentException("a header name can only contain \"token\" characters, but found invalid character 0x" + Integer.toHexString(name2.charAt(index2)) + " at index " + index2 + " of header '" + name2 + "'.");
            }
        }
    };
    private final DefaultHeaders<CharSequence, CharSequence, ?> headers;

    public DefaultHttpHeaders() {
        this(true);
    }

    public DefaultHttpHeaders(boolean validate2) {
        this(validate2, DefaultHttpHeaders.nameValidator(validate2));
    }

    protected DefaultHttpHeaders(boolean validate2, DefaultHeaders.NameValidator<CharSequence> nameValidator) {
        this(new DefaultHeadersImpl<CharSequence, CharSequence>(AsciiString.CASE_INSENSITIVE_HASHER, HeaderValueConverter.INSTANCE, nameValidator, 16, DefaultHttpHeaders.valueValidator(validate2)));
    }

    protected DefaultHttpHeaders(DefaultHeaders<CharSequence, CharSequence, ?> headers) {
        this.headers = headers;
    }

    @Override
    public HttpHeaders add(HttpHeaders headers) {
        if (headers instanceof DefaultHttpHeaders) {
            this.headers.add(((DefaultHttpHeaders)headers).headers);
            return this;
        }
        return super.add(headers);
    }

    @Override
    public HttpHeaders set(HttpHeaders headers) {
        if (headers instanceof DefaultHttpHeaders) {
            this.headers.set(((DefaultHttpHeaders)headers).headers);
            return this;
        }
        return super.set(headers);
    }

    @Override
    public HttpHeaders add(String name2, Object value) {
        this.headers.addObject((CharSequence)name2, value);
        return this;
    }

    @Override
    public HttpHeaders add(CharSequence name2, Object value) {
        this.headers.addObject(name2, value);
        return this;
    }

    @Override
    public HttpHeaders add(String name2, Iterable<?> values2) {
        this.headers.addObject((CharSequence)name2, values2);
        return this;
    }

    @Override
    public HttpHeaders add(CharSequence name2, Iterable<?> values2) {
        this.headers.addObject(name2, values2);
        return this;
    }

    @Override
    public HttpHeaders addInt(CharSequence name2, int value) {
        this.headers.addInt(name2, value);
        return this;
    }

    @Override
    public HttpHeaders addShort(CharSequence name2, short value) {
        this.headers.addShort(name2, value);
        return this;
    }

    @Override
    public HttpHeaders remove(String name2) {
        this.headers.remove(name2);
        return this;
    }

    @Override
    public HttpHeaders remove(CharSequence name2) {
        this.headers.remove(name2);
        return this;
    }

    @Override
    public HttpHeaders set(String name2, Object value) {
        this.headers.setObject((CharSequence)name2, value);
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence name2, Object value) {
        this.headers.setObject(name2, value);
        return this;
    }

    @Override
    public HttpHeaders set(String name2, Iterable<?> values2) {
        this.headers.setObject((CharSequence)name2, values2);
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence name2, Iterable<?> values2) {
        this.headers.setObject(name2, values2);
        return this;
    }

    @Override
    public HttpHeaders setInt(CharSequence name2, int value) {
        this.headers.setInt(name2, value);
        return this;
    }

    @Override
    public HttpHeaders setShort(CharSequence name2, short value) {
        this.headers.setShort(name2, value);
        return this;
    }

    @Override
    public HttpHeaders clear() {
        this.headers.clear();
        return this;
    }

    @Override
    public String get(String name2) {
        return this.get((CharSequence)name2);
    }

    @Override
    public String get(CharSequence name2) {
        return HeadersUtils.getAsString(this.headers, name2);
    }

    @Override
    public Integer getInt(CharSequence name2) {
        return this.headers.getInt(name2);
    }

    @Override
    public int getInt(CharSequence name2, int defaultValue) {
        return this.headers.getInt(name2, defaultValue);
    }

    @Override
    public Short getShort(CharSequence name2) {
        return this.headers.getShort(name2);
    }

    @Override
    public short getShort(CharSequence name2, short defaultValue) {
        return this.headers.getShort(name2, defaultValue);
    }

    @Override
    public Long getTimeMillis(CharSequence name2) {
        return this.headers.getTimeMillis(name2);
    }

    @Override
    public long getTimeMillis(CharSequence name2, long defaultValue) {
        return this.headers.getTimeMillis(name2, defaultValue);
    }

    @Override
    public List<String> getAll(String name2) {
        return this.getAll((CharSequence)name2);
    }

    @Override
    public List<String> getAll(CharSequence name2) {
        return HeadersUtils.getAllAsString(this.headers, name2);
    }

    @Override
    public List<Map.Entry<String, String>> entries() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map.Entry<String, String>> entriesConverted = new ArrayList<Map.Entry<String, String>>(this.headers.size());
        for (Map.Entry<String, String> entry : this) {
            entriesConverted.add(entry);
        }
        return entriesConverted;
    }

    @Override
    @Deprecated
    public Iterator<Map.Entry<String, String>> iterator() {
        return HeadersUtils.iteratorAsString(this.headers);
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iteratorCharSequence() {
        return this.headers.iterator();
    }

    @Override
    public Iterator<String> valueStringIterator(CharSequence name2) {
        final Iterator<CharSequence> itr = this.valueCharSequenceIterator(name2);
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public String next() {
                return ((CharSequence)itr.next()).toString();
            }

            @Override
            public void remove() {
                itr.remove();
            }
        };
    }

    public Iterator<CharSequence> valueCharSequenceIterator(CharSequence name2) {
        return this.headers.valueIterator(name2);
    }

    @Override
    public boolean contains(String name2) {
        return this.contains((CharSequence)name2);
    }

    @Override
    public boolean contains(CharSequence name2) {
        return this.headers.contains(name2);
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public boolean contains(String name2, String value, boolean ignoreCase) {
        return this.contains((CharSequence)name2, (CharSequence)value, ignoreCase);
    }

    @Override
    public boolean contains(CharSequence name2, CharSequence value, boolean ignoreCase) {
        return this.headers.contains(name2, value, ignoreCase ? AsciiString.CASE_INSENSITIVE_HASHER : AsciiString.CASE_SENSITIVE_HASHER);
    }

    @Override
    public Set<String> names() {
        return HeadersUtils.namesAsString(this.headers);
    }

    public boolean equals(Object o) {
        return o instanceof DefaultHttpHeaders && this.headers.equals(((DefaultHttpHeaders)o).headers, AsciiString.CASE_SENSITIVE_HASHER);
    }

    public int hashCode() {
        return this.headers.hashCode(AsciiString.CASE_SENSITIVE_HASHER);
    }

    @Override
    public HttpHeaders copy() {
        return new DefaultHttpHeaders(this.headers.copy());
    }

    static ValueConverter<CharSequence> valueConverter() {
        return HeaderValueConverter.INSTANCE;
    }

    static DefaultHeaders.ValueValidator<CharSequence> valueValidator(boolean validate2) {
        return validate2 ? HeaderValueValidator.INSTANCE : DefaultHeaders.ValueValidator.NO_VALIDATION;
    }

    static DefaultHeaders.NameValidator<CharSequence> nameValidator(boolean validate2) {
        return validate2 ? HttpNameValidator : DefaultHeaders.NameValidator.NOT_NULL;
    }

    private static final class HeaderValueValidator
    implements DefaultHeaders.ValueValidator<CharSequence> {
        static final HeaderValueValidator INSTANCE = new HeaderValueValidator();

        private HeaderValueValidator() {
        }

        @Override
        public void validate(CharSequence value) {
            int index2 = HttpHeaderValidationUtil.validateValidHeaderValue(value);
            if (index2 != -1) {
                throw new IllegalArgumentException("a header value contains prohibited character 0x" + Integer.toHexString(value.charAt(index2)) + " at index " + index2 + '.');
            }
        }
    }

    private static class HeaderValueConverter
    extends CharSequenceValueConverter {
        static final HeaderValueConverter INSTANCE = new HeaderValueConverter();

        private HeaderValueConverter() {
        }

        @Override
        public CharSequence convertObject(Object value) {
            if (value instanceof CharSequence) {
                return (CharSequence)value;
            }
            if (value instanceof Date) {
                return DateFormatter.format((Date)value);
            }
            if (value instanceof Calendar) {
                return DateFormatter.format(((Calendar)value).getTime());
            }
            return value.toString();
        }
    }
}

