/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.compression.DecompressionException;

final class FastLz {
    private static final int MAX_DISTANCE = 8191;
    private static final int MAX_FARDISTANCE = 73725;
    private static final int HASH_LOG = 13;
    private static final int HASH_SIZE = 8192;
    private static final int HASH_MASK = 8191;
    private static final int MAX_COPY = 32;
    private static final int MAX_LEN = 264;
    private static final int MIN_RECOMENDED_LENGTH_FOR_LEVEL_2 = 65536;
    static final int MAGIC_NUMBER = 4607066;
    static final byte BLOCK_TYPE_NON_COMPRESSED = 0;
    static final byte BLOCK_TYPE_COMPRESSED = 1;
    static final byte BLOCK_WITHOUT_CHECKSUM = 0;
    static final byte BLOCK_WITH_CHECKSUM = 16;
    static final int OPTIONS_OFFSET = 3;
    static final int CHECKSUM_OFFSET = 4;
    static final int MAX_CHUNK_LENGTH = 65535;
    static final int MIN_LENGTH_TO_COMPRESSION = 32;
    static final int LEVEL_AUTO = 0;
    static final int LEVEL_1 = 1;
    static final int LEVEL_2 = 2;

    static int calculateOutputBufferLength(int inputLength) {
        int outputLength = (int)((double)inputLength * 1.06);
        return Math.max(outputLength, 66);
    }

    static int compress(ByteBuf input2, int inOffset, int inLength, ByteBuf output2, int outOffset, int proposedLevel) {
        int hslot;
        int level = proposedLevel == 0 ? (inLength < 65536 ? 1 : 2) : proposedLevel;
        int ip = 0;
        int ipBound = ip + inLength - 2;
        int ipLimit = ip + inLength - 12;
        int op = 0;
        int[] htab = new int[8192];
        if (inLength < 4) {
            if (inLength != 0) {
                output2.setByte(outOffset + op++, (byte)(inLength - 1));
                ++ipBound;
                while (ip <= ipBound) {
                    output2.setByte(outOffset + op++, input2.getByte(inOffset + ip++));
                }
                return inLength + 1;
            }
            return 0;
        }
        for (hslot = 0; hslot < 8192; ++hslot) {
            htab[hslot] = ip;
        }
        int copy2 = 2;
        output2.setByte(outOffset + op++, 31);
        output2.setByte(outOffset + op++, input2.getByte(inOffset + ip++));
        output2.setByte(outOffset + op++, input2.getByte(inOffset + ip++));
        while (ip < ipLimit) {
            int hval;
            int len;
            long distance2;
            int ref2;
            block38: {
                int anchor;
                block40: {
                    block39: {
                        ref2 = 0;
                        distance2 = 0L;
                        len = 3;
                        anchor = ip;
                        boolean matchLabel = false;
                        if (level == 2 && input2.getByte(inOffset + ip) == input2.getByte(inOffset + ip - 1) && FastLz.readU16(input2, inOffset + ip - 1) == FastLz.readU16(input2, inOffset + ip + 1)) {
                            distance2 = 1L;
                            ip += 3;
                            ref2 = anchor + 2;
                            matchLabel = true;
                        }
                        if (matchLabel) break block38;
                        hslot = hval = FastLz.hashFunction(input2, inOffset + ip);
                        ref2 = htab[hval];
                        distance2 = anchor - ref2;
                        htab[hslot] = anchor;
                        if (distance2 == 0L || (level != 1 ? distance2 >= 73725L : distance2 >= 8191L)) break block39;
                        if (input2.getByte(inOffset + ref2++) == input2.getByte(inOffset + ip++) && input2.getByte(inOffset + ref2++) == input2.getByte(inOffset + ip++) && input2.getByte(inOffset + ref2++) == input2.getByte(inOffset + ip++)) break block40;
                    }
                    output2.setByte(outOffset + op++, input2.getByte(inOffset + anchor++));
                    ip = anchor;
                    if (++copy2 != 32) continue;
                    copy2 = 0;
                    output2.setByte(outOffset + op++, 31);
                    continue;
                }
                if (level == 2 && distance2 >= 8191L) {
                    if (input2.getByte(inOffset + ip++) != input2.getByte(inOffset + ref2++) || input2.getByte(inOffset + ip++) != input2.getByte(inOffset + ref2++)) {
                        output2.setByte(outOffset + op++, input2.getByte(inOffset + anchor++));
                        ip = anchor;
                        if (++copy2 != 32) continue;
                        copy2 = 0;
                        output2.setByte(outOffset + op++, 31);
                        continue;
                    }
                    len += 2;
                }
            }
            if (--distance2 == 0L) {
                byte x = input2.getByte(inOffset + ip - 1);
                for (ip = anchor + len; ip < ipBound && input2.getByte(inOffset + ref2++) == x; ++ip) {
                }
            } else {
                boolean missMatch = false;
                for (int i = 0; i < 8; ++i) {
                    if (input2.getByte(inOffset + ref2++) == input2.getByte(inOffset + ip++)) continue;
                    missMatch = true;
                    break;
                }
                if (!missMatch) {
                    while (ip < ipBound && input2.getByte(inOffset + ref2++) == input2.getByte(inOffset + ip++)) {
                    }
                }
            }
            if (copy2 != 0) {
                output2.setByte(outOffset + op - copy2 - 1, (byte)(copy2 - 1));
            } else {
                --op;
            }
            copy2 = 0;
            if (level == 2) {
                if (distance2 < 8191L) {
                    if (len < 7) {
                        output2.setByte(outOffset + op++, (byte)((long)(len << 5) + (distance2 >>> 8)));
                        output2.setByte(outOffset + op++, (byte)(distance2 & 0xFFL));
                    } else {
                        output2.setByte(outOffset + op++, (byte)(224L + (distance2 >>> 8)));
                        len -= 7;
                        while (len >= 255) {
                            output2.setByte(outOffset + op++, -1);
                            len -= 255;
                        }
                        output2.setByte(outOffset + op++, (byte)len);
                        output2.setByte(outOffset + op++, (byte)(distance2 & 0xFFL));
                    }
                } else if (len < 7) {
                    output2.setByte(outOffset + op++, (byte)((len << 5) + 31));
                    output2.setByte(outOffset + op++, -1);
                    output2.setByte(outOffset + op++, (byte)((distance2 -= 8191L) >>> 8));
                    output2.setByte(outOffset + op++, (byte)(distance2 & 0xFFL));
                } else {
                    distance2 -= 8191L;
                    output2.setByte(outOffset + op++, -1);
                    len -= 7;
                    while (len >= 255) {
                        output2.setByte(outOffset + op++, -1);
                        len -= 255;
                    }
                    output2.setByte(outOffset + op++, (byte)len);
                    output2.setByte(outOffset + op++, -1);
                    output2.setByte(outOffset + op++, (byte)(distance2 >>> 8));
                    output2.setByte(outOffset + op++, (byte)(distance2 & 0xFFL));
                }
            } else {
                if (len > 262) {
                    for (len = (ip -= 3) - anchor; len > 262; len -= 262) {
                        output2.setByte(outOffset + op++, (byte)(224L + (distance2 >>> 8)));
                        output2.setByte(outOffset + op++, -3);
                        output2.setByte(outOffset + op++, (byte)(distance2 & 0xFFL));
                    }
                }
                if (len < 7) {
                    output2.setByte(outOffset + op++, (byte)((long)(len << 5) + (distance2 >>> 8)));
                    output2.setByte(outOffset + op++, (byte)(distance2 & 0xFFL));
                } else {
                    output2.setByte(outOffset + op++, (byte)(224L + (distance2 >>> 8)));
                    output2.setByte(outOffset + op++, (byte)(len - 7));
                    output2.setByte(outOffset + op++, (byte)(distance2 & 0xFFL));
                }
            }
            hval = FastLz.hashFunction(input2, inOffset + ip);
            htab[hval] = ip++;
            hval = FastLz.hashFunction(input2, inOffset + ip);
            htab[hval] = ip++;
            output2.setByte(outOffset + op++, 31);
        }
        ++ipBound;
        while (ip <= ipBound) {
            output2.setByte(outOffset + op++, input2.getByte(inOffset + ip++));
            if (++copy2 != 32) continue;
            copy2 = 0;
            output2.setByte(outOffset + op++, 31);
        }
        if (copy2 != 0) {
            output2.setByte(outOffset + op - copy2 - 1, (byte)(copy2 - 1));
        } else {
            --op;
        }
        if (level == 2) {
            output2.setByte(outOffset, output2.getByte(outOffset) | 0x20);
        }
        return op;
    }

    static int decompress(ByteBuf input2, int inOffset, int inLength, ByteBuf output2, int outOffset, int outLength) {
        int level = (input2.getByte(inOffset) >> 5) + 1;
        if (level != 1 && level != 2) {
            throw new DecompressionException(String.format("invalid level: %d (expected: %d or %d)", level, 1, 2));
        }
        int ip = 0;
        int op = 0;
        long ctrl = input2.getByte(inOffset + ip++) & 0x1F;
        boolean loop2 = true;
        do {
            int ref2 = op;
            long len = ctrl >> 5;
            long ofs = (ctrl & 0x1FL) << 8;
            if (ctrl >= 32L) {
                short code;
                ref2 = (int)((long)ref2 - ofs);
                if (--len == 6L) {
                    if (level == 1) {
                        len += (long)input2.getUnsignedByte(inOffset + ip++);
                    } else {
                        do {
                            code = input2.getUnsignedByte(inOffset + ip++);
                            len += (long)code;
                        } while (code == 255);
                    }
                }
                if (level == 1) {
                    ref2 -= input2.getUnsignedByte(inOffset + ip++);
                } else {
                    code = input2.getUnsignedByte(inOffset + ip++);
                    ref2 -= code;
                    if (code == 255 && ofs == 7936L) {
                        ofs = input2.getUnsignedByte(inOffset + ip++) << 8;
                        ref2 = (int)((long)op - (ofs += (long)input2.getUnsignedByte(inOffset + ip++)) - 8191L);
                    }
                }
                if ((long)op + len + 3L > (long)outLength) {
                    return 0;
                }
                if (ref2 - 1 < 0) {
                    return 0;
                }
                if (ip < inLength) {
                    ctrl = input2.getUnsignedByte(inOffset + ip++);
                } else {
                    loop2 = false;
                }
                if (ref2 == op) {
                    byte b = output2.getByte(outOffset + ref2 - 1);
                    output2.setByte(outOffset + op++, b);
                    output2.setByte(outOffset + op++, b);
                    output2.setByte(outOffset + op++, b);
                    while (len != 0L) {
                        output2.setByte(outOffset + op++, b);
                        --len;
                    }
                } else {
                    int n = op++;
                    int n2 = --ref2;
                    output2.setByte(outOffset + n, output2.getByte(outOffset + n2));
                    int n3 = op++;
                    int n4 = ++ref2;
                    output2.setByte(outOffset + n3, output2.getByte(outOffset + n4));
                    int n5 = op++;
                    int n6 = ++ref2;
                    ++ref2;
                    output2.setByte(outOffset + n5, output2.getByte(outOffset + n6));
                    while (len != 0L) {
                        output2.setByte(outOffset + op++, output2.getByte(outOffset + ref2++));
                        --len;
                    }
                }
            } else {
                if ((long)op + ++ctrl > (long)outLength) {
                    return 0;
                }
                if ((long)ip + ctrl > (long)inLength) {
                    return 0;
                }
                output2.setByte(outOffset + op++, input2.getByte(inOffset + ip++));
                --ctrl;
                while (ctrl != 0L) {
                    output2.setByte(outOffset + op++, input2.getByte(inOffset + ip++));
                    --ctrl;
                }
                boolean bl = loop2 = ip < inLength;
                if (!loop2) continue;
                ctrl = input2.getUnsignedByte(inOffset + ip++);
            }
        } while (loop2);
        return op;
    }

    private static int hashFunction(ByteBuf p, int offset) {
        int v = FastLz.readU16(p, offset);
        v ^= FastLz.readU16(p, offset + 1) ^ v >> 3;
        return v &= 0x1FFF;
    }

    private static int readU16(ByteBuf data2, int offset) {
        if (offset + 1 >= data2.readableBytes()) {
            return data2.getUnsignedByte(offset);
        }
        return data2.getUnsignedByte(offset + 1) << 8 | data2.getUnsignedByte(offset);
    }

    private FastLz() {
    }
}

