/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public final class DatagramSocketAddress
extends InetSocketAddress {
    private static final long serialVersionUID = 3094819287843178401L;
    private final int receivedAmount;
    private final DatagramSocketAddress localAddress;

    DatagramSocketAddress(byte[] addr, int scopeId, int port, int receivedAmount, DatagramSocketAddress local2) throws UnknownHostException {
        super(DatagramSocketAddress.newAddress(addr, scopeId), port);
        this.receivedAmount = receivedAmount;
        this.localAddress = local2;
    }

    public DatagramSocketAddress localAddress() {
        return this.localAddress;
    }

    public int receivedAmount() {
        return this.receivedAmount;
    }

    private static InetAddress newAddress(byte[] bytes2, int scopeId) throws UnknownHostException {
        if (bytes2.length == 4) {
            return InetAddress.getByAddress(bytes2);
        }
        return Inet6Address.getByAddress(null, bytes2, scopeId);
    }
}

