/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.pool;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoop;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.util.Deque;
import java.util.concurrent.Callable;

public class SimpleChannelPool
implements ChannelPool {
    private static final AttributeKey<SimpleChannelPool> POOL_KEY = AttributeKey.newInstance("io.netty.channel.pool.SimpleChannelPool");
    private final Deque<Channel> deque = PlatformDependent.newConcurrentDeque();
    private final ChannelPoolHandler handler;
    private final ChannelHealthChecker healthCheck;
    private final Bootstrap bootstrap;
    private final boolean releaseHealthCheck;
    private final boolean lastRecentUsed;

    public SimpleChannelPool(Bootstrap bootstrap, ChannelPoolHandler handler) {
        this(bootstrap, handler, ChannelHealthChecker.ACTIVE);
    }

    public SimpleChannelPool(Bootstrap bootstrap, ChannelPoolHandler handler, ChannelHealthChecker healthCheck) {
        this(bootstrap, handler, healthCheck, true);
    }

    public SimpleChannelPool(Bootstrap bootstrap, ChannelPoolHandler handler, ChannelHealthChecker healthCheck, boolean releaseHealthCheck) {
        this(bootstrap, handler, healthCheck, releaseHealthCheck, true);
    }

    public SimpleChannelPool(Bootstrap bootstrap, final ChannelPoolHandler handler, ChannelHealthChecker healthCheck, boolean releaseHealthCheck, boolean lastRecentUsed) {
        this.handler = ObjectUtil.checkNotNull(handler, "handler");
        this.healthCheck = ObjectUtil.checkNotNull(healthCheck, "healthCheck");
        this.releaseHealthCheck = releaseHealthCheck;
        this.bootstrap = ObjectUtil.checkNotNull(bootstrap, "bootstrap").clone();
        this.bootstrap.handler(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel ch) throws Exception {
                assert (ch.eventLoop().inEventLoop());
                handler.channelCreated(ch);
            }
        });
        this.lastRecentUsed = lastRecentUsed;
    }

    protected Bootstrap bootstrap() {
        return this.bootstrap;
    }

    protected ChannelPoolHandler handler() {
        return this.handler;
    }

    protected ChannelHealthChecker healthChecker() {
        return this.healthCheck;
    }

    protected boolean releaseHealthCheck() {
        return this.releaseHealthCheck;
    }

    @Override
    public final Future<Channel> acquire() {
        return this.acquire(this.bootstrap.config().group().next().newPromise());
    }

    @Override
    public Future<Channel> acquire(Promise<Channel> promise2) {
        return this.acquireHealthyFromPoolOrNew(ObjectUtil.checkNotNull(promise2, "promise"));
    }

    private Future<Channel> acquireHealthyFromPoolOrNew(final Promise<Channel> promise2) {
        try {
            final Channel ch = this.pollChannel();
            if (ch == null) {
                Bootstrap bs = this.bootstrap.clone();
                bs.attr(POOL_KEY, this);
                ChannelFuture f = this.connectChannel(bs);
                if (f.isDone()) {
                    this.notifyConnect(f, promise2);
                } else {
                    f.addListener(new ChannelFutureListener(){

                        @Override
                        public void operationComplete(ChannelFuture future2) throws Exception {
                            SimpleChannelPool.this.notifyConnect(future2, promise2);
                        }
                    });
                }
            } else {
                EventLoop loop2 = ch.eventLoop();
                if (loop2.inEventLoop()) {
                    this.doHealthCheck(ch, promise2);
                } else {
                    loop2.execute(new Runnable(){

                        @Override
                        public void run() {
                            SimpleChannelPool.this.doHealthCheck(ch, promise2);
                        }
                    });
                }
            }
        }
        catch (Throwable cause) {
            promise2.tryFailure(cause);
        }
        return promise2;
    }

    private void notifyConnect(ChannelFuture future2, Promise<Channel> promise2) {
        Channel channel = null;
        try {
            if (future2.isSuccess()) {
                channel = future2.channel();
                this.handler.channelAcquired(channel);
                if (!promise2.trySuccess(channel)) {
                    this.release(channel);
                }
            } else {
                promise2.tryFailure(future2.cause());
            }
        }
        catch (Throwable cause) {
            this.closeAndFail(channel, cause, promise2);
        }
    }

    private void doHealthCheck(final Channel channel, final Promise<Channel> promise2) {
        try {
            assert (channel.eventLoop().inEventLoop());
            Future<Boolean> f = this.healthCheck.isHealthy(channel);
            if (f.isDone()) {
                this.notifyHealthCheck(f, channel, promise2);
            } else {
                f.addListener((GenericFutureListener<Future<Boolean>>)new FutureListener<Boolean>(){

                    @Override
                    public void operationComplete(Future<Boolean> future2) {
                        SimpleChannelPool.this.notifyHealthCheck(future2, channel, promise2);
                    }
                });
            }
        }
        catch (Throwable cause) {
            this.closeAndFail(channel, cause, promise2);
        }
    }

    private void notifyHealthCheck(Future<Boolean> future2, Channel channel, Promise<Channel> promise2) {
        try {
            assert (channel.eventLoop().inEventLoop());
            if (future2.isSuccess() && future2.getNow().booleanValue()) {
                channel.attr(POOL_KEY).set(this);
                this.handler.channelAcquired(channel);
                promise2.setSuccess(channel);
            } else {
                this.closeChannel(channel);
                this.acquireHealthyFromPoolOrNew(promise2);
            }
        }
        catch (Throwable cause) {
            this.closeAndFail(channel, cause, promise2);
        }
    }

    protected ChannelFuture connectChannel(Bootstrap bs) {
        return bs.connect();
    }

    @Override
    public final Future<Void> release(Channel channel) {
        return this.release(channel, channel.eventLoop().newPromise());
    }

    @Override
    public Future<Void> release(final Channel channel, final Promise<Void> promise2) {
        try {
            ObjectUtil.checkNotNull(channel, "channel");
            ObjectUtil.checkNotNull(promise2, "promise");
            EventLoop loop2 = channel.eventLoop();
            if (loop2.inEventLoop()) {
                this.doReleaseChannel(channel, promise2);
            } else {
                loop2.execute(new Runnable(){

                    @Override
                    public void run() {
                        SimpleChannelPool.this.doReleaseChannel(channel, promise2);
                    }
                });
            }
        }
        catch (Throwable cause) {
            this.closeAndFail(channel, cause, promise2);
        }
        return promise2;
    }

    private void doReleaseChannel(Channel channel, Promise<Void> promise2) {
        try {
            assert (channel.eventLoop().inEventLoop());
            if (channel.attr(POOL_KEY).getAndSet(null) != this) {
                this.closeAndFail(channel, new IllegalArgumentException("Channel " + channel + " was not acquired from this ChannelPool"), promise2);
            } else if (this.releaseHealthCheck) {
                this.doHealthCheckOnRelease(channel, promise2);
            } else {
                this.releaseAndOffer(channel, promise2);
            }
        }
        catch (Throwable cause) {
            this.closeAndFail(channel, cause, promise2);
        }
    }

    private void doHealthCheckOnRelease(final Channel channel, final Promise<Void> promise2) throws Exception {
        final Future<Boolean> f = this.healthCheck.isHealthy(channel);
        if (f.isDone()) {
            this.releaseAndOfferIfHealthy(channel, promise2, f);
        } else {
            f.addListener((GenericFutureListener<Future<Boolean>>)new FutureListener<Boolean>(){

                @Override
                public void operationComplete(Future<Boolean> future2) throws Exception {
                    SimpleChannelPool.this.releaseAndOfferIfHealthy(channel, promise2, f);
                }
            });
        }
    }

    private void releaseAndOfferIfHealthy(Channel channel, Promise<Void> promise2, Future<Boolean> future2) {
        try {
            if (future2.getNow().booleanValue()) {
                this.releaseAndOffer(channel, promise2);
            } else {
                this.handler.channelReleased(channel);
                promise2.setSuccess(null);
            }
        }
        catch (Throwable cause) {
            this.closeAndFail(channel, cause, promise2);
        }
    }

    private void releaseAndOffer(Channel channel, Promise<Void> promise2) throws Exception {
        if (this.offerChannel(channel)) {
            this.handler.channelReleased(channel);
            promise2.setSuccess(null);
        } else {
            this.closeAndFail(channel, new ChannelPoolFullException(), promise2);
        }
    }

    private void closeChannel(Channel channel) throws Exception {
        channel.attr(POOL_KEY).getAndSet(null);
        channel.close();
    }

    private void closeAndFail(Channel channel, Throwable cause, Promise<?> promise2) {
        if (channel != null) {
            try {
                this.closeChannel(channel);
            }
            catch (Throwable t3) {
                promise2.tryFailure(t3);
            }
        }
        promise2.tryFailure(cause);
    }

    protected Channel pollChannel() {
        return this.lastRecentUsed ? this.deque.pollLast() : this.deque.pollFirst();
    }

    protected boolean offerChannel(Channel channel) {
        return this.deque.offer(channel);
    }

    @Override
    public void close() {
        Channel channel;
        while ((channel = this.pollChannel()) != null) {
            channel.close().awaitUninterruptibly();
        }
    }

    public Future<Void> closeAsync() {
        return GlobalEventExecutor.INSTANCE.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SimpleChannelPool.this.close();
                return null;
            }
        });
    }

    private static final class ChannelPoolFullException
    extends IllegalStateException {
        private ChannelPoolFullException() {
            super("ChannelPool full");
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

