/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PoolChunk;
import io.netty.buffer.PoolThreadCache;
import io.netty.buffer.PooledByteBuf;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.buffer.UnsafeDirectSwappedByteBuf;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

final class PooledUnsafeDirectByteBuf
extends PooledByteBuf<ByteBuffer> {
    private static final ObjectPool<PooledUnsafeDirectByteBuf> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<PooledUnsafeDirectByteBuf>(){

        @Override
        public PooledUnsafeDirectByteBuf newObject(ObjectPool.Handle<PooledUnsafeDirectByteBuf> handle2) {
            return new PooledUnsafeDirectByteBuf(handle2, 0);
        }
    });
    private long memoryAddress;

    static PooledUnsafeDirectByteBuf newInstance(int maxCapacity) {
        PooledUnsafeDirectByteBuf buf = RECYCLER.get();
        buf.reuse(maxCapacity);
        return buf;
    }

    private PooledUnsafeDirectByteBuf(ObjectPool.Handle<PooledUnsafeDirectByteBuf> recyclerHandle, int maxCapacity) {
        super(recyclerHandle, maxCapacity);
    }

    @Override
    void init(PoolChunk<ByteBuffer> chunk2, ByteBuffer nioBuffer, long handle2, int offset, int length, int maxLength, PoolThreadCache cache2) {
        super.init(chunk2, nioBuffer, handle2, offset, length, maxLength, cache2);
        this.initMemoryAddress();
    }

    @Override
    void initUnpooled(PoolChunk<ByteBuffer> chunk2, int length) {
        super.initUnpooled(chunk2, length);
        this.initMemoryAddress();
    }

    private void initMemoryAddress() {
        this.memoryAddress = PlatformDependent.directBufferAddress((ByteBuffer)this.memory) + (long)this.offset;
    }

    @Override
    protected ByteBuffer newInternalNioBuffer(ByteBuffer memory) {
        return memory.duplicate();
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    protected byte _getByte(int index2) {
        return UnsafeByteBufUtil.getByte(this.addr(index2));
    }

    @Override
    protected short _getShort(int index2) {
        return UnsafeByteBufUtil.getShort(this.addr(index2));
    }

    @Override
    protected short _getShortLE(int index2) {
        return UnsafeByteBufUtil.getShortLE(this.addr(index2));
    }

    @Override
    protected int _getUnsignedMedium(int index2) {
        return UnsafeByteBufUtil.getUnsignedMedium(this.addr(index2));
    }

    @Override
    protected int _getUnsignedMediumLE(int index2) {
        return UnsafeByteBufUtil.getUnsignedMediumLE(this.addr(index2));
    }

    @Override
    protected int _getInt(int index2) {
        return UnsafeByteBufUtil.getInt(this.addr(index2));
    }

    @Override
    protected int _getIntLE(int index2) {
        return UnsafeByteBufUtil.getIntLE(this.addr(index2));
    }

    @Override
    protected long _getLong(int index2) {
        return UnsafeByteBufUtil.getLong(this.addr(index2));
    }

    @Override
    protected long _getLongLE(int index2) {
        return UnsafeByteBufUtil.getLongLE(this.addr(index2));
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst, int dstIndex, int length) {
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)this, this.addr(index2), index2, dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, byte[] dst, int dstIndex, int length) {
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)this, this.addr(index2), index2, dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuffer dst) {
        UnsafeByteBufUtil.getBytes(this, this.addr(index2), index2, dst);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, OutputStream out, int length) throws IOException {
        UnsafeByteBufUtil.getBytes(this, this.addr(index2), index2, out, length);
        return this;
    }

    @Override
    protected void _setByte(int index2, int value) {
        UnsafeByteBufUtil.setByte(this.addr(index2), (byte)value);
    }

    @Override
    protected void _setShort(int index2, int value) {
        UnsafeByteBufUtil.setShort(this.addr(index2), value);
    }

    @Override
    protected void _setShortLE(int index2, int value) {
        UnsafeByteBufUtil.setShortLE(this.addr(index2), value);
    }

    @Override
    protected void _setMedium(int index2, int value) {
        UnsafeByteBufUtil.setMedium(this.addr(index2), value);
    }

    @Override
    protected void _setMediumLE(int index2, int value) {
        UnsafeByteBufUtil.setMediumLE(this.addr(index2), value);
    }

    @Override
    protected void _setInt(int index2, int value) {
        UnsafeByteBufUtil.setInt(this.addr(index2), value);
    }

    @Override
    protected void _setIntLE(int index2, int value) {
        UnsafeByteBufUtil.setIntLE(this.addr(index2), value);
    }

    @Override
    protected void _setLong(int index2, long value) {
        UnsafeByteBufUtil.setLong(this.addr(index2), value);
    }

    @Override
    protected void _setLongLE(int index2, long value) {
        UnsafeByteBufUtil.setLongLE(this.addr(index2), value);
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuf src, int srcIndex, int length) {
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)this, this.addr(index2), index2, src, srcIndex, length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, byte[] src, int srcIndex, int length) {
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)this, this.addr(index2), index2, src, srcIndex, length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuffer src) {
        UnsafeByteBufUtil.setBytes(this, this.addr(index2), index2, src);
        return this;
    }

    @Override
    public int setBytes(int index2, InputStream in, int length) throws IOException {
        return UnsafeByteBufUtil.setBytes(this, this.addr(index2), index2, in, length);
    }

    @Override
    public ByteBuf copy(int index2, int length) {
        return UnsafeByteBufUtil.copy(this, this.addr(index2), index2, length);
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public boolean hasMemoryAddress() {
        return true;
    }

    @Override
    public long memoryAddress() {
        this.ensureAccessible();
        return this.memoryAddress;
    }

    private long addr(int index2) {
        return this.memoryAddress + (long)index2;
    }

    @Override
    protected SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeDirectSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }

    @Override
    public ByteBuf setZero(int index2, int length) {
        this.checkIndex(index2, length);
        UnsafeByteBufUtil.setZero(this.addr(index2), length);
        return this;
    }

    @Override
    public ByteBuf writeZero(int length) {
        this.ensureWritable(length);
        int wIndex = this.writerIndex;
        UnsafeByteBufUtil.setZero(this.addr(wIndex), length);
        this.writerIndex = wIndex + length;
        return this;
    }
}

