/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

final class LongLongHashMap {
    private static final int MASK_TEMPLATE = -2;
    private int mask;
    private long[] array;
    private int maxProbe;
    private long zeroVal;
    private final long emptyVal;

    LongLongHashMap(long emptyVal) {
        this.emptyVal = emptyVal;
        this.zeroVal = emptyVal;
        int initialSize = 32;
        this.array = new long[initialSize];
        this.mask = initialSize - 1;
        this.computeMaskAndProbe();
    }

    public long put(long key2, long value) {
        if (key2 == 0L) {
            long prev2 = this.zeroVal;
            this.zeroVal = value;
            return prev2;
        }
        while (true) {
            int index2 = this.index(key2);
            for (int i = 0; i < this.maxProbe; ++i) {
                long existing = this.array[index2];
                if (existing == key2 || existing == 0L) {
                    long prev3 = existing == 0L ? this.emptyVal : this.array[index2 + 1];
                    this.array[index2] = key2;
                    this.array[index2 + 1] = value;
                    while (i < this.maxProbe) {
                        if (this.array[index2 = index2 + 2 & this.mask] == key2) {
                            this.array[index2] = 0L;
                            prev3 = this.array[index2 + 1];
                            break;
                        }
                        ++i;
                    }
                    return prev3;
                }
                index2 = index2 + 2 & this.mask;
            }
            this.expand();
        }
    }

    public void remove(long key2) {
        if (key2 == 0L) {
            this.zeroVal = this.emptyVal;
            return;
        }
        int index2 = this.index(key2);
        for (int i = 0; i < this.maxProbe; ++i) {
            long existing = this.array[index2];
            if (existing == key2) {
                this.array[index2] = 0L;
                break;
            }
            index2 = index2 + 2 & this.mask;
        }
    }

    public long get(long key2) {
        if (key2 == 0L) {
            return this.zeroVal;
        }
        int index2 = this.index(key2);
        for (int i = 0; i < this.maxProbe; ++i) {
            long existing = this.array[index2];
            if (existing == key2) {
                return this.array[index2 + 1];
            }
            index2 = index2 + 2 & this.mask;
        }
        return this.emptyVal;
    }

    private int index(long key2) {
        key2 ^= key2 >>> 33;
        key2 *= -49064778989728563L;
        key2 ^= key2 >>> 33;
        key2 *= -4265267296055464877L;
        key2 ^= key2 >>> 33;
        return (int)key2 & this.mask;
    }

    private void expand() {
        long[] prev2 = this.array;
        this.array = new long[prev2.length * 2];
        this.computeMaskAndProbe();
        for (int i = 0; i < prev2.length; i += 2) {
            long key2 = prev2[i];
            if (key2 == 0L) continue;
            long val2 = prev2[i + 1];
            this.put(key2, val2);
        }
    }

    private void computeMaskAndProbe() {
        int length = this.array.length;
        this.mask = length - 1 & 0xFFFFFFFE;
        this.maxProbe = (int)Math.log(length);
    }
}

