/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.txw2;

import com.sun.xml.txw2.Attribute;
import com.sun.xml.txw2.Content;
import com.sun.xml.txw2.ContentVisitor;
import com.sun.xml.txw2.DatatypeWriter;
import com.sun.xml.txw2.NamespaceDecl;
import com.sun.xml.txw2.NamespaceResolver;
import com.sun.xml.txw2.NamespaceSupport;
import com.sun.xml.txw2.StartDocument;
import com.sun.xml.txw2.output.XmlSerializer;
import java.util.HashMap;
import java.util.Map;

public final class Document {
    private final XmlSerializer out;
    private boolean started = false;
    private Content current = null;
    private final Map<Class, DatatypeWriter> datatypeWriters = new HashMap<Class, DatatypeWriter>();
    private int iota = 1;
    private final NamespaceSupport inscopeNamespace = new NamespaceSupport();
    private NamespaceDecl activeNamespaces;
    private final ContentVisitor visitor = new ContentVisitor(){

        @Override
        public void onStartDocument() {
            throw new IllegalStateException();
        }

        @Override
        public void onEndDocument() {
            Document.this.out.endDocument();
        }

        @Override
        public void onEndTag() {
            Document.this.out.endTag();
            Document.this.inscopeNamespace.popContext();
            Document.this.activeNamespaces = null;
        }

        @Override
        public void onPcdata(StringBuilder buffer) {
            if (Document.this.activeNamespaces != null) {
                buffer = Document.this.fixPrefix(buffer);
            }
            Document.this.out.text(buffer);
        }

        @Override
        public void onCdata(StringBuilder buffer) {
            if (Document.this.activeNamespaces != null) {
                buffer = Document.this.fixPrefix(buffer);
            }
            Document.this.out.cdata(buffer);
        }

        @Override
        public void onComment(StringBuilder buffer) {
            if (Document.this.activeNamespaces != null) {
                buffer = Document.this.fixPrefix(buffer);
            }
            Document.this.out.comment(buffer);
        }

        @Override
        public void onStartTag(String nsUri, String localName, Attribute attributes, NamespaceDecl namespaces) {
            assert (nsUri != null);
            assert (localName != null);
            Document.this.activeNamespaces = namespaces;
            if (!Document.this.started) {
                Document.this.started = true;
                Document.this.out.startDocument();
            }
            Document.this.inscopeNamespace.pushContext();
            NamespaceDecl ns2 = namespaces;
            while (ns2 != null) {
                String uri;
                ns2.declared = false;
                if (!(ns2.prefix == null || (uri = Document.this.inscopeNamespace.getURI(ns2.prefix)) != null && uri.equals(ns2.uri))) {
                    Document.this.inscopeNamespace.declarePrefix(ns2.prefix, ns2.uri);
                    ns2.declared = true;
                }
                ns2 = ns2.next;
            }
            ns2 = namespaces;
            while (ns2 != null) {
                if (ns2.prefix == null) {
                    if (Document.this.inscopeNamespace.getURI("").equals(ns2.uri)) {
                        ns2.prefix = "";
                    } else {
                        String p = Document.this.inscopeNamespace.getPrefix(ns2.uri);
                        if (p == null) {
                            do {
                                p = Document.this.newPrefix();
                            } while (Document.this.inscopeNamespace.getURI(p) != null);
                            ns2.declared = true;
                            Document.this.inscopeNamespace.declarePrefix(p, ns2.uri);
                        }
                        ns2.prefix = p;
                    }
                }
                ns2 = ns2.next;
            }
            assert (namespaces.uri.equals(nsUri));
            assert (namespaces.prefix != null) : "a prefix must have been all allocated";
            Document.this.out.beginStartTag(nsUri, localName, namespaces.prefix);
            ns2 = namespaces;
            while (ns2 != null) {
                if (ns2.declared) {
                    Document.this.out.writeXmlns(ns2.prefix, ns2.uri);
                }
                ns2 = ns2.next;
            }
            Attribute a = attributes;
            while (a != null) {
                String prefix = a.nsUri.length() == 0 ? "" : Document.this.inscopeNamespace.getPrefix(a.nsUri);
                Document.this.out.writeAttribute(a.nsUri, a.localName, prefix, Document.this.fixPrefix(a.value));
                a = a.next;
            }
            Document.this.out.endStartTag(nsUri, localName, namespaces.prefix);
        }
    };
    private final StringBuilder prefixSeed = new StringBuilder("ns");
    private int prefixIota = 0;
    static final char MAGIC = '\u0000';

    Document(XmlSerializer out) {
        this.out = out;
        for (DatatypeWriter<?> dw : DatatypeWriter.BUILTIN) {
            this.datatypeWriters.put(dw.getType(), dw);
        }
    }

    void flush() {
        this.out.flush();
    }

    void setFirstContent(Content c) {
        assert (this.current == null);
        this.current = new StartDocument();
        this.current.setNext(this, c);
    }

    public void addDatatypeWriter(DatatypeWriter<?> dw) {
        this.datatypeWriters.put(dw.getType(), dw);
    }

    void run() {
        Content next2;
        while ((next2 = this.current.getNext()) != null && next2.isReadyToCommit()) {
            next2.accept(this.visitor);
            next2.written();
            this.current = next2;
        }
        return;
    }

    void writeValue(Object obj2, NamespaceResolver nsResolver, StringBuilder buf) {
        if (obj2 == null) {
            throw new IllegalArgumentException("argument contains null");
        }
        if (obj2 instanceof Object[]) {
            for (Object o : (Object[])obj2) {
                this.writeValue(o, nsResolver, buf);
            }
            return;
        }
        if (obj2 instanceof Iterable) {
            for (Object o : (Iterable)obj2) {
                this.writeValue(o, nsResolver, buf);
            }
            return;
        }
        if (buf.length() > 0) {
            buf.append(' ');
        }
        for (Class<?> c = obj2.getClass(); c != null; c = c.getSuperclass()) {
            DatatypeWriter dw = this.datatypeWriters.get(c);
            if (dw == null) continue;
            dw.print(obj2, nsResolver, buf);
            return;
        }
        buf.append(obj2);
    }

    private String newPrefix() {
        this.prefixSeed.setLength(2);
        this.prefixSeed.append(++this.prefixIota);
        return this.prefixSeed.toString();
    }

    private StringBuilder fixPrefix(StringBuilder buf) {
        int i;
        assert (this.activeNamespaces != null);
        int len = buf.length();
        for (i = 0; i < len && buf.charAt(i) != '\u0000'; ++i) {
        }
        if (i == len) {
            return buf;
        }
        while (i < len) {
            char uriIdx = buf.charAt(i + 1);
            NamespaceDecl ns2 = this.activeNamespaces;
            while (ns2 != null && ns2.uniqueId != uriIdx) {
                ns2 = ns2.next;
            }
            if (ns2 == null) {
                throw new IllegalStateException("Unexpected use of prefixes " + buf);
            }
            int length = 2;
            String prefix = ns2.prefix;
            if (prefix.length() == 0) {
                if (buf.length() <= i + 2 || buf.charAt(i + 2) != ':') {
                    throw new IllegalStateException("Unexpected use of prefixes " + buf);
                }
                length = 3;
            }
            buf.replace(i, i + length, prefix);
            len += prefix.length() - length;
            while (i < len && buf.charAt(i) != '\u0000') {
                ++i;
            }
        }
        return buf;
    }

    char assignNewId() {
        return (char)this.iota++;
    }
}

