/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.model.nav;

import com.sun.xml.bind.v2.model.nav.GenericArrayTypeImpl;
import com.sun.xml.bind.v2.model.nav.Navigator;
import com.sun.xml.bind.v2.model.nav.ParameterizedTypeImpl;
import com.sun.xml.bind.v2.model.nav.SecureLoader;
import com.sun.xml.bind.v2.model.nav.TypeVisitor;
import com.sun.xml.bind.v2.model.nav.WildcardTypeImpl;
import com.sun.xml.bind.v2.runtime.Location;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;

final class ReflectionNavigator
implements Navigator<Type, Class, Field, Method> {
    private static final ReflectionNavigator INSTANCE = new ReflectionNavigator();
    private static final TypeVisitor<Type, Class> baseClassFinder = new TypeVisitor<Type, Class>(){

        @Override
        public Type onClass(Class c, Class sup) {
            Type r;
            if (sup == c) {
                return sup;
            }
            Type sc = c.getGenericSuperclass();
            if (sc != null && (r = (Type)this.visit(sc, sup)) != null) {
                return r;
            }
            for (Type i : c.getGenericInterfaces()) {
                r = (Type)this.visit(i, sup);
                if (r == null) continue;
                return r;
            }
            return null;
        }

        @Override
        public Type onParameterizdType(ParameterizedType p, Class sup) {
            Class raw = (Class)p.getRawType();
            if (raw == sup) {
                return p;
            }
            Type r = raw.getGenericSuperclass();
            if (r != null) {
                r = (Type)this.visit(this.bind(r, raw, p), sup);
            }
            if (r != null) {
                return r;
            }
            for (Type i : raw.getGenericInterfaces()) {
                r = (Type)this.visit(this.bind(i, raw, p), sup);
                if (r == null) continue;
                return r;
            }
            return null;
        }

        @Override
        public Type onGenericArray(GenericArrayType g2, Class sup) {
            return null;
        }

        @Override
        public Type onVariable(TypeVariable v, Class sup) {
            return (Type)this.visit(v.getBounds()[0], sup);
        }

        @Override
        public Type onWildcard(WildcardType w, Class sup) {
            return null;
        }

        private Type bind(Type t3, GenericDeclaration decl, ParameterizedType args2) {
            return (Type)binder.visit(t3, new BinderArg(decl, args2.getActualTypeArguments()));
        }
    };
    private static final TypeVisitor<Type, BinderArg> binder = new TypeVisitor<Type, BinderArg>(){

        @Override
        public Type onClass(Class c, BinderArg args2) {
            return c;
        }

        @Override
        public Type onParameterizdType(ParameterizedType p, BinderArg args2) {
            Type[] params = p.getActualTypeArguments();
            boolean different = false;
            for (int i = 0; i < params.length; ++i) {
                Type t3 = params[i];
                params[i] = (Type)this.visit(t3, args2);
                different |= t3 != params[i];
            }
            Type newOwner = p.getOwnerType();
            if (newOwner != null) {
                newOwner = (Type)this.visit(newOwner, args2);
            }
            if (!(different |= p.getOwnerType() != newOwner)) {
                return p;
            }
            return new ParameterizedTypeImpl((Class)p.getRawType(), params, newOwner);
        }

        @Override
        public Type onGenericArray(GenericArrayType g2, BinderArg types) {
            Type c = (Type)this.visit(g2.getGenericComponentType(), types);
            if (c == g2.getGenericComponentType()) {
                return g2;
            }
            return new GenericArrayTypeImpl(c);
        }

        @Override
        public Type onVariable(TypeVariable v, BinderArg types) {
            return types.replace(v);
        }

        @Override
        public Type onWildcard(WildcardType w, BinderArg types) {
            Type t3;
            int i;
            Type[] lb = w.getLowerBounds();
            Type[] ub = w.getUpperBounds();
            boolean diff2 = false;
            for (i = 0; i < lb.length; ++i) {
                t3 = lb[i];
                lb[i] = (Type)this.visit(t3, types);
                diff2 |= t3 != lb[i];
            }
            for (i = 0; i < ub.length; ++i) {
                t3 = ub[i];
                ub[i] = (Type)this.visit(t3, types);
                diff2 |= t3 != ub[i];
            }
            if (!diff2) {
                return w;
            }
            return new WildcardTypeImpl(lb, ub);
        }
    };
    private static final TypeVisitor<Class, Void> eraser = new TypeVisitor<Class, Void>(){

        @Override
        public Class onClass(Class c, Void v) {
            return c;
        }

        @Override
        public Class onParameterizdType(ParameterizedType p, Void v) {
            return (Class)this.visit(p.getRawType(), null);
        }

        @Override
        public Class onGenericArray(GenericArrayType g2, Void v) {
            return Array.newInstance((Class)this.visit(g2.getGenericComponentType(), null), 0).getClass();
        }

        @Override
        public Class onVariable(TypeVariable tv, Void v) {
            return (Class)this.visit(tv.getBounds()[0], null);
        }

        @Override
        public Class onWildcard(WildcardType w, Void v) {
            return (Class)this.visit(w.getUpperBounds()[0], null);
        }
    };

    static ReflectionNavigator getInstance() {
        return INSTANCE;
    }

    private ReflectionNavigator() {
    }

    @Override
    public Class getSuperClass(Class clazz) {
        if (clazz == Object.class) {
            return null;
        }
        Class<Object> sc = clazz.getSuperclass();
        if (sc == null) {
            sc = Object.class;
        }
        return sc;
    }

    @Override
    public Type getBaseClass(Type t3, Class sup) {
        return baseClassFinder.visit(t3, sup);
    }

    @Override
    public String getClassName(Class clazz) {
        return clazz.getName();
    }

    @Override
    public String getTypeName(Type type2) {
        if (type2 instanceof Class) {
            Class c = (Class)type2;
            if (c.isArray()) {
                return this.getTypeName(c.getComponentType()) + "[]";
            }
            return c.getName();
        }
        return type2.toString();
    }

    @Override
    public String getClassShortName(Class clazz) {
        return clazz.getSimpleName();
    }

    @Override
    public Collection<? extends Field> getDeclaredFields(final Class clazz) {
        Field[] fields2 = AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                return clazz.getDeclaredFields();
            }
        });
        return Arrays.asList(fields2);
    }

    @Override
    public Field getDeclaredField(final Class clazz, final String fieldName) {
        return AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                try {
                    return clazz.getDeclaredField(fieldName);
                }
                catch (NoSuchFieldException e2) {
                    return null;
                }
            }
        });
    }

    @Override
    public Collection<? extends Method> getDeclaredMethods(final Class clazz) {
        Method[] methods2 = AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clazz.getDeclaredMethods();
            }
        });
        return Arrays.asList(methods2);
    }

    @Override
    public Class getDeclaringClassForField(Field field) {
        return field.getDeclaringClass();
    }

    @Override
    public Class getDeclaringClassForMethod(Method method) {
        return method.getDeclaringClass();
    }

    @Override
    public Type getFieldType(Field field) {
        Class<?> c;
        if (field.getType().isArray() && (c = field.getType().getComponentType()).isPrimitive()) {
            return Array.newInstance(c, 0).getClass();
        }
        return this.fix(field.getGenericType());
    }

    @Override
    public String getFieldName(Field field) {
        return field.getName();
    }

    @Override
    public String getMethodName(Method method) {
        return method.getName();
    }

    @Override
    public Type getReturnType(Method method) {
        return this.fix(method.getGenericReturnType());
    }

    public Type[] getMethodParameters(Method method) {
        return method.getGenericParameterTypes();
    }

    @Override
    public boolean isStaticMethod(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    @Override
    public boolean isFinalMethod(Method method) {
        return Modifier.isFinal(method.getModifiers());
    }

    @Override
    public boolean isSubClassOf(Type sub, Type sup) {
        return this.erasure(sup).isAssignableFrom(this.erasure(sub));
    }

    @Override
    public Class ref(Class c) {
        return c;
    }

    @Override
    public Class use(Class c) {
        return c;
    }

    @Override
    public Class asDecl(Type t3) {
        return this.erasure(t3);
    }

    @Override
    public Class asDecl(Class c) {
        return c;
    }

    @Override
    public <T> Class<T> erasure(Type t3) {
        return eraser.visit(t3, null);
    }

    @Override
    public boolean isAbstract(Class clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    @Override
    public boolean isFinal(Class clazz) {
        return Modifier.isFinal(clazz.getModifiers());
    }

    public Type createParameterizedType(Class rawType, Type ... arguments2) {
        return new ParameterizedTypeImpl(rawType, arguments2, null);
    }

    @Override
    public boolean isArray(Type t3) {
        if (t3 instanceof Class) {
            Class c = (Class)t3;
            return c.isArray();
        }
        return t3 instanceof GenericArrayType;
    }

    @Override
    public boolean isArrayButNotByteArray(Type t3) {
        if (t3 instanceof Class) {
            Class c = (Class)t3;
            return c.isArray() && c != byte[].class;
        }
        if (t3 instanceof GenericArrayType) {
            return (t3 = ((GenericArrayType)t3).getGenericComponentType()) != Byte.TYPE;
        }
        return false;
    }

    @Override
    public Type getComponentType(Type t3) {
        if (t3 instanceof Class) {
            Class c = (Class)t3;
            return c.getComponentType();
        }
        if (t3 instanceof GenericArrayType) {
            return ((GenericArrayType)t3).getGenericComponentType();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Type getTypeArgument(Type type2, int i) {
        if (type2 instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type2;
            return this.fix(p.getActualTypeArguments()[i]);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isParameterizedType(Type type2) {
        return type2 instanceof ParameterizedType;
    }

    @Override
    public boolean isPrimitive(Type type2) {
        if (type2 instanceof Class) {
            Class c = (Class)type2;
            return c.isPrimitive();
        }
        return false;
    }

    @Override
    public Type getPrimitive(Class primitiveType) {
        assert (primitiveType.isPrimitive());
        return primitiveType;
    }

    @Override
    public Location getClassLocation(final Class clazz) {
        return new Location(){

            @Override
            public String toString() {
                return clazz.getName();
            }
        };
    }

    @Override
    public Location getFieldLocation(final Field field) {
        return new Location(){

            @Override
            public String toString() {
                return field.toString();
            }
        };
    }

    @Override
    public Location getMethodLocation(final Method method) {
        return new Location(){

            @Override
            public String toString() {
                return method.toString();
            }
        };
    }

    @Override
    public boolean hasDefaultConstructor(Class c) {
        try {
            c.getDeclaredConstructor(new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e2) {
            return false;
        }
    }

    @Override
    public boolean isStaticField(Field field) {
        return Modifier.isStatic(field.getModifiers());
    }

    @Override
    public boolean isPublicMethod(Method method) {
        return Modifier.isPublic(method.getModifiers());
    }

    @Override
    public boolean isPublicField(Field field) {
        return Modifier.isPublic(field.getModifiers());
    }

    @Override
    public boolean isEnum(Class c) {
        return Enum.class.isAssignableFrom(c);
    }

    public Field[] getEnumConstants(Class clazz) {
        try {
            T[] values2 = clazz.getEnumConstants();
            Field[] fields2 = new Field[values2.length];
            for (int i = 0; i < values2.length; ++i) {
                fields2[i] = clazz.getField(((Enum)values2[i]).name());
            }
            return fields2;
        }
        catch (NoSuchFieldException e2) {
            throw new NoSuchFieldError(e2.getMessage());
        }
    }

    @Override
    public Type getVoidType() {
        return Void.class;
    }

    @Override
    public String getPackageName(Class clazz) {
        String name2 = clazz.getName();
        int idx = name2.lastIndexOf(46);
        if (idx < 0) {
            return "";
        }
        return name2.substring(0, idx);
    }

    @Override
    public Class loadObjectFactory(Class referencePoint, String pkg) {
        ClassLoader cl = SecureLoader.getClassClassLoader(referencePoint);
        if (cl == null) {
            cl = SecureLoader.getSystemClassLoader();
        }
        try {
            return cl.loadClass(pkg + ".ObjectFactory");
        }
        catch (ClassNotFoundException e2) {
            return null;
        }
    }

    @Override
    public boolean isBridgeMethod(Method method) {
        return method.isBridge();
    }

    @Override
    public boolean isOverriding(Method method, final Class base) {
        final String name2 = method.getName();
        final Class[] params = method.getParameterTypes();
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                for (Class clazz = base; clazz != null; clazz = clazz.getSuperclass()) {
                    try {
                        Method m4 = clazz.getDeclaredMethod(name2, params);
                        if (m4 == null) continue;
                        return Boolean.TRUE;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                return Boolean.FALSE;
            }
        });
    }

    @Override
    public boolean isInterface(Class clazz) {
        return clazz.isInterface();
    }

    @Override
    public boolean isTransient(Field f) {
        return Modifier.isTransient(f.getModifiers());
    }

    @Override
    public boolean isInnerClass(Class clazz) {
        return clazz.getEnclosingClass() != null && !Modifier.isStatic(clazz.getModifiers());
    }

    @Override
    public boolean isSameType(Type t12, Type t22) {
        return t12.equals(t22);
    }

    private Type fix(Type t3) {
        if (!(t3 instanceof GenericArrayType)) {
            return t3;
        }
        GenericArrayType gat = (GenericArrayType)t3;
        if (gat.getGenericComponentType() instanceof Class) {
            Class c = (Class)gat.getGenericComponentType();
            return Array.newInstance(c, 0).getClass();
        }
        return t3;
    }

    private static class BinderArg {
        final TypeVariable[] params;
        final Type[] args;

        BinderArg(TypeVariable[] params, Type[] args2) {
            this.params = params;
            this.args = args2;
            assert (params.length == args2.length);
        }

        public BinderArg(GenericDeclaration decl, Type[] args2) {
            this(decl.getTypeParameters(), args2);
        }

        Type replace(TypeVariable v) {
            for (int i = 0; i < this.params.length; ++i) {
                if (!this.params[i].equals(v)) continue;
                return this.args[i];
            }
            return v;
        }
    }
}

