/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.unmarshaller;

import com.sun.xml.bind.unmarshaller.InfosetScanner;
import com.sun.xml.bind.v2.runtime.unmarshaller.LocatorEx;
import java.util.Enumeration;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.helpers.ValidationEventLocatorImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class DOMScanner
implements LocatorEx,
InfosetScanner {
    private Node currentNode = null;
    private final AttributesImpl atts = new AttributesImpl();
    private ContentHandler receiver = null;
    private Locator locator = this;

    public void setLocator(Locator loc) {
        this.locator = loc;
    }

    public void scan(Object node2) throws SAXException {
        if (node2 instanceof Document) {
            this.scan((Document)node2);
        } else {
            this.scan((Element)node2);
        }
    }

    public void scan(Document doc2) throws SAXException {
        this.scan(doc2.getDocumentElement());
    }

    public void scan(Element e2) throws SAXException {
        String prefix;
        this.setCurrentLocation(e2);
        this.receiver.setDocumentLocator(this.locator);
        this.receiver.startDocument();
        NamespaceSupport nss = new NamespaceSupport();
        this.buildNamespaceSupport(nss, e2.getParentNode());
        Enumeration<String> en = nss.getPrefixes();
        while (en.hasMoreElements()) {
            prefix = en.nextElement();
            this.receiver.startPrefixMapping(prefix, nss.getURI(prefix));
        }
        this.visit(e2);
        en = nss.getPrefixes();
        while (en.hasMoreElements()) {
            prefix = en.nextElement();
            this.receiver.endPrefixMapping(prefix);
        }
        this.setCurrentLocation(e2);
        this.receiver.endDocument();
    }

    public void parse(Element e2, ContentHandler handler) throws SAXException {
        this.receiver = handler;
        this.setCurrentLocation(e2);
        this.receiver.startDocument();
        this.receiver.setDocumentLocator(this.locator);
        this.visit(e2);
        this.setCurrentLocation(e2);
        this.receiver.endDocument();
    }

    public void parseWithContext(Element e2, ContentHandler handler) throws SAXException {
        this.setContentHandler(handler);
        this.scan(e2);
    }

    private void buildNamespaceSupport(NamespaceSupport nss, Node node2) {
        if (node2 == null || node2.getNodeType() != 1) {
            return;
        }
        this.buildNamespaceSupport(nss, node2.getParentNode());
        nss.pushContext();
        NamedNodeMap atts = node2.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Attr a = (Attr)atts.item(i);
            if ("xmlns".equals(a.getPrefix())) {
                nss.declarePrefix(a.getLocalName(), a.getValue());
                continue;
            }
            if (!"xmlns".equals(a.getName())) continue;
            nss.declarePrefix("", a.getValue());
        }
    }

    public void visit(Element e2) throws SAXException {
        int i;
        this.setCurrentLocation(e2);
        NamedNodeMap attributes = e2.getAttributes();
        this.atts.clear();
        int len = attributes == null ? 0 : attributes.getLength();
        for (int i2 = len - 1; i2 >= 0; --i2) {
            String local2;
            Attr a = (Attr)attributes.item(i2);
            String name2 = a.getName();
            if (name2.startsWith("xmlns")) {
                if (name2.length() == 5) {
                    this.receiver.startPrefixMapping("", a.getValue());
                    continue;
                }
                String localName = a.getLocalName();
                if (localName == null) {
                    localName = name2.substring(6);
                }
                this.receiver.startPrefixMapping(localName, a.getValue());
                continue;
            }
            String uri = a.getNamespaceURI();
            if (uri == null) {
                uri = "";
            }
            if ((local2 = a.getLocalName()) == null) {
                local2 = a.getName();
            }
            this.atts.addAttribute(uri, local2, a.getName(), "CDATA", a.getValue());
        }
        String uri = e2.getNamespaceURI();
        if (uri == null) {
            uri = "";
        }
        String local3 = e2.getLocalName();
        String qname = e2.getTagName();
        if (local3 == null) {
            local3 = qname;
        }
        this.receiver.startElement(uri, local3, qname, this.atts);
        NodeList children2 = e2.getChildNodes();
        int clen = children2.getLength();
        for (i = 0; i < clen; ++i) {
            this.visit(children2.item(i));
        }
        this.setCurrentLocation(e2);
        this.receiver.endElement(uri, local3, qname);
        for (i = len - 1; i >= 0; --i) {
            Attr a = (Attr)attributes.item(i);
            String name3 = a.getName();
            if (!name3.startsWith("xmlns")) continue;
            if (name3.length() == 5) {
                this.receiver.endPrefixMapping("");
                continue;
            }
            this.receiver.endPrefixMapping(a.getLocalName());
        }
    }

    private void visit(Node n) throws SAXException {
        this.setCurrentLocation(n);
        switch (n.getNodeType()) {
            case 3: 
            case 4: {
                String value = n.getNodeValue();
                this.receiver.characters(value.toCharArray(), 0, value.length());
                break;
            }
            case 1: {
                this.visit((Element)n);
                break;
            }
            case 5: {
                this.receiver.skippedEntity(n.getNodeName());
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)n;
                this.receiver.processingInstruction(pi.getTarget(), pi.getData());
            }
        }
    }

    private void setCurrentLocation(Node currNode) {
        this.currentNode = currNode;
    }

    public Node getCurrentLocation() {
        return this.currentNode;
    }

    public Object getCurrentElement() {
        return this.currentNode;
    }

    @Override
    public LocatorEx getLocator() {
        return this;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.receiver = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.receiver;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public String getSystemId() {
        return null;
    }

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public ValidationEventLocator getLocation() {
        return new ValidationEventLocatorImpl(this.getCurrentLocation());
    }
}

