/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.ParametricNullness;
import com.google.common.util.concurrent.TimeLimiter;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class SimpleTimeLimiter
implements TimeLimiter {
    private final ExecutorService executor;

    private SimpleTimeLimiter(ExecutorService executor) {
        this.executor = Preconditions.checkNotNull(executor);
    }

    public static SimpleTimeLimiter create(ExecutorService executor) {
        return new SimpleTimeLimiter(executor);
    }

    @Override
    public <T> T newProxy(final T target, Class<T> interfaceType, final long timeoutDuration, final TimeUnit timeoutUnit) {
        Preconditions.checkNotNull(target);
        Preconditions.checkNotNull(interfaceType);
        Preconditions.checkNotNull(timeoutUnit);
        SimpleTimeLimiter.checkPositiveTimeout(timeoutDuration);
        Preconditions.checkArgument(interfaceType.isInterface(), "interfaceType must be an interface type");
        final Set<Method> interruptibleMethods = SimpleTimeLimiter.findInterruptibleMethods(interfaceType);
        InvocationHandler handler = new InvocationHandler(){

            @Override
            @CheckForNull
            public Object invoke(Object obj2, Method method, @CheckForNull @Nullable Object[] args2) throws Throwable {
                Callable<@Nullable Object> callable = () -> {
                    try {
                        return method.invoke(target, args2);
                    }
                    catch (InvocationTargetException e2) {
                        throw SimpleTimeLimiter.throwCause(e2, false);
                    }
                };
                return SimpleTimeLimiter.this.callWithTimeout(callable, timeoutDuration, timeoutUnit, interruptibleMethods.contains(method));
            }
        };
        return SimpleTimeLimiter.newProxy(interfaceType, handler);
    }

    private static <T> T newProxy(Class<T> interfaceType, InvocationHandler handler) {
        Object object = Proxy.newProxyInstance(interfaceType.getClassLoader(), new Class[]{interfaceType}, handler);
        return interfaceType.cast(object);
    }

    @ParametricNullness
    private <T> T callWithTimeout(Callable<T> callable, long timeoutDuration, TimeUnit timeoutUnit, boolean amInterruptible) throws Exception {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(timeoutUnit);
        SimpleTimeLimiter.checkPositiveTimeout(timeoutDuration);
        Future<T> future2 = this.executor.submit(callable);
        try {
            if (amInterruptible) {
                try {
                    return future2.get(timeoutDuration, timeoutUnit);
                }
                catch (InterruptedException e2) {
                    future2.cancel(true);
                    throw e2;
                }
            }
            return Uninterruptibles.getUninterruptibly(future2, timeoutDuration, timeoutUnit);
        }
        catch (ExecutionException e3) {
            throw SimpleTimeLimiter.throwCause(e3, true);
        }
        catch (TimeoutException e4) {
            future2.cancel(true);
            throw new UncheckedTimeoutException(e4);
        }
    }

    @Override
    @ParametricNullness
    @CanIgnoreReturnValue
    public <T> T callWithTimeout(Callable<T> callable, long timeoutDuration, TimeUnit timeoutUnit) throws TimeoutException, InterruptedException, ExecutionException {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(timeoutUnit);
        SimpleTimeLimiter.checkPositiveTimeout(timeoutDuration);
        Future<T> future2 = this.executor.submit(callable);
        try {
            return future2.get(timeoutDuration, timeoutUnit);
        }
        catch (InterruptedException | TimeoutException e2) {
            future2.cancel(true);
            throw e2;
        }
        catch (ExecutionException e3) {
            this.wrapAndThrowExecutionExceptionOrError(e3.getCause());
            throw new AssertionError();
        }
    }

    @Override
    @ParametricNullness
    @CanIgnoreReturnValue
    public <T> T callUninterruptiblyWithTimeout(Callable<T> callable, long timeoutDuration, TimeUnit timeoutUnit) throws TimeoutException, ExecutionException {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(timeoutUnit);
        SimpleTimeLimiter.checkPositiveTimeout(timeoutDuration);
        Future<T> future2 = this.executor.submit(callable);
        try {
            return Uninterruptibles.getUninterruptibly(future2, timeoutDuration, timeoutUnit);
        }
        catch (TimeoutException e2) {
            future2.cancel(true);
            throw e2;
        }
        catch (ExecutionException e3) {
            this.wrapAndThrowExecutionExceptionOrError(e3.getCause());
            throw new AssertionError();
        }
    }

    @Override
    public void runWithTimeout(Runnable runnable, long timeoutDuration, TimeUnit timeoutUnit) throws TimeoutException, InterruptedException {
        Preconditions.checkNotNull(runnable);
        Preconditions.checkNotNull(timeoutUnit);
        SimpleTimeLimiter.checkPositiveTimeout(timeoutDuration);
        Future<?> future2 = this.executor.submit(runnable);
        try {
            future2.get(timeoutDuration, timeoutUnit);
        }
        catch (InterruptedException | TimeoutException e2) {
            future2.cancel(true);
            throw e2;
        }
        catch (ExecutionException e3) {
            this.wrapAndThrowRuntimeExecutionExceptionOrError(e3.getCause());
            throw new AssertionError();
        }
    }

    @Override
    public void runUninterruptiblyWithTimeout(Runnable runnable, long timeoutDuration, TimeUnit timeoutUnit) throws TimeoutException {
        Preconditions.checkNotNull(runnable);
        Preconditions.checkNotNull(timeoutUnit);
        SimpleTimeLimiter.checkPositiveTimeout(timeoutDuration);
        Future<?> future2 = this.executor.submit(runnable);
        try {
            Uninterruptibles.getUninterruptibly(future2, timeoutDuration, timeoutUnit);
        }
        catch (TimeoutException e2) {
            future2.cancel(true);
            throw e2;
        }
        catch (ExecutionException e3) {
            this.wrapAndThrowRuntimeExecutionExceptionOrError(e3.getCause());
            throw new AssertionError();
        }
    }

    private static Exception throwCause(Exception e2, boolean combineStackTraces) throws Exception {
        Throwable cause = e2.getCause();
        if (cause == null) {
            throw e2;
        }
        if (combineStackTraces) {
            StackTraceElement[] combined = ObjectArrays.concat(cause.getStackTrace(), e2.getStackTrace(), StackTraceElement.class);
            cause.setStackTrace(combined);
        }
        if (cause instanceof Exception) {
            throw (Exception)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw e2;
    }

    private static Set<Method> findInterruptibleMethods(Class<?> interfaceType) {
        HashSet<Method> set2 = Sets.newHashSet();
        for (Method m4 : interfaceType.getMethods()) {
            if (!SimpleTimeLimiter.declaresInterruptedEx(m4)) continue;
            set2.add(m4);
        }
        return set2;
    }

    private static boolean declaresInterruptedEx(Method method) {
        for (Class<?> exType : method.getExceptionTypes()) {
            if (exType != InterruptedException.class) continue;
            return true;
        }
        return false;
    }

    private void wrapAndThrowExecutionExceptionOrError(Throwable cause) throws ExecutionException {
        if (cause instanceof Error) {
            throw new ExecutionError((Error)cause);
        }
        if (cause instanceof RuntimeException) {
            throw new UncheckedExecutionException(cause);
        }
        throw new ExecutionException(cause);
    }

    private void wrapAndThrowRuntimeExecutionExceptionOrError(Throwable cause) {
        if (cause instanceof Error) {
            throw new ExecutionError((Error)cause);
        }
        throw new UncheckedExecutionException(cause);
    }

    private static void checkPositiveTimeout(long timeoutDuration) {
        Preconditions.checkArgument(timeoutDuration > 0L, "timeout must be positive: %s", timeoutDuration);
    }
}

