/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.primitives.ElementTypesAreNonnullByDefault;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Longs {
    public static final int BYTES = 8;
    public static final long MAX_POWER_OF_TWO = 0x4000000000000000L;

    private Longs() {
    }

    public static int hashCode(long value) {
        return (int)(value ^ value >>> 32);
    }

    public static int compare(long a, long b) {
        return a < b ? -1 : (a > b ? 1 : 0);
    }

    public static boolean contains(long[] array2, long target) {
        for (long value : array2) {
            if (value != target) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(long[] array2, long target) {
        return Longs.indexOf(array2, target, 0, array2.length);
    }

    private static int indexOf(long[] array2, long target, int start2, int end2) {
        for (int i = start2; i < end2; ++i) {
            if (array2[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(long[] array2, long[] target) {
        Preconditions.checkNotNull(array2, "array");
        Preconditions.checkNotNull(target, "target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array2.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array2[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(long[] array2, long target) {
        return Longs.lastIndexOf(array2, target, 0, array2.length);
    }

    private static int lastIndexOf(long[] array2, long target, int start2, int end2) {
        for (int i = end2 - 1; i >= start2; --i) {
            if (array2[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static long min(long ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        long min2 = array2[0];
        for (int i = 1; i < array2.length; ++i) {
            if (array2[i] >= min2) continue;
            min2 = array2[i];
        }
        return min2;
    }

    public static long max(long ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        long max2 = array2[0];
        for (int i = 1; i < array2.length; ++i) {
            if (array2[i] <= max2) continue;
            max2 = array2[i];
        }
        return max2;
    }

    public static long constrainToRange(long value, long min2, long max2) {
        Preconditions.checkArgument(min2 <= max2, "min (%s) must be less than or equal to max (%s)", min2, max2);
        return Math.min(Math.max(value, min2), max2);
    }

    public static long[] concat(long[] ... arrays) {
        int length = 0;
        for (long[] array2 : arrays) {
            length += array2.length;
        }
        long[] result2 = new long[length];
        int pos = 0;
        for (long[] array3 : arrays) {
            System.arraycopy(array3, 0, result2, pos, array3.length);
            pos += array3.length;
        }
        return result2;
    }

    public static byte[] toByteArray(long value) {
        byte[] result2 = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result2[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return result2;
    }

    public static long fromByteArray(byte[] bytes2) {
        Preconditions.checkArgument(bytes2.length >= 8, "array too small: %s < %s", bytes2.length, 8);
        return Longs.fromBytes(bytes2[0], bytes2[1], bytes2[2], bytes2[3], bytes2[4], bytes2[5], bytes2[6], bytes2[7]);
    }

    public static long fromBytes(byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7, byte b8) {
        return ((long)b1 & 0xFFL) << 56 | ((long)b2 & 0xFFL) << 48 | ((long)b3 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b5 & 0xFFL) << 24 | ((long)b6 & 0xFFL) << 16 | ((long)b7 & 0xFFL) << 8 | (long)b8 & 0xFFL;
    }

    @CheckForNull
    public static Long tryParse(String string2) {
        return Longs.tryParse(string2, 10);
    }

    @CheckForNull
    public static Long tryParse(String string2, int radix) {
        int digit;
        int index2;
        if (Preconditions.checkNotNull(string2).isEmpty()) {
            return null;
        }
        if (radix < 2 || radix > 36) {
            throw new IllegalArgumentException("radix must be between MIN_RADIX and MAX_RADIX but was " + radix);
        }
        boolean negative = string2.charAt(0) == '-';
        int n = index2 = negative ? 1 : 0;
        if (index2 == string2.length()) {
            return null;
        }
        if ((digit = AsciiDigits.digit(string2.charAt(index2++))) < 0 || digit >= radix) {
            return null;
        }
        long accum = -digit;
        long cap = Long.MIN_VALUE / (long)radix;
        while (index2 < string2.length()) {
            if ((digit = AsciiDigits.digit(string2.charAt(index2++))) < 0 || digit >= radix || accum < cap) {
                return null;
            }
            if ((accum *= (long)radix) < Long.MIN_VALUE + (long)digit) {
                return null;
            }
            accum -= (long)digit;
        }
        if (negative) {
            return accum;
        }
        if (accum == Long.MIN_VALUE) {
            return null;
        }
        return -accum;
    }

    public static Converter<String, Long> stringConverter() {
        return LongConverter.INSTANCE;
    }

    public static long[] ensureCapacity(long[] array2, int minLength, int padding) {
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        return array2.length < minLength ? Arrays.copyOf(array2, minLength + padding) : array2;
    }

    public static String join(String separator, long ... array2) {
        Preconditions.checkNotNull(separator);
        if (array2.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array2.length * 10);
        builder.append(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            builder.append(separator).append(array2[i]);
        }
        return builder.toString();
    }

    public static Comparator<long[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sortDescending(long[] array2) {
        Preconditions.checkNotNull(array2);
        Longs.sortDescending(array2, 0, array2.length);
    }

    public static void sortDescending(long[] array2, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        Arrays.sort(array2, fromIndex, toIndex);
        Longs.reverse(array2, fromIndex, toIndex);
    }

    public static void reverse(long[] array2) {
        Preconditions.checkNotNull(array2);
        Longs.reverse(array2, 0, array2.length);
    }

    public static void reverse(long[] array2, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        int i = fromIndex;
        for (int j = toIndex - 1; i < j; ++i, --j) {
            long tmp = array2[i];
            array2[i] = array2[j];
            array2[j] = tmp;
        }
    }

    public static void rotate(long[] array2, int distance2) {
        Longs.rotate(array2, distance2, 0, array2.length);
    }

    public static void rotate(long[] array2, int distance2, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        if (array2.length <= 1) {
            return;
        }
        int length = toIndex - fromIndex;
        int m4 = -distance2 % length;
        m4 = m4 < 0 ? m4 + length : m4;
        int newFirstIndex = m4 + fromIndex;
        if (newFirstIndex == fromIndex) {
            return;
        }
        Longs.reverse(array2, fromIndex, newFirstIndex);
        Longs.reverse(array2, newFirstIndex, toIndex);
        Longs.reverse(array2, fromIndex, toIndex);
    }

    public static long[] toArray(Collection<? extends Number> collection2) {
        if (collection2 instanceof LongArrayAsList) {
            return ((LongArrayAsList)collection2).toLongArray();
        }
        Object[] boxedArray = collection2.toArray();
        int len = boxedArray.length;
        long[] array2 = new long[len];
        for (int i = 0; i < len; ++i) {
            array2[i] = ((Number)Preconditions.checkNotNull(boxedArray[i])).longValue();
        }
        return array2;
    }

    public static List<Long> asList(long ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new LongArrayAsList(backingArray);
    }

    @GwtCompatible
    private static class LongArrayAsList
    extends AbstractList<Long>
    implements RandomAccess,
    Serializable {
        final long[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        LongArrayAsList(long[] array2) {
            this(array2, 0, array2.length);
        }

        LongArrayAsList(long[] array2, int start2, int end2) {
            this.array = array2;
            this.start = start2;
            this.end = end2;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Long get(int index2) {
            Preconditions.checkElementIndex(index2, this.size());
            return this.array[this.start + index2];
        }

        public Spliterator.OfLong spliterator() {
            return Spliterators.spliterator(this.array, this.start, this.end, 0);
        }

        @Override
        public boolean contains(@CheckForNull Object target) {
            return target instanceof Long && Longs.indexOf(this.array, (Long)target, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(@CheckForNull Object target) {
            int i;
            if (target instanceof Long && (i = Longs.indexOf(this.array, (Long)target, this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(@CheckForNull Object target) {
            int i;
            if (target instanceof Long && (i = Longs.lastIndexOf(this.array, (Long)target, this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        @Override
        public Long set(int index2, Long element) {
            Preconditions.checkElementIndex(index2, this.size());
            long oldValue = this.array[this.start + index2];
            this.array[this.start + index2] = Preconditions.checkNotNull(element);
            return oldValue;
        }

        @Override
        public List<Long> subList(int fromIndex, int toIndex) {
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, size);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new LongArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        @Override
        public boolean equals(@CheckForNull Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof LongArrayAsList) {
                LongArrayAsList that = (LongArrayAsList)object;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                for (int i = 0; i < size; ++i) {
                    if (this.array[this.start + i] == that.array[that.start + i]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int result2 = 1;
            for (int i = this.start; i < this.end; ++i) {
                result2 = 31 * result2 + Longs.hashCode(this.array[i]);
            }
            return result2;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(this.size() * 10);
            builder.append('[').append(this.array[this.start]);
            for (int i = this.start + 1; i < this.end; ++i) {
                builder.append(", ").append(this.array[i]);
            }
            return builder.append(']').toString();
        }

        long[] toLongArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }
    }

    private static enum LexicographicalComparator implements Comparator<long[]>
    {
        INSTANCE;


        @Override
        public int compare(long[] left2, long[] right2) {
            int minLength = Math.min(left2.length, right2.length);
            for (int i = 0; i < minLength; ++i) {
                int result2 = Longs.compare(left2[i], right2[i]);
                if (result2 == 0) continue;
                return result2;
            }
            return left2.length - right2.length;
        }

        public String toString() {
            return "Longs.lexicographicalComparator()";
        }
    }

    private static final class LongConverter
    extends Converter<String, Long>
    implements Serializable {
        static final LongConverter INSTANCE = new LongConverter();
        private static final long serialVersionUID = 1L;

        private LongConverter() {
        }

        @Override
        protected Long doForward(String value) {
            return Long.decode(value);
        }

        @Override
        protected String doBackward(Long value) {
            return value.toString();
        }

        public String toString() {
            return "Longs.stringConverter()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    static final class AsciiDigits {
        private static final byte[] asciiDigits;

        private AsciiDigits() {
        }

        static int digit(char c) {
            return c < '\u0080' ? asciiDigits[c] : -1;
        }

        static {
            int i;
            byte[] result2 = new byte[128];
            Arrays.fill(result2, (byte)-1);
            for (i = 0; i < 10; ++i) {
                result2[48 + i] = (byte)i;
            }
            for (i = 0; i < 26; ++i) {
                result2[65 + i] = (byte)(10 + i);
                result2[97 + i] = (byte)(10 + i);
            }
            asciiDigits = result2;
        }
    }
}

