/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.NullnessCasts;
import com.google.common.collect.Ordering;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Range;
import java.io.Serializable;
import java.util.Comparator;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
final class GeneralRange<T>
implements Serializable {
    private final Comparator<? super T> comparator;
    private final boolean hasLowerBound;
    @CheckForNull
    private final T lowerEndpoint;
    private final BoundType lowerBoundType;
    private final boolean hasUpperBound;
    @CheckForNull
    private final T upperEndpoint;
    private final BoundType upperBoundType;
    @CheckForNull
    private transient GeneralRange<T> reverse;

    static <T extends Comparable> GeneralRange<T> from(Range<T> range2) {
        T lowerEndpoint = range2.hasLowerBound() ? (T)range2.lowerEndpoint() : null;
        BoundType lowerBoundType = range2.hasLowerBound() ? range2.lowerBoundType() : BoundType.OPEN;
        T upperEndpoint = range2.hasUpperBound() ? (T)range2.upperEndpoint() : null;
        BoundType upperBoundType = range2.hasUpperBound() ? range2.upperBoundType() : BoundType.OPEN;
        return new GeneralRange<Object>(Ordering.natural(), range2.hasLowerBound(), lowerEndpoint, lowerBoundType, range2.hasUpperBound(), upperEndpoint, upperBoundType);
    }

    static <T> GeneralRange<T> all(Comparator<? super T> comparator2) {
        return new GeneralRange<Object>(comparator2, false, null, BoundType.OPEN, false, null, BoundType.OPEN);
    }

    static <T> GeneralRange<T> downTo(Comparator<? super T> comparator2, @ParametricNullness T endpoint, BoundType boundType) {
        return new GeneralRange<Object>((Comparator<Object>)comparator2, true, endpoint, boundType, false, null, BoundType.OPEN);
    }

    static <T> GeneralRange<T> upTo(Comparator<? super T> comparator2, @ParametricNullness T endpoint, BoundType boundType) {
        return new GeneralRange<Object>((Comparator<Object>)comparator2, false, null, BoundType.OPEN, true, endpoint, boundType);
    }

    static <T> GeneralRange<T> range(Comparator<? super T> comparator2, @ParametricNullness T lower, BoundType lowerType, @ParametricNullness T upper, BoundType upperType) {
        return new GeneralRange<T>(comparator2, true, lower, lowerType, true, upper, upperType);
    }

    private GeneralRange(Comparator<? super T> comparator2, boolean hasLowerBound, @CheckForNull T lowerEndpoint, BoundType lowerBoundType, boolean hasUpperBound, @CheckForNull T upperEndpoint, BoundType upperBoundType) {
        int n;
        this.comparator = Preconditions.checkNotNull(comparator2);
        this.hasLowerBound = hasLowerBound;
        this.hasUpperBound = hasUpperBound;
        this.lowerEndpoint = lowerEndpoint;
        this.lowerBoundType = Preconditions.checkNotNull(lowerBoundType);
        this.upperEndpoint = upperEndpoint;
        this.upperBoundType = Preconditions.checkNotNull(upperBoundType);
        if (hasLowerBound) {
            n = comparator2.compare(NullnessCasts.uncheckedCastNullableTToT(lowerEndpoint), NullnessCasts.uncheckedCastNullableTToT(lowerEndpoint));
        }
        if (hasUpperBound) {
            n = comparator2.compare(NullnessCasts.uncheckedCastNullableTToT(upperEndpoint), NullnessCasts.uncheckedCastNullableTToT(upperEndpoint));
        }
        if (hasLowerBound && hasUpperBound) {
            int cmp = comparator2.compare(NullnessCasts.uncheckedCastNullableTToT(lowerEndpoint), NullnessCasts.uncheckedCastNullableTToT(upperEndpoint));
            Preconditions.checkArgument(cmp <= 0, "lowerEndpoint (%s) > upperEndpoint (%s)", lowerEndpoint, upperEndpoint);
            if (cmp == 0) {
                Preconditions.checkArgument(lowerBoundType != BoundType.OPEN || upperBoundType != BoundType.OPEN);
            }
        }
    }

    Comparator<? super T> comparator() {
        return this.comparator;
    }

    boolean hasLowerBound() {
        return this.hasLowerBound;
    }

    boolean hasUpperBound() {
        return this.hasUpperBound;
    }

    boolean isEmpty() {
        return this.hasUpperBound() && this.tooLow(NullnessCasts.uncheckedCastNullableTToT(this.getUpperEndpoint())) || this.hasLowerBound() && this.tooHigh(NullnessCasts.uncheckedCastNullableTToT(this.getLowerEndpoint()));
    }

    boolean tooLow(@ParametricNullness T t3) {
        if (!this.hasLowerBound()) {
            return false;
        }
        T lbound = NullnessCasts.uncheckedCastNullableTToT(this.getLowerEndpoint());
        int cmp = this.comparator.compare(t3, lbound);
        return cmp < 0 | cmp == 0 & this.getLowerBoundType() == BoundType.OPEN;
    }

    boolean tooHigh(@ParametricNullness T t3) {
        if (!this.hasUpperBound()) {
            return false;
        }
        T ubound = NullnessCasts.uncheckedCastNullableTToT(this.getUpperEndpoint());
        int cmp = this.comparator.compare(t3, ubound);
        return cmp > 0 | cmp == 0 & this.getUpperBoundType() == BoundType.OPEN;
    }

    boolean contains(@ParametricNullness T t3) {
        return !this.tooLow(t3) && !this.tooHigh(t3);
    }

    GeneralRange<T> intersect(GeneralRange<T> other) {
        int cmp;
        int cmp2;
        Preconditions.checkNotNull(other);
        Preconditions.checkArgument(this.comparator.equals(other.comparator));
        boolean hasLowBound = this.hasLowerBound;
        T lowEnd = this.getLowerEndpoint();
        BoundType lowType = this.getLowerBoundType();
        if (!this.hasLowerBound()) {
            hasLowBound = other.hasLowerBound;
            lowEnd = other.getLowerEndpoint();
            lowType = other.getLowerBoundType();
        } else if (other.hasLowerBound() && ((cmp2 = this.comparator.compare(this.getLowerEndpoint(), other.getLowerEndpoint())) < 0 || cmp2 == 0 && other.getLowerBoundType() == BoundType.OPEN)) {
            lowEnd = other.getLowerEndpoint();
            lowType = other.getLowerBoundType();
        }
        boolean hasUpBound = this.hasUpperBound;
        T upEnd = this.getUpperEndpoint();
        BoundType upType = this.getUpperBoundType();
        if (!this.hasUpperBound()) {
            hasUpBound = other.hasUpperBound;
            upEnd = other.getUpperEndpoint();
            upType = other.getUpperBoundType();
        } else if (other.hasUpperBound() && ((cmp = this.comparator.compare(this.getUpperEndpoint(), other.getUpperEndpoint())) > 0 || cmp == 0 && other.getUpperBoundType() == BoundType.OPEN)) {
            upEnd = other.getUpperEndpoint();
            upType = other.getUpperBoundType();
        }
        if (hasLowBound && hasUpBound && ((cmp = this.comparator.compare(lowEnd, upEnd)) > 0 || cmp == 0 && lowType == BoundType.OPEN && upType == BoundType.OPEN)) {
            lowEnd = upEnd;
            lowType = BoundType.OPEN;
            upType = BoundType.CLOSED;
        }
        return new GeneralRange<T>(this.comparator, hasLowBound, lowEnd, lowType, hasUpBound, upEnd, upType);
    }

    public boolean equals(@CheckForNull Object obj2) {
        if (obj2 instanceof GeneralRange) {
            GeneralRange r = (GeneralRange)obj2;
            return this.comparator.equals(r.comparator) && this.hasLowerBound == r.hasLowerBound && this.hasUpperBound == r.hasUpperBound && this.getLowerBoundType().equals((Object)r.getLowerBoundType()) && this.getUpperBoundType().equals((Object)r.getUpperBoundType()) && Objects.equal(this.getLowerEndpoint(), r.getLowerEndpoint()) && Objects.equal(this.getUpperEndpoint(), r.getUpperEndpoint());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.comparator, this.getLowerEndpoint(), this.getLowerBoundType(), this.getUpperEndpoint(), this.getUpperBoundType()});
    }

    GeneralRange<T> reverse() {
        GeneralRange<Object> result2 = this.reverse;
        if (result2 == null) {
            result2 = new GeneralRange(Ordering.from(this.comparator).reverse(), this.hasUpperBound, this.getUpperEndpoint(), this.getUpperBoundType(), this.hasLowerBound, this.getLowerEndpoint(), this.getLowerBoundType());
            result2.reverse = this;
            this.reverse = result2;
            return this.reverse;
        }
        return result2;
    }

    public String toString() {
        return this.comparator + ":" + (this.lowerBoundType == BoundType.CLOSED ? (char)'[' : '(') + (this.hasLowerBound ? this.lowerEndpoint : "-\u221e") + ',' + (this.hasUpperBound ? this.upperEndpoint : "\u221e") + (this.upperBoundType == BoundType.CLOSED ? (char)']' : ')');
    }

    @CheckForNull
    T getLowerEndpoint() {
        return this.lowerEndpoint;
    }

    BoundType getLowerBoundType() {
        return this.lowerBoundType;
    }

    @CheckForNull
    T getUpperEndpoint() {
        return this.upperEndpoint;
    }

    BoundType getUpperBoundType() {
        return this.upperBoundType;
    }
}

