/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.AbstractMapBasedMultimap;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.ParametricNullness;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
abstract class AbstractListMultimap<K, V>
extends AbstractMapBasedMultimap<K, V>
implements ListMultimap<K, V> {
    private static final long serialVersionUID = 6588350623831699109L;

    protected AbstractListMultimap(Map<K, Collection<V>> map2) {
        super(map2);
    }

    @Override
    abstract List<V> createCollection();

    @Override
    List<V> createUnmodifiableEmptyCollection() {
        return Collections.emptyList();
    }

    @Override
    <E> Collection<E> unmodifiableCollectionSubclass(Collection<E> collection2) {
        return Collections.unmodifiableList((List)collection2);
    }

    @Override
    Collection<V> wrapCollection(@ParametricNullness K key2, Collection<V> collection2) {
        return this.wrapList(key2, (List)collection2, null);
    }

    @Override
    public List<V> get(@ParametricNullness K key2) {
        return (List)super.get(key2);
    }

    @Override
    @CanIgnoreReturnValue
    public List<V> removeAll(@CheckForNull Object key2) {
        return (List)super.removeAll(key2);
    }

    @Override
    @CanIgnoreReturnValue
    public List<V> replaceValues(@ParametricNullness K key2, Iterable<? extends V> values2) {
        return (List)super.replaceValues(key2, values2);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean put(@ParametricNullness K key2, @ParametricNullness V value) {
        return super.put(key2, value);
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        return super.asMap();
    }

    @Override
    public boolean equals(@CheckForNull Object object) {
        return super.equals(object);
    }
}

