/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.deser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public class LocalTimeDeserializer
extends JSR310DateTimeDeserializerBase<LocalTime> {
    private static final long serialVersionUID = 1L;
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ISO_LOCAL_TIME;
    public static final LocalTimeDeserializer INSTANCE = new LocalTimeDeserializer();

    protected LocalTimeDeserializer() {
        this(DEFAULT_FORMATTER);
    }

    public LocalTimeDeserializer(DateTimeFormatter formatter2) {
        super(LocalTime.class, formatter2);
    }

    protected LocalTimeDeserializer(LocalTimeDeserializer base, Boolean leniency) {
        super(base, leniency);
    }

    protected LocalTimeDeserializer withDateFormat(DateTimeFormatter formatter2) {
        return new LocalTimeDeserializer(formatter2);
    }

    @Override
    protected LocalTimeDeserializer withLeniency(Boolean leniency) {
        return new LocalTimeDeserializer(this, leniency);
    }

    protected LocalTimeDeserializer withShape(JsonFormat.Shape shape) {
        return this;
    }

    @Override
    public LocalTime deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        if (parser.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(parser, context, parser.getText());
        }
        if (parser.isExpectedStartObjectToken()) {
            return this._fromString(parser, context, context.extractScalarFromObject(parser, this, this.handledType()));
        }
        if (parser.isExpectedStartArrayToken()) {
            JsonToken t3 = parser.nextToken();
            if (t3 == JsonToken.END_ARRAY) {
                return null;
            }
            if (context.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS) && (t3 == JsonToken.VALUE_STRING || t3 == JsonToken.VALUE_EMBEDDED_OBJECT)) {
                LocalTime parsed = this.deserialize(parser, context);
                if (parser.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(parser, context);
                }
                return parsed;
            }
            if (t3 == JsonToken.VALUE_NUMBER_INT) {
                LocalTime result2;
                int hour2 = parser.getIntValue();
                parser.nextToken();
                int minute2 = parser.getIntValue();
                t3 = parser.nextToken();
                if (t3 == JsonToken.END_ARRAY) {
                    result2 = LocalTime.of(hour2, minute2);
                } else {
                    int second2 = parser.getIntValue();
                    t3 = parser.nextToken();
                    if (t3 == JsonToken.END_ARRAY) {
                        result2 = LocalTime.of(hour2, minute2, second2);
                    } else {
                        int partialSecond = parser.getIntValue();
                        if (partialSecond < 1000 && !context.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                            partialSecond *= 1000000;
                        }
                        if ((t3 = parser.nextToken()) != JsonToken.END_ARRAY) {
                            throw context.wrongTokenException(parser, this.handledType(), JsonToken.END_ARRAY, "Expected array to end");
                        }
                        result2 = LocalTime.of(hour2, minute2, second2, partialSecond);
                    }
                }
                return result2;
            }
            context.reportInputMismatch(this.handledType(), "Unexpected token (%s) within Array, expected VALUE_NUMBER_INT", new Object[]{t3});
        }
        if (parser.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
            return (LocalTime)parser.getEmbeddedObject();
        }
        if (parser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            this._throwNoNumericTimestampNeedTimeZone(parser, context);
        }
        return (LocalTime)this._handleUnexpectedToken(context, parser, "Expected array or string.", new Object[0]);
    }

    protected LocalTime _fromString(JsonParser p, DeserializationContext ctxt, String string0) throws IOException {
        String string2 = string0.trim();
        if (string2.length() == 0) {
            return (LocalTime)this._fromEmptyString(p, ctxt, string2);
        }
        DateTimeFormatter format2 = this._formatter;
        try {
            if (format2 == DEFAULT_FORMATTER && string2.contains("T")) {
                return LocalTime.parse(string2, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            }
            return LocalTime.parse(string2, format2);
        }
        catch (DateTimeException e2) {
            return (LocalTime)this._handleDateTimeException(ctxt, e2, string2);
        }
    }
}

