/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310;

import com.fasterxml.jackson.core.io.NumberInput;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.function.BiFunction;

public final class DecimalUtils {
    private static final BigDecimal ONE_BILLION = new BigDecimal(1000000000L);

    private DecimalUtils() {
    }

    public static String toDecimal(long seconds2, int nanoseconds) {
        StringBuilder sb = new StringBuilder(20).append(seconds2).append('.');
        if ((long)nanoseconds == 0L) {
            if (seconds2 == 0L) {
                return "0.0";
            }
            sb.append("000000000");
        } else {
            StringBuilder nanoSB = new StringBuilder(9);
            nanoSB.append(nanoseconds);
            int nanosLen = nanoSB.length();
            for (int prepZeroes = 9 - nanosLen; prepZeroes > 0; --prepZeroes) {
                sb.append('0');
            }
            sb.append((CharSequence)nanoSB);
        }
        return sb.toString();
    }

    public static BigDecimal toBigDecimal(long seconds2, int nanoseconds) {
        if ((long)nanoseconds == 0L) {
            if (seconds2 == 0L) {
                return BigDecimal.ZERO.setScale(1);
            }
            return BigDecimal.valueOf(seconds2).setScale(9);
        }
        return NumberInput.parseBigDecimal(DecimalUtils.toDecimal(seconds2, nanoseconds));
    }

    @Deprecated
    public static int extractNanosecondDecimal(BigDecimal value, long integer2) {
        return value.subtract(BigDecimal.valueOf(integer2)).multiply(ONE_BILLION).intValue();
    }

    public static <T> T extractSecondsAndNanos(BigDecimal seconds2, BiFunction<Long, Integer, T> convert) {
        long secondsOnly;
        int nanosOnly;
        BigDecimal nanoseconds = seconds2.scaleByPowerOfTen(9);
        if (nanoseconds.precision() - nanoseconds.scale() <= 0) {
            nanosOnly = 0;
            secondsOnly = 0;
        } else if (seconds2.scale() < -63) {
            nanosOnly = 0;
            secondsOnly = 0;
        } else {
            secondsOnly = seconds2.longValue();
            nanosOnly = nanoseconds.subtract(BigDecimal.valueOf(secondsOnly).scaleByPowerOfTen(9)).intValue();
            if (secondsOnly < 0L && secondsOnly > Instant.MIN.getEpochSecond()) {
                nanosOnly = Math.abs(nanosOnly);
            }
        }
        return convert.apply(secondsOnly, nanosOnly);
    }
}

