/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.IdentityHashMap;

public abstract class StdSerializer<T>
extends JsonSerializer<T>
implements JsonFormatVisitable,
SchemaAware,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Object KEY_CONTENT_CONVERTER_LOCK = new Object();
    protected final Class<T> _handledType;

    protected StdSerializer(Class<T> t3) {
        this._handledType = t3;
    }

    protected StdSerializer(JavaType type2) {
        this._handledType = type2.getRawClass();
    }

    protected StdSerializer(Class<?> t3, boolean dummy) {
        this._handledType = t3;
    }

    protected StdSerializer(StdSerializer<?> src) {
        this._handledType = src._handledType;
    }

    @Override
    public Class<T> handledType() {
        return this._handledType;
    }

    @Override
    public abstract void serialize(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException;

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
        visitor2.expectAnyFormat(typeHint);
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider2, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("string");
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider2, Type typeHint, boolean isOptional) throws JsonMappingException {
        ObjectNode schema2 = (ObjectNode)this.getSchema(provider2, typeHint);
        if (!isOptional) {
            schema2.put("required", !isOptional);
        }
        return schema2;
    }

    protected ObjectNode createSchemaNode(String type2) {
        ObjectNode schema2 = JsonNodeFactory.instance.objectNode();
        schema2.put("type", type2);
        return schema2;
    }

    protected ObjectNode createSchemaNode(String type2, boolean isOptional) {
        ObjectNode schema2 = this.createSchemaNode(type2);
        if (!isOptional) {
            schema2.put("required", !isOptional);
        }
        return schema2;
    }

    protected void visitStringFormat(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
        visitor2.expectStringFormat(typeHint);
    }

    protected void visitStringFormat(JsonFormatVisitorWrapper visitor2, JavaType typeHint, JsonValueFormat format2) throws JsonMappingException {
        JsonStringFormatVisitor v2 = visitor2.expectStringFormat(typeHint);
        if (v2 != null) {
            v2.format(format2);
        }
    }

    protected void visitIntFormat(JsonFormatVisitorWrapper visitor2, JavaType typeHint, JsonParser.NumberType numberType) throws JsonMappingException {
        JsonIntegerFormatVisitor v2 = visitor2.expectIntegerFormat(typeHint);
        if (StdSerializer._neitherNull(v2, (Object)numberType)) {
            v2.numberType(numberType);
        }
    }

    protected void visitIntFormat(JsonFormatVisitorWrapper visitor2, JavaType typeHint, JsonParser.NumberType numberType, JsonValueFormat format2) throws JsonMappingException {
        JsonIntegerFormatVisitor v2 = visitor2.expectIntegerFormat(typeHint);
        if (v2 != null) {
            if (numberType != null) {
                v2.numberType(numberType);
            }
            if (format2 != null) {
                v2.format(format2);
            }
        }
    }

    protected void visitFloatFormat(JsonFormatVisitorWrapper visitor2, JavaType typeHint, JsonParser.NumberType numberType) throws JsonMappingException {
        JsonNumberFormatVisitor v2 = visitor2.expectNumberFormat(typeHint);
        if (v2 != null) {
            v2.numberType(numberType);
        }
    }

    protected void visitArrayFormat(JsonFormatVisitorWrapper visitor2, JavaType typeHint, JsonSerializer<?> itemSerializer, JavaType itemType) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor2.expectArrayFormat(typeHint);
        if (StdSerializer._neitherNull(v2, itemSerializer)) {
            v2.itemsFormat(itemSerializer, itemType);
        }
    }

    protected void visitArrayFormat(JsonFormatVisitorWrapper visitor2, JavaType typeHint, JsonFormatTypes itemType) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor2.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(itemType);
        }
    }

    public void wrapAndThrow(SerializerProvider provider2, Throwable t3, Object bean2, String fieldName) throws IOException {
        boolean wrap;
        while (t3 instanceof InvocationTargetException && t3.getCause() != null) {
            t3 = t3.getCause();
        }
        ClassUtil.throwIfError(t3);
        boolean bl = wrap = provider2 == null || provider2.isEnabled(SerializationFeature.WRAP_EXCEPTIONS);
        if (t3 instanceof IOException) {
            if (!wrap || !(t3 instanceof JacksonException)) {
                throw (IOException)t3;
            }
        } else if (!wrap) {
            ClassUtil.throwIfRTE(t3);
        }
        throw JsonMappingException.wrapWithPath(t3, bean2, fieldName);
    }

    public void wrapAndThrow(SerializerProvider provider2, Throwable t3, Object bean2, int index2) throws IOException {
        boolean wrap;
        while (t3 instanceof InvocationTargetException && t3.getCause() != null) {
            t3 = t3.getCause();
        }
        ClassUtil.throwIfError(t3);
        boolean bl = wrap = provider2 == null || provider2.isEnabled(SerializationFeature.WRAP_EXCEPTIONS);
        if (t3 instanceof IOException) {
            if (!wrap || !(t3 instanceof JacksonException)) {
                throw (IOException)t3;
            }
        } else if (!wrap) {
            ClassUtil.throwIfRTE(t3);
        }
        throw JsonMappingException.wrapWithPath(t3, bean2, index2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonSerializer<?> findContextualConvertingSerializer(SerializerProvider provider2, BeanProperty property, JsonSerializer<?> existingSerializer) throws JsonMappingException {
        IdentityHashMap<BeanProperty, Boolean> conversions = (IdentityHashMap<BeanProperty, Boolean>)provider2.getAttribute(KEY_CONTENT_CONVERTER_LOCK);
        if (conversions != null) {
            Object lock = conversions.get(property);
            if (lock != null) {
                return existingSerializer;
            }
        } else {
            conversions = new IdentityHashMap<BeanProperty, Boolean>();
            provider2.setAttribute(KEY_CONTENT_CONVERTER_LOCK, conversions);
        }
        conversions.put(property, Boolean.TRUE);
        try {
            JsonSerializer<?> ser = this.findConvertingContentSerializer(provider2, property, existingSerializer);
            if (ser != null) {
                JsonSerializer<?> jsonSerializer = provider2.handleSecondaryContextualization(ser, property);
                return jsonSerializer;
            }
        }
        finally {
            conversions.remove(property);
        }
        return existingSerializer;
    }

    @Deprecated
    protected JsonSerializer<?> findConvertingContentSerializer(SerializerProvider provider2, BeanProperty prop, JsonSerializer<?> existingSerializer) throws JsonMappingException {
        Object convDef;
        AnnotatedMember m4;
        AnnotationIntrospector intr = provider2.getAnnotationIntrospector();
        if (StdSerializer._neitherNull(intr, prop) && (m4 = prop.getMember()) != null && (convDef = intr.findSerializationContentConverter(m4)) != null) {
            Converter<Object, Object> conv = provider2.converterInstance(prop.getMember(), convDef);
            JavaType delegateType = conv.getOutputType(provider2.getTypeFactory());
            if (existingSerializer == null && !delegateType.isJavaLangObject()) {
                existingSerializer = provider2.findValueSerializer(delegateType);
            }
            return new StdDelegatingSerializer(conv, delegateType, existingSerializer);
        }
        return existingSerializer;
    }

    protected PropertyFilter findPropertyFilter(SerializerProvider provider2, Object filterId, Object valueToFilter) throws JsonMappingException {
        FilterProvider filters = provider2.getFilterProvider();
        if (filters == null) {
            return (PropertyFilter)provider2.reportBadDefinition(this.handledType(), "Cannot resolve PropertyFilter with id '" + filterId + "'; no FilterProvider configured");
        }
        return filters.findPropertyFilter(filterId, valueToFilter);
    }

    protected JsonFormat.Value findFormatOverrides(SerializerProvider provider2, BeanProperty prop, Class<?> typeForDefaults) {
        if (prop != null) {
            return prop.findPropertyFormat(provider2.getConfig(), typeForDefaults);
        }
        return provider2.getDefaultPropertyFormat(typeForDefaults);
    }

    protected Boolean findFormatFeature(SerializerProvider provider2, BeanProperty prop, Class<?> typeForDefaults, JsonFormat.Feature feat) {
        JsonFormat.Value format2 = this.findFormatOverrides(provider2, prop, typeForDefaults);
        if (format2 != null) {
            return format2.getFeature(feat);
        }
        return null;
    }

    protected JsonInclude.Value findIncludeOverrides(SerializerProvider provider2, BeanProperty prop, Class<?> typeForDefaults) {
        if (prop != null) {
            return prop.findPropertyInclusion(provider2.getConfig(), typeForDefaults);
        }
        return provider2.getDefaultPropertyInclusion(typeForDefaults);
    }

    protected JsonSerializer<?> findAnnotatedContentSerializer(SerializerProvider serializers, BeanProperty property) throws JsonMappingException {
        if (property != null) {
            Object serDef;
            AnnotatedMember m4 = property.getMember();
            AnnotationIntrospector intr = serializers.getAnnotationIntrospector();
            if (m4 != null && (serDef = intr.findContentSerializer(m4)) != null) {
                return serializers.serializerInstance(m4, serDef);
            }
        }
        return null;
    }

    protected boolean isDefaultSerializer(JsonSerializer<?> serializer) {
        return ClassUtil.isJacksonStdImpl(serializer);
    }

    protected static final boolean _neitherNull(Object a, Object b) {
        return a != null && b != null;
    }

    protected static final boolean _nonEmpty(Collection<?> c) {
        return c != null && !c.isEmpty();
    }
}

