/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public final class BooleanSerializer
extends StdScalarSerializer<Object>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    protected final boolean _forPrimitive;

    public BooleanSerializer(boolean forPrimitive) {
        super(forPrimitive ? Boolean.TYPE : Boolean.class, false);
        this._forPrimitive = forPrimitive;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializers, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format2 = this.findFormatOverrides(serializers, property, this.handledType());
        if (format2 != null) {
            JsonFormat.Shape shape = format2.getShape();
            if (shape.isNumeric()) {
                return new AsNumber(this._forPrimitive);
            }
            if (shape == JsonFormat.Shape.STRING) {
                return new ToStringSerializer((Class<?>)this._handledType);
            }
        }
        return this;
    }

    @Override
    public void serialize(Object value, JsonGenerator g2, SerializerProvider provider2) throws IOException {
        g2.writeBoolean(Boolean.TRUE.equals(value));
    }

    @Override
    public final void serializeWithType(Object value, JsonGenerator g2, SerializerProvider provider2, TypeSerializer typeSer) throws IOException {
        g2.writeBoolean(Boolean.TRUE.equals(value));
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider2, Type typeHint) {
        return this.createSchemaNode("boolean", !this._forPrimitive);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
        visitor2.expectBooleanFormat(typeHint);
    }

    static final class AsNumber
    extends StdScalarSerializer<Object>
    implements ContextualSerializer {
        private static final long serialVersionUID = 1L;
        protected final boolean _forPrimitive;

        public AsNumber(boolean forPrimitive) {
            super(forPrimitive ? Boolean.TYPE : Boolean.class, false);
            this._forPrimitive = forPrimitive;
        }

        @Override
        public void serialize(Object value, JsonGenerator g2, SerializerProvider provider2) throws IOException {
            g2.writeNumber(Boolean.FALSE.equals(value) ? 0 : 1);
        }

        @Override
        public final void serializeWithType(Object value, JsonGenerator g2, SerializerProvider provider2, TypeSerializer typeSer) throws IOException {
            g2.writeBoolean(Boolean.TRUE.equals(value));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
            this.visitIntFormat(visitor2, typeHint, JsonParser.NumberType.INT);
        }

        @Override
        public JsonSerializer<?> createContextual(SerializerProvider serializers, BeanProperty property) throws JsonMappingException {
            JsonFormat.Shape shape;
            JsonFormat.Value format2 = this.findFormatOverrides(serializers, property, Boolean.class);
            if (format2 != null && !(shape = format2.getShape()).isNumeric()) {
                return new BooleanSerializer(this._forPrimitive);
            }
            return this;
        }
    }
}

