/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.RawValue;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ArrayNode
extends ContainerNode<ArrayNode>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<JsonNode> _children;

    public ArrayNode(JsonNodeFactory nf) {
        super(nf);
        this._children = new ArrayList<JsonNode>();
    }

    public ArrayNode(JsonNodeFactory nf, int capacity) {
        super(nf);
        this._children = new ArrayList<JsonNode>(capacity);
    }

    public ArrayNode(JsonNodeFactory nf, List<JsonNode> children2) {
        super(nf);
        this._children = children2;
    }

    @Override
    protected JsonNode _at(JsonPointer ptr) {
        return this.get(ptr.getMatchingIndex());
    }

    public ArrayNode deepCopy() {
        ArrayNode ret = new ArrayNode(this._nodeFactory);
        for (JsonNode element : this._children) {
            ret._children.add((JsonNode)element.deepCopy());
        }
        return ret;
    }

    @Deprecated
    public ObjectNode with(String exprOrProperty) {
        JsonPointer ptr = this._jsonPointerIfValid(exprOrProperty);
        if (ptr != null) {
            return this.withObject(ptr);
        }
        return (ObjectNode)super.with(exprOrProperty);
    }

    public ArrayNode withArray(String exprOrProperty) {
        JsonPointer ptr = this._jsonPointerIfValid(exprOrProperty);
        if (ptr != null) {
            return this.withArray(ptr);
        }
        return (ArrayNode)super.withArray(exprOrProperty);
    }

    @Override
    protected ObjectNode _withObject(JsonPointer origPtr, JsonPointer currentPtr, JsonNode.OverwriteMode overwriteMode, boolean preferIndex) {
        if (currentPtr.matches()) {
            return null;
        }
        JsonNode n = this._at(currentPtr);
        if (n != null && n instanceof BaseJsonNode) {
            ObjectNode found = ((BaseJsonNode)n)._withObject(origPtr, currentPtr.tail(), overwriteMode, preferIndex);
            if (found != null) {
                return found;
            }
            this._withXxxVerifyReplace(origPtr, currentPtr, overwriteMode, preferIndex, n);
        }
        return this._withObjectAddTailElement(currentPtr, preferIndex);
    }

    @Override
    protected ArrayNode _withArray(JsonPointer origPtr, JsonPointer currentPtr, JsonNode.OverwriteMode overwriteMode, boolean preferIndex) {
        if (currentPtr.matches()) {
            return this;
        }
        JsonNode n = this._at(currentPtr);
        if (n != null && n instanceof BaseJsonNode) {
            ArrayNode found = ((BaseJsonNode)n)._withArray(origPtr, currentPtr.tail(), overwriteMode, preferIndex);
            if (found != null) {
                return found;
            }
            this._withXxxVerifyReplace(origPtr, currentPtr, overwriteMode, preferIndex, n);
        }
        return this._withArrayAddTailElement(currentPtr, preferIndex);
    }

    protected ObjectNode _withObjectAddTailElement(JsonPointer tail, boolean preferIndex) {
        int index2 = tail.getMatchingIndex();
        if (index2 < 0) {
            return null;
        }
        if ((tail = tail.tail()).matches()) {
            ObjectNode result2 = this.objectNode();
            this._withXxxSetArrayElement(index2, result2);
            return result2;
        }
        if (preferIndex && tail.mayMatchElement()) {
            ArrayNode next2 = this.arrayNode();
            this._withXxxSetArrayElement(index2, next2);
            return next2._withObjectAddTailElement(tail, preferIndex);
        }
        ObjectNode next3 = this.objectNode();
        this._withXxxSetArrayElement(index2, next3);
        return next3._withObjectAddTailProperty(tail, preferIndex);
    }

    protected ArrayNode _withArrayAddTailElement(JsonPointer tail, boolean preferIndex) {
        int index2 = tail.getMatchingIndex();
        if (index2 < 0) {
            return null;
        }
        if ((tail = tail.tail()).matches()) {
            ArrayNode result2 = this.arrayNode();
            this._withXxxSetArrayElement(index2, result2);
            return result2;
        }
        if (preferIndex && tail.mayMatchElement()) {
            ArrayNode next2 = this.arrayNode();
            this._withXxxSetArrayElement(index2, next2);
            return next2._withArrayAddTailElement(tail, preferIndex);
        }
        ObjectNode next3 = this.objectNode();
        this._withXxxSetArrayElement(index2, next3);
        return next3._withArrayAddTailProperty(tail, preferIndex);
    }

    protected void _withXxxSetArrayElement(int index2, JsonNode value) {
        if (index2 >= this.size()) {
            int max2 = this._nodeFactory.getMaxElementIndexForInsert();
            if (index2 > max2) {
                this._reportWrongNodeOperation("Too big Array index (%d; max %d) to use for insert with `JsonPointer`", index2, max2);
            }
            while (index2 >= this.size()) {
                this.addNull();
            }
        }
        this.set(index2, value);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializers) {
        return this._children.isEmpty();
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.ARRAY;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_ARRAY;
    }

    @Override
    public int size() {
        return this._children.size();
    }

    @Override
    public boolean isEmpty() {
        return this._children.isEmpty();
    }

    @Override
    public Iterator<JsonNode> elements() {
        return this._children.iterator();
    }

    @Override
    public JsonNode get(int index2) {
        if (index2 >= 0 && index2 < this._children.size()) {
            return this._children.get(index2);
        }
        return null;
    }

    @Override
    public JsonNode get(String fieldName) {
        return null;
    }

    @Override
    public JsonNode path(String fieldName) {
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode path(int index2) {
        if (index2 >= 0 && index2 < this._children.size()) {
            return this._children.get(index2);
        }
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode required(int index2) {
        if (index2 >= 0 && index2 < this._children.size()) {
            return this._children.get(index2);
        }
        return (JsonNode)this._reportRequiredViolation("No value at index #%d [0, %d) of `ArrayNode`", index2, this._children.size());
    }

    @Override
    public boolean equals(Comparator<JsonNode> comparator2, JsonNode o) {
        if (!(o instanceof ArrayNode)) {
            return false;
        }
        ArrayNode other = (ArrayNode)o;
        int len = this._children.size();
        if (other.size() != len) {
            return false;
        }
        List<JsonNode> l1 = this._children;
        List<JsonNode> l2 = other._children;
        for (int i = 0; i < len; ++i) {
            if (l1.get(i).equals(comparator2, l2.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void serialize(JsonGenerator g2, SerializerProvider provider2) throws IOException {
        List<JsonNode> c = this._children;
        int size = c.size();
        g2.writeStartArray(this, size);
        for (int i = 0; i < size; ++i) {
            JsonNode value = c.get(i);
            value.serialize(g2, provider2);
        }
        g2.writeEndArray();
    }

    @Override
    public void serializeWithType(JsonGenerator g2, SerializerProvider provider2, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId(this, JsonToken.START_ARRAY));
        for (JsonNode n : this._children) {
            ((BaseJsonNode)n).serialize(g2, provider2);
        }
        typeSer.writeTypeSuffix(g2, typeIdDef);
    }

    @Override
    public JsonNode findValue(String fieldName) {
        for (JsonNode node2 : this._children) {
            JsonNode value = node2.findValue(fieldName);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public List<JsonNode> findValues(String fieldName, List<JsonNode> foundSoFar) {
        for (JsonNode node2 : this._children) {
            foundSoFar = node2.findValues(fieldName, foundSoFar);
        }
        return foundSoFar;
    }

    @Override
    public List<String> findValuesAsText(String fieldName, List<String> foundSoFar) {
        for (JsonNode node2 : this._children) {
            foundSoFar = node2.findValuesAsText(fieldName, foundSoFar);
        }
        return foundSoFar;
    }

    @Override
    public ObjectNode findParent(String fieldName) {
        for (JsonNode node2 : this._children) {
            JsonNode parent = node2.findParent(fieldName);
            if (parent == null) continue;
            return (ObjectNode)parent;
        }
        return null;
    }

    @Override
    public List<JsonNode> findParents(String fieldName, List<JsonNode> foundSoFar) {
        for (JsonNode node2 : this._children) {
            foundSoFar = node2.findParents(fieldName, foundSoFar);
        }
        return foundSoFar;
    }

    public JsonNode set(int index2, JsonNode value) {
        if (value == null) {
            value = this.nullNode();
        }
        if (index2 < 0 || index2 >= this._children.size()) {
            throw new IndexOutOfBoundsException("Illegal index " + index2 + ", array size " + this.size());
        }
        return this._children.set(index2, value);
    }

    public ArrayNode add(JsonNode value) {
        if (value == null) {
            value = this.nullNode();
        }
        this._add(value);
        return this;
    }

    public ArrayNode addAll(ArrayNode other) {
        this._children.addAll(other._children);
        return this;
    }

    public ArrayNode addAll(Collection<? extends JsonNode> nodes) {
        for (JsonNode jsonNode : nodes) {
            this.add(jsonNode);
        }
        return this;
    }

    public ArrayNode insert(int index2, JsonNode value) {
        if (value == null) {
            value = this.nullNode();
        }
        this._insert(index2, value);
        return this;
    }

    public JsonNode remove(int index2) {
        if (index2 >= 0 && index2 < this._children.size()) {
            return this._children.remove(index2);
        }
        return null;
    }

    @Override
    public ArrayNode removeAll() {
        this._children.clear();
        return this;
    }

    public ArrayNode addArray() {
        ArrayNode n = this.arrayNode();
        this._add(n);
        return n;
    }

    public ObjectNode addObject() {
        ObjectNode n = this.objectNode();
        this._add(n);
        return n;
    }

    public ArrayNode addPOJO(Object pojo) {
        return this._add(pojo == null ? this.nullNode() : this.pojoNode(pojo));
    }

    public ArrayNode addRawValue(RawValue raw) {
        return this._add(raw == null ? this.nullNode() : this.rawValueNode(raw));
    }

    public ArrayNode addNull() {
        return this._add(this.nullNode());
    }

    public ArrayNode add(short v) {
        return this._add(this.numberNode(v));
    }

    public ArrayNode add(Short v) {
        return this._add(v == null ? this.nullNode() : this.numberNode((short)v));
    }

    public ArrayNode add(int v) {
        return this._add(this.numberNode(v));
    }

    public ArrayNode add(Integer v) {
        return this._add(v == null ? this.nullNode() : this.numberNode((int)v));
    }

    public ArrayNode add(long v) {
        return this._add(this.numberNode(v));
    }

    public ArrayNode add(Long v) {
        return this._add(v == null ? this.nullNode() : this.numberNode((long)v));
    }

    public ArrayNode add(float v) {
        return this._add(this.numberNode(v));
    }

    public ArrayNode add(Float v) {
        return this._add(v == null ? this.nullNode() : this.numberNode(v.floatValue()));
    }

    public ArrayNode add(double v) {
        return this._add(this.numberNode(v));
    }

    public ArrayNode add(Double v) {
        return this._add(v == null ? this.nullNode() : this.numberNode((double)v));
    }

    public ArrayNode add(BigDecimal v) {
        return this._add(v == null ? this.nullNode() : this.numberNode(v));
    }

    public ArrayNode add(BigInteger v) {
        return this._add(v == null ? this.nullNode() : this.numberNode(v));
    }

    public ArrayNode add(String v) {
        return this._add(v == null ? this.nullNode() : this.textNode(v));
    }

    public ArrayNode add(boolean v) {
        return this._add(this.booleanNode(v));
    }

    public ArrayNode add(Boolean v) {
        return this._add(v == null ? this.nullNode() : this.booleanNode(v));
    }

    public ArrayNode add(byte[] v) {
        return this._add(v == null ? this.nullNode() : this.binaryNode(v));
    }

    public ArrayNode insertArray(int index2) {
        ArrayNode n = this.arrayNode();
        this._insert(index2, n);
        return n;
    }

    public ObjectNode insertObject(int index2) {
        ObjectNode n = this.objectNode();
        this._insert(index2, n);
        return n;
    }

    public ArrayNode insertNull(int index2) {
        return this._insert(index2, this.nullNode());
    }

    public ArrayNode insertPOJO(int index2, Object pojo) {
        return this._insert(index2, pojo == null ? this.nullNode() : this.pojoNode(pojo));
    }

    public ArrayNode insertRawValue(int index2, RawValue raw) {
        return this._insert(index2, raw == null ? this.nullNode() : this.rawValueNode(raw));
    }

    public ArrayNode insert(int index2, short v) {
        return this._insert(index2, this.numberNode(v));
    }

    public ArrayNode insert(int index2, Short value) {
        return this._insert(index2, value == null ? this.nullNode() : this.numberNode((short)value));
    }

    public ArrayNode insert(int index2, int v) {
        return this._insert(index2, this.numberNode(v));
    }

    public ArrayNode insert(int index2, Integer v) {
        return this._insert(index2, v == null ? this.nullNode() : this.numberNode((int)v));
    }

    public ArrayNode insert(int index2, long v) {
        return this._insert(index2, this.numberNode(v));
    }

    public ArrayNode insert(int index2, Long v) {
        return this._insert(index2, v == null ? this.nullNode() : this.numberNode((long)v));
    }

    public ArrayNode insert(int index2, float v) {
        return this._insert(index2, this.numberNode(v));
    }

    public ArrayNode insert(int index2, Float v) {
        return this._insert(index2, v == null ? this.nullNode() : this.numberNode(v.floatValue()));
    }

    public ArrayNode insert(int index2, double v) {
        return this._insert(index2, this.numberNode(v));
    }

    public ArrayNode insert(int index2, Double v) {
        return this._insert(index2, v == null ? this.nullNode() : this.numberNode((double)v));
    }

    public ArrayNode insert(int index2, BigDecimal v) {
        return this._insert(index2, v == null ? this.nullNode() : this.numberNode(v));
    }

    public ArrayNode insert(int index2, BigInteger v) {
        return this._insert(index2, v == null ? this.nullNode() : this.numberNode(v));
    }

    public ArrayNode insert(int index2, String v) {
        return this._insert(index2, v == null ? this.nullNode() : this.textNode(v));
    }

    public ArrayNode insert(int index2, boolean v) {
        return this._insert(index2, this.booleanNode(v));
    }

    public ArrayNode insert(int index2, Boolean value) {
        if (value == null) {
            return this.insertNull(index2);
        }
        return this._insert(index2, this.booleanNode(value));
    }

    public ArrayNode insert(int index2, byte[] v) {
        if (v == null) {
            return this.insertNull(index2);
        }
        return this._insert(index2, this.binaryNode(v));
    }

    public ArrayNode setNull(int index2) {
        return this._set(index2, this.nullNode());
    }

    public ArrayNode setPOJO(int index2, Object pojo) {
        return this._set(index2, pojo == null ? this.nullNode() : this.pojoNode(pojo));
    }

    public ArrayNode setRawValue(int index2, RawValue raw) {
        return this._set(index2, raw == null ? this.nullNode() : this.rawValueNode(raw));
    }

    public ArrayNode set(int index2, short v) {
        return this._set(index2, this.numberNode(v));
    }

    public ArrayNode set(int index2, Short v) {
        return this._set(index2, v == null ? this.nullNode() : this.numberNode((short)v));
    }

    public ArrayNode set(int index2, int v) {
        return this._set(index2, this.numberNode(v));
    }

    public ArrayNode set(int index2, Integer v) {
        return this._set(index2, v == null ? this.nullNode() : this.numberNode((int)v));
    }

    public ArrayNode set(int index2, long v) {
        return this._set(index2, this.numberNode(v));
    }

    public ArrayNode set(int index2, Long v) {
        return this._set(index2, v == null ? this.nullNode() : this.numberNode((long)v));
    }

    public ArrayNode set(int index2, float v) {
        return this._set(index2, this.numberNode(v));
    }

    public ArrayNode set(int index2, Float v) {
        return this._set(index2, v == null ? this.nullNode() : this.numberNode(v.floatValue()));
    }

    public ArrayNode set(int index2, double v) {
        return this._set(index2, this.numberNode(v));
    }

    public ArrayNode set(int index2, Double v) {
        return this._set(index2, v == null ? this.nullNode() : this.numberNode((double)v));
    }

    public ArrayNode set(int index2, BigDecimal v) {
        return this._set(index2, v == null ? this.nullNode() : this.numberNode(v));
    }

    public ArrayNode set(int index2, BigInteger v) {
        return this._set(index2, v == null ? this.nullNode() : this.numberNode(v));
    }

    public ArrayNode set(int index2, String v) {
        return this._set(index2, v == null ? this.nullNode() : this.textNode(v));
    }

    public ArrayNode set(int index2, boolean v) {
        return this._set(index2, this.booleanNode(v));
    }

    public ArrayNode set(int index2, Boolean v) {
        return this._set(index2, v == null ? this.nullNode() : this.booleanNode(v));
    }

    public ArrayNode set(int index2, byte[] v) {
        return this._set(index2, v == null ? this.nullNode() : this.binaryNode(v));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof ArrayNode) {
            return this._children.equals(((ArrayNode)o)._children);
        }
        return false;
    }

    protected boolean _childrenEqual(ArrayNode other) {
        return this._children.equals(other._children);
    }

    @Override
    public int hashCode() {
        return this._children.hashCode();
    }

    protected ArrayNode _set(int index2, JsonNode node2) {
        if (index2 < 0 || index2 >= this._children.size()) {
            throw new IndexOutOfBoundsException("Illegal index " + index2 + ", array size " + this.size());
        }
        this._children.set(index2, node2);
        return this;
    }

    protected ArrayNode _add(JsonNode node2) {
        this._children.add(node2);
        return this;
    }

    protected ArrayNode _insert(int index2, JsonNode node2) {
        if (index2 < 0) {
            this._children.add(0, node2);
        } else if (index2 >= this._children.size()) {
            this._children.add(node2);
        } else {
            this._children.add(index2, node2);
        }
        return this;
    }
}

