/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.deser.KeyDeserializers;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedAndMetadata;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.EnumResolver;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;

public class StdKeyDeserializers
implements KeyDeserializers,
Serializable {
    private static final long serialVersionUID = 1L;

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver) {
        return new StdKeyDeserializer.EnumKD(enumResolver, null);
    }

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver, AnnotatedMethod factory) {
        return new StdKeyDeserializer.EnumKD(enumResolver, factory);
    }

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver, EnumResolver enumNamingResolver) {
        return new StdKeyDeserializer.EnumKD(enumResolver, null, enumNamingResolver);
    }

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver, AnnotatedMethod factory, EnumResolver enumNamingResolver) {
        return new StdKeyDeserializer.EnumKD(enumResolver, factory, enumNamingResolver);
    }

    public static KeyDeserializer constructDelegatingKeyDeserializer(DeserializationConfig config, JavaType type2, JsonDeserializer<?> deser) {
        return new StdKeyDeserializer.DelegatingKD(type2.getRawClass(), deser);
    }

    public static KeyDeserializer findStringBasedKeyDeserializer(DeserializationConfig config, JavaType type2) throws JsonMappingException {
        BeanDescription beanDesc = config.introspectForCreation(type2);
        AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode> ctorInfo = StdKeyDeserializers._findStringConstructor(beanDesc);
        if (ctorInfo != null && ctorInfo.metadata != null) {
            return StdKeyDeserializers._constructCreatorKeyDeserializer(config, (AnnotatedMember)ctorInfo.annotated);
        }
        List<AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode>> factoryCandidates = beanDesc.getFactoryMethodsWithMode();
        factoryCandidates.removeIf(m4 -> ((AnnotatedMethod)m4.annotated).getParameterCount() != 1 || ((AnnotatedMethod)m4.annotated).getRawParameterType(0) != String.class || m4.metadata == JsonCreator.Mode.PROPERTIES);
        AnnotatedMethod explicitFactory = StdKeyDeserializers._findExplicitStringFactoryMethod(factoryCandidates);
        if (explicitFactory != null) {
            return StdKeyDeserializers._constructCreatorKeyDeserializer(config, explicitFactory);
        }
        if (ctorInfo != null) {
            return StdKeyDeserializers._constructCreatorKeyDeserializer(config, (AnnotatedMember)ctorInfo.annotated);
        }
        if (!factoryCandidates.isEmpty()) {
            return StdKeyDeserializers._constructCreatorKeyDeserializer(config, (AnnotatedMember)factoryCandidates.get((int)0).annotated);
        }
        return null;
    }

    private static KeyDeserializer _constructCreatorKeyDeserializer(DeserializationConfig config, AnnotatedMember creator) {
        if (creator instanceof AnnotatedConstructor) {
            AnnotatedElement rawCtor = ((AnnotatedConstructor)creator).getAnnotated();
            if (config.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess((Member)((Object)rawCtor), config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            return new StdKeyDeserializer.StringCtorKeyDeserializer((Constructor<?>)rawCtor);
        }
        Method m4 = ((AnnotatedMethod)creator).getAnnotated();
        if (config.canOverrideAccessModifiers()) {
            ClassUtil.checkAndFixAccess(m4, config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        return new StdKeyDeserializer.StringFactoryKeyDeserializer(m4);
    }

    private static AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode> _findStringConstructor(BeanDescription beanDesc) {
        for (AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode> entry : beanDesc.getConstructorsWithMode()) {
            AnnotatedConstructor ctor = (AnnotatedConstructor)entry.annotated;
            if (ctor.getParameterCount() != 1 || String.class != ctor.getRawParameterType(0)) continue;
            return entry;
        }
        return null;
    }

    private static AnnotatedMethod _findExplicitStringFactoryMethod(List<AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode>> candidates) throws JsonMappingException {
        AnnotatedMethod match2 = null;
        for (AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode> entry : candidates) {
            if (entry.metadata == null) continue;
            if (match2 == null) {
                match2 = (AnnotatedMethod)entry.annotated;
                continue;
            }
            Class<?> rawKeyType = ((AnnotatedMethod)entry.annotated).getDeclaringClass();
            throw new IllegalArgumentException("Multiple suitable annotated Creator factory methods to be used as the Key deserializer for type " + ClassUtil.nameOf(rawKeyType));
        }
        return match2;
    }

    @Override
    public KeyDeserializer findKeyDeserializer(JavaType type2, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        Class<?> raw = type2.getRawClass();
        if (raw.isPrimitive()) {
            raw = ClassUtil.wrapperType(raw);
        }
        return StdKeyDeserializer.forType(raw);
    }
}

