/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import com.fasterxml.jackson.databind.deser.impl.BeanAsArrayDeserializer;
import com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.fasterxml.jackson.databind.deser.impl.ExternalTypeHandler;
import com.fasterxml.jackson.databind.deser.impl.MethodProperty;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.IgnorePropertiesUtil;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BeanDeserializer
extends BeanDeserializerBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient Exception _nullFromCreator;
    private volatile transient NameTransformer _currentlyTransforming;

    @Deprecated
    public BeanDeserializer(BeanDeserializerBuilder builder, BeanDescription beanDesc, BeanPropertyMap properties2, Map<String, SettableBeanProperty> backRefs, HashSet<String> ignorableProps, boolean ignoreAllUnknown, boolean hasViews) {
        super(builder, beanDesc, properties2, backRefs, ignorableProps, ignoreAllUnknown, null, hasViews);
    }

    public BeanDeserializer(BeanDeserializerBuilder builder, BeanDescription beanDesc, BeanPropertyMap properties2, Map<String, SettableBeanProperty> backRefs, HashSet<String> ignorableProps, boolean ignoreAllUnknown, Set<String> includableProps, boolean hasViews) {
        super(builder, beanDesc, properties2, backRefs, ignorableProps, ignoreAllUnknown, includableProps, hasViews);
    }

    protected BeanDeserializer(BeanDeserializerBase src) {
        super(src, src._ignoreAllUnknown);
    }

    protected BeanDeserializer(BeanDeserializerBase src, boolean ignoreAllUnknown) {
        super(src, ignoreAllUnknown);
    }

    protected BeanDeserializer(BeanDeserializerBase src, NameTransformer unwrapper) {
        super(src, unwrapper);
    }

    public BeanDeserializer(BeanDeserializerBase src, ObjectIdReader oir) {
        super(src, oir);
    }

    @Deprecated
    public BeanDeserializer(BeanDeserializerBase src, Set<String> ignorableProps) {
        super(src, ignorableProps);
    }

    public BeanDeserializer(BeanDeserializerBase src, Set<String> ignorableProps, Set<String> includableProps) {
        super(src, ignorableProps, includableProps);
    }

    public BeanDeserializer(BeanDeserializerBase src, BeanPropertyMap props) {
        super(src, props);
    }

    @Override
    public JsonDeserializer<Object> unwrappingDeserializer(NameTransformer transformer) {
        if (this.getClass() != BeanDeserializer.class) {
            return this;
        }
        if (this._currentlyTransforming == transformer) {
            return this;
        }
        this._currentlyTransforming = transformer;
        try {
            BeanDeserializer beanDeserializer = new BeanDeserializer((BeanDeserializerBase)this, transformer);
            return beanDeserializer;
        }
        finally {
            this._currentlyTransforming = null;
        }
    }

    @Override
    public BeanDeserializer withObjectIdReader(ObjectIdReader oir) {
        return new BeanDeserializer((BeanDeserializerBase)this, oir);
    }

    @Override
    public BeanDeserializer withByNameInclusion(Set<String> ignorableProps, Set<String> includableProps) {
        return new BeanDeserializer(this, ignorableProps, includableProps);
    }

    @Override
    public BeanDeserializerBase withIgnoreAllUnknown(boolean ignoreUnknown) {
        return new BeanDeserializer((BeanDeserializerBase)this, ignoreUnknown);
    }

    @Override
    public BeanDeserializerBase withBeanProperties(BeanPropertyMap props) {
        return new BeanDeserializer((BeanDeserializerBase)this, props);
    }

    @Override
    protected BeanDeserializerBase asArrayDeserializer() {
        SettableBeanProperty[] props = this._beanProperties.getPropertiesInInsertionOrder();
        return new BeanAsArrayDeserializer((BeanDeserializerBase)this, props);
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.isExpectedStartObjectToken()) {
            if (this._vanillaProcessing) {
                return this.vanillaDeserialize(p, ctxt, p.nextToken());
            }
            p.nextToken();
            if (this._objectIdReader != null) {
                return this.deserializeWithObjectId(p, ctxt);
            }
            return this.deserializeFromObject(p, ctxt);
        }
        return this._deserializeOther(p, ctxt, p.currentToken());
    }

    protected final Object _deserializeOther(JsonParser p, DeserializationContext ctxt, JsonToken t3) throws IOException {
        if (t3 != null) {
            switch (t3) {
                case VALUE_STRING: {
                    return this.deserializeFromString(p, ctxt);
                }
                case VALUE_NUMBER_INT: {
                    return this.deserializeFromNumber(p, ctxt);
                }
                case VALUE_NUMBER_FLOAT: {
                    return this.deserializeFromDouble(p, ctxt);
                }
                case VALUE_EMBEDDED_OBJECT: {
                    return this.deserializeFromEmbedded(p, ctxt);
                }
                case VALUE_TRUE: 
                case VALUE_FALSE: {
                    return this.deserializeFromBoolean(p, ctxt);
                }
                case VALUE_NULL: {
                    return this.deserializeFromNull(p, ctxt);
                }
                case START_ARRAY: {
                    return this._deserializeFromArray(p, ctxt);
                }
                case FIELD_NAME: 
                case END_OBJECT: {
                    if (this._vanillaProcessing) {
                        return this.vanillaDeserialize(p, ctxt, t3);
                    }
                    if (this._objectIdReader != null) {
                        return this.deserializeWithObjectId(p, ctxt);
                    }
                    return this.deserializeFromObject(p, ctxt);
                }
            }
        }
        return ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
    }

    @Deprecated
    protected Object _missingToken(JsonParser p, DeserializationContext ctxt) throws IOException {
        throw ctxt.endOfInputException(this.handledType());
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt, Object bean2) throws IOException {
        Class<?> view;
        String propName;
        p.setCurrentValue(bean2);
        if (this._injectables != null) {
            this.injectValues(ctxt, bean2);
        }
        if (this._unwrappedPropertyHandler != null) {
            return this.deserializeWithUnwrapped(p, ctxt, bean2);
        }
        if (this._externalTypeIdHandler != null) {
            return this.deserializeWithExternalTypeId(p, ctxt, bean2);
        }
        if (p.isExpectedStartObjectToken()) {
            propName = p.nextFieldName();
            if (propName == null) {
                return bean2;
            }
        } else if (p.hasTokenId(5)) {
            propName = p.currentName();
        } else {
            return bean2;
        }
        if (this._needViewProcesing && (view = ctxt.getActiveView()) != null) {
            return this.deserializeWithView(p, ctxt, bean2, view);
        }
        do {
            p.nextToken();
            SettableBeanProperty prop = this._beanProperties.find(propName);
            if (prop != null) {
                try {
                    prop.deserializeAndSet(p, ctxt, bean2);
                }
                catch (Exception e2) {
                    this.wrapAndThrow(e2, bean2, propName, ctxt);
                }
                continue;
            }
            this.handleUnknownVanilla(p, ctxt, bean2, propName);
        } while ((propName = p.nextFieldName()) != null);
        return bean2;
    }

    private final Object vanillaDeserialize(JsonParser p, DeserializationContext ctxt, JsonToken t3) throws IOException {
        Object bean2 = this._valueInstantiator.createUsingDefault(ctxt);
        p.setCurrentValue(bean2);
        if (p.hasTokenId(5)) {
            String propName = p.currentName();
            do {
                p.nextToken();
                SettableBeanProperty prop = this._beanProperties.find(propName);
                if (prop != null) {
                    try {
                        prop.deserializeAndSet(p, ctxt, bean2);
                    }
                    catch (Exception e2) {
                        this.wrapAndThrow(e2, bean2, propName, ctxt);
                    }
                    continue;
                }
                this.handleUnknownVanilla(p, ctxt, bean2, propName);
            } while ((propName = p.nextFieldName()) != null);
        }
        return bean2;
    }

    @Override
    public Object deserializeFromObject(JsonParser p, DeserializationContext ctxt) throws IOException {
        Class<?> view;
        Object id;
        if (this._objectIdReader != null && this._objectIdReader.maySerializeAsObject() && p.hasTokenId(5) && this._objectIdReader.isValidReferencePropertyName(p.currentName(), p)) {
            return this.deserializeFromObjectId(p, ctxt);
        }
        if (this._nonStandardCreation) {
            if (this._unwrappedPropertyHandler != null) {
                return this.deserializeWithUnwrapped(p, ctxt);
            }
            if (this._externalTypeIdHandler != null) {
                return this.deserializeWithExternalTypeId(p, ctxt);
            }
            Object bean2 = this.deserializeFromObjectUsingNonDefault(p, ctxt);
            return bean2;
        }
        Object bean3 = this._valueInstantiator.createUsingDefault(ctxt);
        p.setCurrentValue(bean3);
        if (p.canReadObjectId() && (id = p.getObjectId()) != null) {
            this._handleTypedObjectId(p, ctxt, bean3, id);
        }
        if (this._injectables != null) {
            this.injectValues(ctxt, bean3);
        }
        if (this._needViewProcesing && (view = ctxt.getActiveView()) != null) {
            return this.deserializeWithView(p, ctxt, bean3, view);
        }
        if (p.hasTokenId(5)) {
            String propName = p.currentName();
            do {
                p.nextToken();
                SettableBeanProperty prop = this._beanProperties.find(propName);
                if (prop != null) {
                    try {
                        prop.deserializeAndSet(p, ctxt, bean3);
                    }
                    catch (Exception e2) {
                        this.wrapAndThrow(e2, bean3, propName, ctxt);
                    }
                    continue;
                }
                this.handleUnknownVanilla(p, ctxt, bean3, propName);
            } while ((propName = p.nextFieldName()) != null);
        }
        return bean3;
    }

    @Override
    protected Object _deserializeUsingPropertyBased(JsonParser p, DeserializationContext ctxt) throws IOException {
        Object bean2;
        PropertyBasedCreator creator = this._propertyBasedCreator;
        PropertyValueBuffer buffer = creator.startBuilding(p, ctxt, this._objectIdReader);
        TokenBuffer unknown = null;
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        JsonToken t3 = p.currentToken();
        ArrayList<BeanReferring> referrings = null;
        while (t3 == JsonToken.FIELD_NAME) {
            String propName = p.currentName();
            p.nextToken();
            SettableBeanProperty creatorProp = creator.findCreatorProperty(propName);
            if (!buffer.readIdProperty(propName) || creatorProp != null) {
                if (creatorProp != null) {
                    if (activeView != null && !creatorProp.visibleInView(activeView)) {
                        p.skipChildren();
                    } else {
                        Object value = this._deserializeWithErrorWrapping(p, ctxt, creatorProp);
                        if (buffer.assignParameter(creatorProp, value)) {
                            Object bean3;
                            p.nextToken();
                            try {
                                bean3 = creator.build(ctxt, buffer);
                            }
                            catch (Exception e2) {
                                bean3 = this.wrapInstantiationProblem(e2, ctxt);
                            }
                            if (bean3 == null) {
                                return ctxt.handleInstantiationProblem(this.handledType(), null, this._creatorReturnedNullException());
                            }
                            p.setCurrentValue(bean3);
                            if (bean3.getClass() != this._beanType.getRawClass()) {
                                return this.handlePolymorphic(p, ctxt, p.streamReadConstraints(), bean3, unknown);
                            }
                            if (unknown != null) {
                                bean3 = this.handleUnknownProperties(ctxt, bean3, unknown);
                            }
                            return this.deserialize(p, ctxt, bean3);
                        }
                    }
                } else {
                    SettableBeanProperty prop = this._beanProperties.find(propName);
                    if (prop != null && (!this._beanType.isRecordType() || prop instanceof MethodProperty)) {
                        try {
                            buffer.bufferProperty(prop, this._deserializeWithErrorWrapping(p, ctxt, prop));
                        }
                        catch (UnresolvedForwardReference reference) {
                            BeanReferring referring = this.handleUnresolvedReference(ctxt, prop, buffer, reference);
                            if (referrings == null) {
                                referrings = new ArrayList<BeanReferring>();
                            }
                            referrings.add(referring);
                        }
                    } else if (IgnorePropertiesUtil.shouldIgnore(propName, this._ignorableProps, this._includableProps)) {
                        this.handleIgnoredProperty(p, ctxt, this.handledType(), propName);
                    } else if (this._anySetter != null) {
                        try {
                            buffer.bufferAnyProperty(this._anySetter, propName, this._anySetter.deserialize(p, ctxt));
                        }
                        catch (Exception e3) {
                            this.wrapAndThrow(e3, this._beanType.getRawClass(), propName, ctxt);
                        }
                    } else if (this._ignoreAllUnknown) {
                        p.skipChildren();
                    } else {
                        if (unknown == null) {
                            unknown = ctxt.bufferForInputBuffering(p);
                        }
                        unknown.writeFieldName(propName);
                        unknown.copyCurrentStructure(p);
                    }
                }
            }
            t3 = p.nextToken();
        }
        try {
            bean2 = creator.build(ctxt, buffer);
        }
        catch (Exception e4) {
            this.wrapInstantiationProblem(e4, ctxt);
            bean2 = null;
        }
        if (this._injectables != null) {
            this.injectValues(ctxt, bean2);
        }
        if (referrings != null) {
            for (BeanReferring referring : referrings) {
                referring.setBean(bean2);
            }
        }
        if (unknown != null) {
            if (bean2.getClass() != this._beanType.getRawClass()) {
                return this.handlePolymorphic(null, ctxt, p.streamReadConstraints(), bean2, unknown);
            }
            return this.handleUnknownProperties(ctxt, bean2, unknown);
        }
        return bean2;
    }

    private BeanReferring handleUnresolvedReference(DeserializationContext ctxt, SettableBeanProperty prop, PropertyValueBuffer buffer, UnresolvedForwardReference reference) throws JsonMappingException {
        BeanReferring referring = new BeanReferring(ctxt, reference, prop.getType(), buffer, prop);
        reference.getRoid().appendReferring(referring);
        return referring;
    }

    protected final Object _deserializeWithErrorWrapping(JsonParser p, DeserializationContext ctxt, SettableBeanProperty prop) throws IOException {
        try {
            return prop.deserialize(p, ctxt);
        }
        catch (Exception e2) {
            this.wrapAndThrow(e2, this._beanType.getRawClass(), prop.getName(), ctxt);
            return null;
        }
    }

    protected Object deserializeFromNull(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.requiresCustomCodec()) {
            TokenBuffer tb = ctxt.bufferForInputBuffering(p);
            tb.writeEndObject();
            JsonParser p2 = tb.asParser(p);
            p2.nextToken();
            Object ob = this._vanillaProcessing ? this.vanillaDeserialize(p2, ctxt, JsonToken.END_OBJECT) : this.deserializeFromObject(p2, ctxt);
            p2.close();
            return ob;
        }
        return ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
    }

    @Override
    protected Object _deserializeFromArray(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonDeserializer delegateDeser = this._arrayDelegateDeserializer;
        if (delegateDeser != null || (delegateDeser = this._delegateDeserializer) != null) {
            Object bean2 = this._valueInstantiator.createUsingArrayDelegate(ctxt, delegateDeser.deserialize(p, ctxt));
            if (this._injectables != null) {
                this.injectValues(ctxt, bean2);
            }
            return bean2;
        }
        CoercionAction act = this._findCoercionFromEmptyArray(ctxt);
        boolean unwrap2 = ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS);
        if (unwrap2 || act != CoercionAction.Fail) {
            JsonToken unwrappedToken = p.nextToken();
            if (unwrappedToken == JsonToken.END_ARRAY) {
                switch (act) {
                    case AsEmpty: {
                        return this.getEmptyValue(ctxt);
                    }
                    case AsNull: 
                    case TryConvert: {
                        return this.getNullValue(ctxt);
                    }
                }
                return ctxt.handleUnexpectedToken(this.getValueType(ctxt), JsonToken.START_ARRAY, p, null, new Object[0]);
            }
            if (unwrap2) {
                if (unwrappedToken == JsonToken.START_ARRAY) {
                    JavaType targetType = this.getValueType(ctxt);
                    return ctxt.handleUnexpectedToken(targetType, JsonToken.START_ARRAY, p, "Cannot deserialize value of type %s from deeply-nested Array: only single wrapper allowed with `%s`", ClassUtil.getTypeDescription(targetType), "DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS");
                }
                Object value = this.deserialize(p, ctxt);
                if (p.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(p, ctxt);
                }
                return value;
            }
        }
        return ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
    }

    protected final Object deserializeWithView(JsonParser p, DeserializationContext ctxt, Object bean2, Class<?> activeView) throws IOException {
        if (p.hasTokenId(5)) {
            String propName = p.currentName();
            do {
                p.nextToken();
                SettableBeanProperty prop = this._beanProperties.find(propName);
                if (prop != null) {
                    if (!prop.visibleInView(activeView)) {
                        p.skipChildren();
                        continue;
                    }
                    try {
                        prop.deserializeAndSet(p, ctxt, bean2);
                    }
                    catch (Exception e2) {
                        this.wrapAndThrow(e2, bean2, propName, ctxt);
                    }
                    continue;
                }
                this.handleUnknownVanilla(p, ctxt, bean2, propName);
            } while ((propName = p.nextFieldName()) != null);
        }
        return bean2;
    }

    protected Object deserializeWithUnwrapped(JsonParser p, DeserializationContext ctxt) throws IOException {
        String propName;
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(ctxt, this._delegateDeserializer.deserialize(p, ctxt));
        }
        if (this._propertyBasedCreator != null) {
            return this.deserializeUsingPropertyBasedWithUnwrapped(p, ctxt);
        }
        TokenBuffer tokens = ctxt.bufferForInputBuffering(p);
        tokens.writeStartObject();
        Object bean2 = this._valueInstantiator.createUsingDefault(ctxt);
        p.setCurrentValue(bean2);
        if (this._injectables != null) {
            this.injectValues(ctxt, bean2);
        }
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        String string2 = propName = p.hasTokenId(5) ? p.currentName() : null;
        while (propName != null) {
            p.nextToken();
            SettableBeanProperty prop = this._beanProperties.find(propName);
            if (prop != null) {
                if (activeView != null && !prop.visibleInView(activeView)) {
                    p.skipChildren();
                } else {
                    try {
                        prop.deserializeAndSet(p, ctxt, bean2);
                    }
                    catch (Exception e2) {
                        this.wrapAndThrow(e2, bean2, propName, ctxt);
                    }
                }
            } else if (IgnorePropertiesUtil.shouldIgnore(propName, this._ignorableProps, this._includableProps)) {
                this.handleIgnoredProperty(p, ctxt, bean2, propName);
            } else if (this._anySetter == null) {
                tokens.writeFieldName(propName);
                tokens.copyCurrentStructure(p);
            } else {
                TokenBuffer b2 = ctxt.bufferAsCopyOfValue(p);
                tokens.writeFieldName(propName);
                tokens.append(b2);
                try {
                    this._anySetter.deserializeAndSet(b2.asParserOnFirstToken(), ctxt, bean2, propName);
                }
                catch (Exception e3) {
                    this.wrapAndThrow(e3, bean2, propName, ctxt);
                }
            }
            propName = p.nextFieldName();
        }
        tokens.writeEndObject();
        this._unwrappedPropertyHandler.processUnwrapped(p, ctxt, bean2, tokens);
        return bean2;
    }

    protected Object deserializeWithUnwrapped(JsonParser p, DeserializationContext ctxt, Object bean2) throws IOException {
        Class<?> activeView;
        JsonToken t3 = p.currentToken();
        if (t3 == JsonToken.START_OBJECT) {
            t3 = p.nextToken();
        }
        TokenBuffer tokens = ctxt.bufferForInputBuffering(p);
        tokens.writeStartObject();
        Class<?> clazz = activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        while (t3 == JsonToken.FIELD_NAME) {
            String propName = p.currentName();
            SettableBeanProperty prop = this._beanProperties.find(propName);
            p.nextToken();
            if (prop != null) {
                if (activeView != null && !prop.visibleInView(activeView)) {
                    p.skipChildren();
                } else {
                    try {
                        prop.deserializeAndSet(p, ctxt, bean2);
                    }
                    catch (Exception e2) {
                        this.wrapAndThrow(e2, bean2, propName, ctxt);
                    }
                }
            } else if (IgnorePropertiesUtil.shouldIgnore(propName, this._ignorableProps, this._includableProps)) {
                this.handleIgnoredProperty(p, ctxt, bean2, propName);
            } else if (this._anySetter == null) {
                tokens.writeFieldName(propName);
                tokens.copyCurrentStructure(p);
            } else {
                TokenBuffer b2 = ctxt.bufferAsCopyOfValue(p);
                tokens.writeFieldName(propName);
                tokens.append(b2);
                try {
                    this._anySetter.deserializeAndSet(b2.asParserOnFirstToken(), ctxt, bean2, propName);
                }
                catch (Exception e3) {
                    this.wrapAndThrow(e3, bean2, propName, ctxt);
                }
            }
            t3 = p.nextToken();
        }
        tokens.writeEndObject();
        this._unwrappedPropertyHandler.processUnwrapped(p, ctxt, bean2, tokens);
        return bean2;
    }

    protected Object deserializeUsingPropertyBasedWithUnwrapped(JsonParser p, DeserializationContext ctxt) throws IOException {
        Object bean2;
        PropertyBasedCreator creator = this._propertyBasedCreator;
        PropertyValueBuffer buffer = creator.startBuilding(p, ctxt, this._objectIdReader);
        TokenBuffer tokens = ctxt.bufferForInputBuffering(p);
        tokens.writeStartObject();
        JsonToken t3 = p.currentToken();
        while (t3 == JsonToken.FIELD_NAME) {
            String propName = p.currentName();
            p.nextToken();
            SettableBeanProperty creatorProp = creator.findCreatorProperty(propName);
            if (!buffer.readIdProperty(propName) || creatorProp != null) {
                if (creatorProp != null) {
                    if (buffer.assignParameter(creatorProp, this._deserializeWithErrorWrapping(p, ctxt, creatorProp))) {
                        Object bean3;
                        t3 = p.nextToken();
                        try {
                            bean3 = creator.build(ctxt, buffer);
                        }
                        catch (Exception e2) {
                            bean3 = this.wrapInstantiationProblem(e2, ctxt);
                        }
                        p.setCurrentValue(bean3);
                        while (t3 == JsonToken.FIELD_NAME) {
                            tokens.copyCurrentStructure(p);
                            t3 = p.nextToken();
                        }
                        if (t3 != JsonToken.END_OBJECT) {
                            ctxt.reportWrongTokenException(this, JsonToken.END_OBJECT, "Attempted to unwrap '%s' value", this.handledType().getName());
                        }
                        tokens.writeEndObject();
                        if (bean3.getClass() != this._beanType.getRawClass()) {
                            ctxt.reportInputMismatch(creatorProp, "Cannot create polymorphic instances with unwrapped values", new Object[0]);
                            return null;
                        }
                        return this._unwrappedPropertyHandler.processUnwrapped(p, ctxt, bean3, tokens);
                    }
                } else {
                    SettableBeanProperty prop = this._beanProperties.find(propName);
                    if (prop != null) {
                        buffer.bufferProperty(prop, this._deserializeWithErrorWrapping(p, ctxt, prop));
                    } else if (IgnorePropertiesUtil.shouldIgnore(propName, this._ignorableProps, this._includableProps)) {
                        this.handleIgnoredProperty(p, ctxt, this.handledType(), propName);
                    } else if (this._anySetter == null) {
                        tokens.writeFieldName(propName);
                        tokens.copyCurrentStructure(p);
                    } else {
                        TokenBuffer b2 = ctxt.bufferAsCopyOfValue(p);
                        tokens.writeFieldName(propName);
                        tokens.append(b2);
                        try {
                            buffer.bufferAnyProperty(this._anySetter, propName, this._anySetter.deserialize(b2.asParserOnFirstToken(), ctxt));
                        }
                        catch (Exception e3) {
                            this.wrapAndThrow(e3, this._beanType.getRawClass(), propName, ctxt);
                        }
                    }
                }
            }
            t3 = p.nextToken();
        }
        try {
            bean2 = creator.build(ctxt, buffer);
        }
        catch (Exception e4) {
            this.wrapInstantiationProblem(e4, ctxt);
            return null;
        }
        return this._unwrappedPropertyHandler.processUnwrapped(p, ctxt, bean2, tokens);
    }

    protected Object deserializeWithExternalTypeId(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (this._propertyBasedCreator != null) {
            return this.deserializeUsingPropertyBasedWithExternalTypeId(p, ctxt);
        }
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(ctxt, this._delegateDeserializer.deserialize(p, ctxt));
        }
        return this.deserializeWithExternalTypeId(p, ctxt, this._valueInstantiator.createUsingDefault(ctxt));
    }

    protected Object deserializeWithExternalTypeId(JsonParser p, DeserializationContext ctxt, Object bean2) throws IOException {
        return this._deserializeWithExternalTypeId(p, ctxt, bean2, this._externalTypeIdHandler.start());
    }

    protected Object _deserializeWithExternalTypeId(JsonParser p, DeserializationContext ctxt, Object bean2, ExternalTypeHandler ext) throws IOException {
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        JsonToken t3 = p.currentToken();
        while (t3 == JsonToken.FIELD_NAME) {
            String propName = p.currentName();
            t3 = p.nextToken();
            SettableBeanProperty prop = this._beanProperties.find(propName);
            if (prop != null) {
                if (t3.isScalarValue()) {
                    ext.handleTypePropertyValue(p, ctxt, propName, bean2);
                }
                if (activeView != null && !prop.visibleInView(activeView)) {
                    p.skipChildren();
                } else {
                    try {
                        prop.deserializeAndSet(p, ctxt, bean2);
                    }
                    catch (Exception e2) {
                        this.wrapAndThrow(e2, bean2, propName, ctxt);
                    }
                }
            } else if (IgnorePropertiesUtil.shouldIgnore(propName, this._ignorableProps, this._includableProps)) {
                this.handleIgnoredProperty(p, ctxt, bean2, propName);
            } else if (!ext.handlePropertyValue(p, ctxt, propName, bean2)) {
                if (this._anySetter != null) {
                    try {
                        this._anySetter.deserializeAndSet(p, ctxt, bean2, propName);
                    }
                    catch (Exception e3) {
                        this.wrapAndThrow(e3, bean2, propName, ctxt);
                    }
                } else {
                    this.handleUnknownProperty(p, ctxt, bean2, propName);
                }
            }
            t3 = p.nextToken();
        }
        return ext.complete(p, ctxt, bean2);
    }

    protected Object deserializeUsingPropertyBasedWithExternalTypeId(JsonParser p, DeserializationContext ctxt) throws IOException {
        ExternalTypeHandler ext = this._externalTypeIdHandler.start();
        PropertyBasedCreator creator = this._propertyBasedCreator;
        PropertyValueBuffer buffer = creator.startBuilding(p, ctxt, this._objectIdReader);
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        JsonToken t3 = p.currentToken();
        while (t3 == JsonToken.FIELD_NAME) {
            block20: {
                String propName = p.currentName();
                t3 = p.nextToken();
                SettableBeanProperty creatorProp = creator.findCreatorProperty(propName);
                if (!buffer.readIdProperty(propName) || creatorProp != null) {
                    if (creatorProp != null) {
                        if (!ext.handlePropertyValue(p, ctxt, propName, null) && buffer.assignParameter(creatorProp, this._deserializeWithErrorWrapping(p, ctxt, creatorProp))) {
                            Object bean2;
                            t3 = p.nextToken();
                            try {
                                bean2 = creator.build(ctxt, buffer);
                            }
                            catch (Exception e2) {
                                this.wrapAndThrow(e2, this._beanType.getRawClass(), propName, ctxt);
                                break block20;
                            }
                            if (bean2.getClass() != this._beanType.getRawClass()) {
                                return ctxt.reportBadDefinition(this._beanType, String.format("Cannot create polymorphic instances with external type ids (%s -> %s)", this._beanType, bean2.getClass()));
                            }
                            return this._deserializeWithExternalTypeId(p, ctxt, bean2, ext);
                        }
                    } else {
                        SettableBeanProperty prop = this._beanProperties.find(propName);
                        if (prop != null) {
                            if (t3.isScalarValue()) {
                                ext.handleTypePropertyValue(p, ctxt, propName, null);
                            }
                            if (activeView != null && !prop.visibleInView(activeView)) {
                                p.skipChildren();
                            } else {
                                buffer.bufferProperty(prop, prop.deserialize(p, ctxt));
                            }
                        } else if (!ext.handlePropertyValue(p, ctxt, propName, null)) {
                            if (IgnorePropertiesUtil.shouldIgnore(propName, this._ignorableProps, this._includableProps)) {
                                this.handleIgnoredProperty(p, ctxt, this.handledType(), propName);
                            } else if (this._anySetter != null) {
                                buffer.bufferAnyProperty(this._anySetter, propName, this._anySetter.deserialize(p, ctxt));
                            } else {
                                this.handleUnknownProperty(p, ctxt, this._valueClass, propName);
                            }
                        }
                    }
                }
            }
            t3 = p.nextToken();
        }
        try {
            return ext.complete(p, ctxt, buffer, creator);
        }
        catch (Exception e3) {
            return this.wrapInstantiationProblem(e3, ctxt);
        }
    }

    protected Exception _creatorReturnedNullException() {
        if (this._nullFromCreator == null) {
            this._nullFromCreator = new NullPointerException("JSON Creator returned null");
        }
        return this._nullFromCreator;
    }

    static class BeanReferring
    extends ReadableObjectId.Referring {
        private final DeserializationContext _context;
        private final SettableBeanProperty _prop;
        private Object _bean;

        BeanReferring(DeserializationContext ctxt, UnresolvedForwardReference ref2, JavaType valueType, PropertyValueBuffer buffer, SettableBeanProperty prop) {
            super(ref2, valueType);
            this._context = ctxt;
            this._prop = prop;
        }

        public void setBean(Object bean2) {
            this._bean = bean2;
        }

        @Override
        public void handleResolvedForwardReference(Object id, Object value) throws IOException {
            if (this._bean == null) {
                this._context.reportInputMismatch(this._prop, "Cannot resolve ObjectId forward reference using property '%s' (of type %s): Bean not yet resolved", this._prop.getName(), this._prop.getDeclaringClass().getName());
            }
            this._prop.set(this._bean, value);
        }
    }
}

